import { jsx as _jsx } from "react/jsx-runtime";
import { useEffect } from "react";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { EmbeddedWorkflowDefinitionList } from "@kie-tools/runtime-tools-swf-enveloped-components/dist/workflowDefinitions";
import { useWorkflowDefinitionListGatewayApi } from "../WorkflowDefinitionList";
export const WorkflowDefinitionListContainer = ({ onOpenWorkflowForm, onOpenTriggerCloudEventForWorkflow, ouiaId, ouiaSafe, targetOrigin, }) => {
    const gatewayApi = useWorkflowDefinitionListGatewayApi();
    useEffect(() => {
        const onOpenDefinitionUnsubscriber = gatewayApi.onOpenWorkflowFormListen({
            onOpen(workflowDefinition) {
                onOpenWorkflowForm(workflowDefinition);
            },
        });
        const onTriggerCloudEventUnsubscriber = gatewayApi.onOpenTriggerCloudEventListen({
            onOpen(workflowDefinition) {
                onOpenTriggerCloudEventForWorkflow(workflowDefinition);
            },
        });
        return () => {
            onOpenDefinitionUnsubscriber.unSubscribe();
            onTriggerCloudEventUnsubscriber.unSubscribe();
        };
    }, [gatewayApi, onOpenWorkflowForm, onOpenTriggerCloudEventForWorkflow]);
    return (_jsx(EmbeddedWorkflowDefinitionList, { ...componentOuiaProps(ouiaId, "workflow-definitions-container", ouiaSafe), driver: gatewayApi, targetOrigin: targetOrigin || window.location.origin }));
};
//# sourceMappingURL=WorkflowDefinitionListContainer.js.map