import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback, useMemo, useEffect, useRef } from "react";
import * as _ from "lodash";
import { useBoxedExpressionEditorI18n } from "../../i18n";
import { NavigationKeysUtils } from "../../keysUtils/keyUtils";
import { useBeeTableSelectableCellRef } from "../../selection/BeeTableSelectionContext";
export const InlineEditableTextInput = ({ rowIndex, columnIndex, value, setActiveCellEditing, onChange, isReadOnly, }) => {
    const { i18n } = useBoxedExpressionEditorI18n();
    const inputRef = useRef(null);
    const { isEditing } = useBeeTableSelectableCellRef(rowIndex, columnIndex, onChange, useCallback(() => value, [value]));
    const stopEditingPersistingValue = useCallback(() => {
        var _a;
        const newValue = (_a = inputRef.current) === null || _a === void 0 ? void 0 : _a.value;
        if (newValue && newValue !== value) {
            onChange(newValue);
        }
        setActiveCellEditing(false);
    }, [onChange, setActiveCellEditing, value]);
    const onInputKeyDown = useMemo(() => (e) => {
        e.stopPropagation();
        if (NavigationKeysUtils.isEnter(e.key)) {
            stopEditingPersistingValue();
        }
        if (NavigationKeysUtils.isEsc(e.key)) {
            setActiveCellEditing(false);
        }
    }, [setActiveCellEditing, stopEditingPersistingValue]);
    const onLabelClick = useCallback(() => {
        setActiveCellEditing(true);
    }, [setActiveCellEditing]);
    const textStyle = useMemo(() => {
        if (_.isEmpty(value)) {
            return { fontStyle: "italic", cursor: "pointer", color: "gray" };
        }
        else {
            return { cursor: "pointer" };
        }
    }, [value]);
    useEffect(() => {
        var _a;
        if (isEditing) {
            (_a = inputRef.current) === null || _a === void 0 ? void 0 : _a.select();
        }
    });
    return !isEditing || isReadOnly ? (_jsx("p", { className: "inline-editable-preview pf-u-text-truncate", style: { ...textStyle, width: "100%" }, onClick: isReadOnly ? undefined : onLabelClick, children: value || i18n.enterText })) : (_jsx("input", { style: { width: "100%" }, ref: inputRef, type: "text", autoFocus: true, defaultValue: value, onBlur: stopEditingPersistingValue, onKeyDown: onInputKeyDown }));
};
//# sourceMappingURL=InlineEditableTextInput.js.map