import * as ReactTable from "react-table";
import { ResizerStopBehavior } from "../../resizing/ResizingWidthsContext";
import { InsertRowColumnsDirection } from "../../api";
export interface BeeTableTdProps<R extends object> {
    onRowAdded?: (args: {
        beforeIndex: number;
        rowsCount: number;
        insertDirection: InsertRowColumnsDirection;
    }) => void;
    isActive: boolean;
    shouldRenderInlineButtons: boolean;
    shouldShowRowsInlineControls: boolean;
    rowIndex: number;
    row: ReactTable.Row<R>;
    columnIndex: number;
    column: ReactTable.ColumnInstance<R>;
    resizerStopBehavior: ResizerStopBehavior;
    lastColumnMinWidth?: number;
    onDataCellClick?: (columnID: string) => void;
    onDataCellKeyUp?: (columnID: string) => void;
    isReadOnly: boolean;
    canDisplayEvaluationHitsCountBadge?: boolean;
    evaluationHitsCount?: number;
}
export type HoverInfo = {
    isHovered: false;
} | {
    isHovered: true;
    part: "upper" | "lower";
};
export declare function BeeTableTd<R extends object>({ columnIndex, row, column, rowIndex, shouldRenderInlineButtons, shouldShowRowsInlineControls, resizerStopBehavior, onRowAdded, lastColumnMinWidth, onDataCellClick, onDataCellKeyUp, isReadOnly, canDisplayEvaluationHitsCountBadge, evaluationHitsCount, }: BeeTableTdProps<R>): JSX.Element;
//# sourceMappingURL=BeeTableTd.d.ts.map