import { jsx as _jsx } from "react/jsx-runtime";
import { useBeeTableCoordinates, useBeeTableSelectableCellRef } from "../../selection/BeeTableSelectionContext";
import { useCallback, useEffect } from "react";
import { useBoxedExpressionEditor } from "../../BoxedExpressionEditorContext";
export const BeeTableReadOnlyCell = ({ value }) => {
    var _a, _b;
    const { containerCellCoordinates } = useBeeTableCoordinates();
    const getValue = useCallback(() => {
        return value;
    }, [value]);
    const { isActive } = useBeeTableSelectableCellRef((_a = containerCellCoordinates === null || containerCellCoordinates === void 0 ? void 0 : containerCellCoordinates.rowIndex) !== null && _a !== void 0 ? _a : 0, (_b = containerCellCoordinates === null || containerCellCoordinates === void 0 ? void 0 : containerCellCoordinates.columnIndex) !== null && _b !== void 0 ? _b : 0, undefined, getValue);
    const { beeGwtService } = useBoxedExpressionEditor();
    useEffect(() => {
        if (isActive) {
            beeGwtService === null || beeGwtService === void 0 ? void 0 : beeGwtService.selectObject("");
        }
    }, [beeGwtService, isActive]);
    return _jsx("div", { children: value });
};
//# sourceMappingURL=BeeTableReadOnlyCell.js.map