import { jsx as _jsx } from "react/jsx-runtime";
import { useEffect } from "react";
import { Action } from "../../api";
import { useBoxedExpressionEditor, useBoxedExpressionEditorDispatch } from "../../BoxedExpressionEditorContext";
import { InlineEditableTextInput } from "../../table/BeeTable/InlineEditableTextInput";
import { useBeeTableSelectableCellRef } from "../../selection/BeeTableSelectionContext";
export function IteratorExpressionVariableCell({ rowIndex, columnIndex, currentElementId, data, beeTableRef, }) {
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const { isActive } = useBeeTableSelectableCellRef(rowIndex !== null && rowIndex !== void 0 ? rowIndex : 0, columnIndex !== null && columnIndex !== void 0 ? columnIndex : 0, undefined);
    const { beeGwtService, isReadOnly } = useBoxedExpressionEditor();
    useEffect(() => {
        if (isActive) {
            beeGwtService === null || beeGwtService === void 0 ? void 0 : beeGwtService.selectObject(`${currentElementId}-iteratorVariable`);
        }
    }, [beeGwtService, isActive, currentElementId]);
    return (_jsx("div", { style: {
            minHeight: "60px",
            display: "flex",
            alignItems: "center",
            justifyContent: "center",
        }, children: _jsx(InlineEditableTextInput, { value: data[rowIndex].child, onChange: (updatedValue) => {
                const expressionChangedArgs = data[rowIndex].child === ""
                    ? {
                        action: Action.IteratorVariableDefined,
                    }
                    : {
                        action: Action.VariableChanged,
                        variableUuid: currentElementId,
                        nameChange: {
                            from: data[rowIndex].child,
                            to: updatedValue,
                        },
                    };
                setExpression({
                    setExpressionAction: (prev) => {
                        const ret = {
                            ...prev,
                            "@_iteratorVariable": updatedValue,
                        };
                        return ret;
                    },
                    expressionChangedArgs,
                });
            }, rowIndex: rowIndex, columnIndex: columnIndex, setActiveCellEditing: (value) => {
                var _a;
                (_a = beeTableRef.current) === null || _a === void 0 ? void 0 : _a.setActiveCellEditing(value);
            }, isReadOnly: isReadOnly !== null && isReadOnly !== void 0 ? isReadOnly : false }) }));
}
//# sourceMappingURL=IteratorExpressionVariableCell.js.map