import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback } from "react";
import { NestedExpressionDispatchContextProvider, useBoxedExpressionEditorDispatch, } from "../../BoxedExpressionEditorContext";
import { ExpressionContainer } from "../ExpressionDefinitionRoot/ExpressionContainer";
import "./FilterExpression.css";
export function FilterExpressionCollectionCell({ rowIndex, data: items, columnIndex, parentElementId, }) {
    var _a;
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const onSetExpression = useCallback(({ getNewExpression, expressionChangedArgs }) => {
        setExpression({
            setExpressionAction: (prev) => {
                return {
                    ...prev,
                    in: {
                        ...prev.in,
                        expression: getNewExpression(prev.in.expression),
                    },
                };
            },
            expressionChangedArgs,
        });
    }, [setExpression]);
    return (_jsx("div", { className: "filter-expression", "data-testid": "kie-tools--bee--filter-collection-in", children: _jsx(NestedExpressionDispatchContextProvider, { onSetExpression: onSetExpression, children: _jsx(ExpressionContainer, { expression: (_a = items[rowIndex]) === null || _a === void 0 ? void 0 : _a.expression, isResetSupported: true, isNested: true, rowIndex: rowIndex, columnIndex: columnIndex, parentElementId: parentElementId, parentElementTypeRef: undefined }) }) }));
}
//# sourceMappingURL=FilterExpressionCollectionCell.js.map