import { jsxs as _jsxs, jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import * as React from "react";
import { useCallback, useMemo } from "react";
import { PopoverMenu } from "../../contextMenu/PopoverMenu";
import { PopoverPosition } from "@patternfly/react-core/dist/js/components/Popover";
import * as _ from "lodash";
import { useBoxedExpressionEditorI18n } from "../../i18n";
import { useBoxedExpressionEditor } from "../../BoxedExpressionEditorContext";
import { MenuItemWithHelp } from "../../contextMenu/MenuWithHelp";
import { Menu } from "@patternfly/react-core/dist/js/components/Menu/Menu";
import { MenuGroup } from "@patternfly/react-core/dist/js/components/Menu/MenuGroup";
import { MenuList } from "@patternfly/react-core/dist/js/components/Menu/MenuList";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import "./HitPolicySelector.css";
export const HIT_POLICIES_THAT_SUPPORT_AGGREGATION = ["COLLECT"];
export function HitPolicySelector({ onBuiltInAggregatorSelected, onHitPolicySelected, selectedBuiltInAggregator, selectedHitPolicy, isReadOnly, }) {
    var _a;
    const { i18n } = useBoxedExpressionEditorI18n();
    const { editorRef } = useBoxedExpressionEditor();
    const builtInAggregatorEnabled = useMemo(() => HIT_POLICIES_THAT_SUPPORT_AGGREGATION.includes(selectedHitPolicy), [selectedHitPolicy]);
    const hitPolicyHelp = useCallback((hitPolicyKey) => {
        switch (hitPolicyKey) {
            case "UNIQUE":
                return i18n.hitPolicyHelp.unique;
            case "FIRST":
                return i18n.hitPolicyHelp.first;
            case "PRIORITY":
                return i18n.hitPolicyHelp.priority;
            case "ANY":
                return i18n.hitPolicyHelp.any;
            case "COLLECT":
                return i18n.hitPolicyHelp.collect;
            case "RULE ORDER":
                return i18n.hitPolicyHelp.ruleOrder;
            case "OUTPUT ORDER":
                return i18n.hitPolicyHelp.outputOrder;
            default:
                return i18n.hitPolicyHelp.unique;
        }
    }, [
        i18n.hitPolicyHelp.unique,
        i18n.hitPolicyHelp.first,
        i18n.hitPolicyHelp.priority,
        i18n.hitPolicyHelp.any,
        i18n.hitPolicyHelp.collect,
        i18n.hitPolicyHelp.ruleOrder,
        i18n.hitPolicyHelp.outputOrder,
    ]);
    const aggregatorHelp = useCallback((aggregatorKey) => {
        switch (aggregatorKey) {
            case "+":
                return i18n.builtInAggregatorHelp.sum;
            case "#":
                return i18n.builtInAggregatorHelp.count;
            case "<":
                return i18n.builtInAggregatorHelp.min;
            case ">":
                return i18n.builtInAggregatorHelp.max;
            default:
                return i18n.builtInAggregatorHelp.none;
        }
    }, [
        i18n.builtInAggregatorHelp.sum,
        i18n.builtInAggregatorHelp.count,
        i18n.builtInAggregatorHelp.min,
        i18n.builtInAggregatorHelp.max,
        i18n.builtInAggregatorHelp.none,
    ]);
    const hitPolicySelectionCallback = useCallback((event, itemId) => {
        event.stopPropagation();
        onHitPolicySelected(itemId);
    }, [onHitPolicySelected]);
    const builtInAggregatorSelectionCallback = useCallback((event, itemId) => {
        event.stopPropagation();
        onBuiltInAggregatorSelected(itemId);
    }, [onBuiltInAggregatorSelected]);
    const [visibleHelpHitPolicy, setVisibleHelpHitPolicy] = React.useState("");
    const toggleVisibleHelpHitPolicy = useCallback((help) => {
        setVisibleHelpHitPolicy((previousHelp) => (previousHelp !== help ? help : ""));
    }, []);
    const [visibleHelpAggregatorFunction, setVisibleHelpAggregatorFunction] = React.useState("");
    const toggleVisibleHelpAggregatorFunction = useCallback((help) => {
        setVisibleHelpAggregatorFunction((previousHelp) => (previousHelp !== help ? help : ""));
    }, []);
    const hitPolicyCell = useMemo(() => {
        return (_jsxs("div", { className: "selected-hit-policy", "data-testid": "kie-tools--bee--selected-hit-policy", children: [!builtInAggregatorEnabled && `${_.first(selectedHitPolicy)}`, builtInAggregatorEnabled && `${_.first(selectedHitPolicy)}${selectedBuiltInAggregator}`] }));
    }, [builtInAggregatorEnabled, selectedBuiltInAggregator, selectedHitPolicy]);
    return isReadOnly ? (hitPolicyCell) : (_jsx(PopoverMenu, { onHide: () => {
            setVisibleHelpAggregatorFunction("");
            setVisibleHelpHitPolicy("");
        }, appendTo: (_a = editorRef.current) !== null && _a !== void 0 ? _a : undefined, className: "hit-policy-popover", hasAutoWidth: true, position: PopoverPosition.left, distance: 25, body: _jsxs("div", { className: "hit-policy-flex-container", "data-testid": "kie-tools--bee--hit-policy-header", children: [_jsx("div", { className: "hit-policy-section", children: _jsx(Menu, { onSelect: hitPolicySelectionCallback, selected: selectedHitPolicy, children: _jsx(MenuGroup, { className: "menu-with-help", label: "Hit policy", children: _jsx(MenuList, { children: _jsx(_Fragment, { children: ["UNIQUE", "FIRST", "PRIORITY", "ANY", "COLLECT", "RULE ORDER", "OUTPUT ORDER"].map((hitPolicy) => {
                                        return (_jsx(MenuItemWithHelp, { menuItemKey: hitPolicy, menuItemHelp: hitPolicyHelp(hitPolicy), setVisibleHelp: toggleVisibleHelpHitPolicy, visibleHelp: visibleHelpHitPolicy }, hitPolicy));
                                    }) }) }) }) }) }), selectedHitPolicy === "COLLECT" && (_jsxs(_Fragment, { children: [_jsx(Divider, { isVertical: true }), _jsx("div", { className: "hit-policy-aggregator-section", children: _jsx(Menu, { onSelect: builtInAggregatorSelectionCallback, selected: selectedBuiltInAggregator, children: _jsx(MenuGroup, { className: "menu-with-help", label: "Aggregator function", children: _jsx(MenuList, { children: _jsx(_Fragment, { children: [
                                                ["<None>", "?"],
                                                ["SUM", "+"],
                                                ["COUNT", "#"],
                                                ["MIN", "<"],
                                                ["MAX", ">"],
                                            ].map((agg) => (_jsx(MenuItemWithHelp, { menuItemKey: agg[1], menuItemCustomText: agg[0], menuItemHelp: aggregatorHelp(agg[1]), setVisibleHelp: toggleVisibleHelpAggregatorFunction, visibleHelp: visibleHelpAggregatorFunction }, agg[0]))) }) }) }) }) })] }))] }), children: hitPolicyCell }));
}
//# sourceMappingURL=HitPolicySelector.js.map