import { FunctionResultType } from "../function";
import { MessageType } from "../message";
import { MessageProperty } from "../message/MessageProperty";
export class DashbuilderComponentController {
    constructor(bus, componentId) {
        this.bus = bus;
        this.componentId = componentId;
        this.callbacks = new Map();
        this.onInit = (p) => {
            console.debug("Received INIT.");
            console.debug(p);
        };
        this.onDataSet = (ds) => {
            console.debug("Received DataSet.");
            console.debug(ds);
        };
    }
    init(params) {
        this.componentId = params.get(MessageProperty.COMPONENT_ID);
        this.onInit(params);
    }
    setOnDataSet(onDataSet) {
        this.onDataSet = onDataSet;
    }
    setOnInit(onInit) {
        this.onInit = onInit;
    }
    ready() {
    }
    requireConfigurationFix(message) {
        const props = new Map();
        props.set(MessageProperty.CONFIGURATION_ISSUE, message);
        this.bus.send(this.componentId, {
            type: MessageType.FIX_CONFIGURATION,
            properties: props,
        });
    }
    configurationOk() {
        this.bus.send(this.componentId, {
            type: MessageType.CONFIGURATION_OK,
            properties: new Map(),
        });
    }
    filter(filterRequest) {
        const props = new Map();
        props.set(MessageProperty.FILTER, filterRequest);
        this.bus.send(this.componentId, {
            type: MessageType.FILTER,
            properties: props,
        });
    }
    callFunction(functionCallRequest) {
        const props = new Map();
        props.set(MessageProperty.FUNCTION_CALL, functionCallRequest);
        this.bus.send(this.componentId, {
            type: MessageType.FUNCTION_CALL,
            properties: props,
        });
        return new Promise((resolve, error) => {
            const key = this.buildFunctionKey(functionCallRequest);
            this.callbacks.set(key, {
                onSucess: resolve,
                onError: error,
            });
        });
    }
    receiveFunctionResponse(functionResponse) {
        const key = this.buildFunctionKey(functionResponse.request);
        const functionCallbacks = this.callbacks.get(key);
        if (functionCallbacks) {
            if (functionResponse.resultType === FunctionResultType.ERROR ||
                functionResponse.resultType === FunctionResultType.NOT_FOUND) {
                functionCallbacks.onError(functionResponse.message);
            }
            else {
                functionCallbacks.onSucess(functionResponse.result);
            }
        }
        else {
            console.warn("Callbacks for function call not found. Key: " + key);
        }
        this.callbacks.delete(key);
    }
    setComponentBus(bus) {
        this.bus = bus;
    }
    buildFunctionKey(functionRequest) {
        return functionRequest.functionName;
    }
}
//# sourceMappingURL=DashbuilderComponentController.js.map