import { EnvelopeClient } from "@kie-tools-core/envelope-bus/dist/envelope";
import { ContainerType } from "./api";
export class Envelope {
    constructor(bus, config = { containerType: ContainerType.IFRAME }, envelopeClient = new EnvelopeClient(bus, config.containerType === ContainerType.DIV ? config.envelopeId : undefined)) {
        this.envelopeClient = envelopeClient;
    }
    get channelApi() {
        return this.envelopeClient.channelApi;
    }
    get shared() {
        return this.envelopeClient.shared;
    }
    async start(viewDelegate, envelopeContext, apiFactory) {
        const apiImpl = apiFactory.create({
            viewDelegate,
            envelopeContext,
            envelopeClient: this.envelopeClient,
        });
        this.envelopeClient.startListening(apiImpl);
        return this.envelopeClient;
    }
}
//# sourceMappingURL=Envelope.js.map