import * as React from "react";
import * as DmnEditor from "@kie-tools/dmn-editor/dist/DmnEditor";
import { Normalized } from "@kie-tools/dmn-marshaller/dist/normalization/normalize";
import { DMN_LATEST_VERSION, DmnLatestModel, DmnMarshaller } from "@kie-tools/dmn-marshaller";
import { WorkspaceChannelApi, WorkspaceEdit } from "@kie-tools-core/workspace/dist/api";
import { KeyboardShortcutsService } from "@kie-tools-core/keyboard-shortcuts/dist/envelope/KeyboardShortcutsService";
import { JavaCodeCompletionAccessor, JavaCodeCompletionClass } from "@kie-tools-core/vscode-java-code-completion/dist/api";
export declare const EXTERNAL_MODELS_SEARCH_GLOB_PATTERN = "**/*.{dmn,pmml}";
export declare const TARGET_DIRECTORY = "target/classes/";
export declare const EMPTY_DMN: () => string;
export interface JavaCodeCompletionExposedInteropApi {
    getFields(fqcn: string): Promise<JavaCodeCompletionAccessor[]>;
    getClasses(query: string): Promise<JavaCodeCompletionClass[]>;
    isLanguageServerAvailable(): Promise<boolean>;
}
export type DmnEditorRootProps = {
    exposing: (s: DmnEditorRoot) => void;
    onNewEdit: (edit: WorkspaceEdit) => void;
    onRequestWorkspaceFilesList: WorkspaceChannelApi["kogitoWorkspace_resourceListRequest"];
    onRequestWorkspaceFileContent: WorkspaceChannelApi["kogitoWorkspace_resourceContentRequest"];
    onOpenFileFromNormalizedPosixPathRelativeToTheWorkspaceRoot: WorkspaceChannelApi["kogitoWorkspace_openFile"];
    onOpenedBoxedExpressionEditorNodeChange?: (newOpenedNodeId: string | undefined) => void;
    workspaceRootAbsolutePosixPath: string;
    keyboardShortcutsService: KeyboardShortcutsService | undefined;
    isEvaluationHighlightsSupported?: boolean;
    isReadOnly: boolean;
    isImportDataTypesFromJavaClassesSupported?: boolean;
    javaCodeCompletionService?: JavaCodeCompletionExposedInteropApi;
};
export type DmnEditorRootState = {
    marshaller: DmnMarshaller<typeof DMN_LATEST_VERSION> | undefined;
    stack: Normalized<DmnLatestModel>[];
    pointer: number;
    openFileNormalizedPosixPathRelativeToTheWorkspaceRoot: string | undefined;
    externalModelsByNamespace: DmnEditor.ExternalModelsIndex;
    isReadOnly: boolean;
    externalModelsManagerDoneBootstraping: boolean;
    keyboardShortcutsRegisterIds: number[];
    keyboardShortcutsRegistered: boolean;
    error: Error | undefined;
    evaluationResultsByNodeId: DmnEditor.EvaluationResultsByNodeId;
};
export declare class DmnEditorRoot extends React.Component<DmnEditorRootProps, DmnEditorRootState> {
    private readonly externalModelsManagerDoneBootstraping;
    private readonly dmnEditorRef;
    constructor(props: DmnEditorRootProps);
    openBoxedExpressionEditor(nodeId: string): void;
    showDmnEvaluationResults(evaluationResultsByNodeId: DmnEditor.EvaluationResultsByNodeId): void;
    undo(): Promise<void>;
    redo(): Promise<void>;
    getDiagramSvg(): Promise<string | undefined>;
    getContent(): Promise<string>;
    setContent(openFileNormalizedPosixPathRelativeToTheWorkspaceRoot: string, content: string): Promise<void>;
    get model(): Normalized<DmnLatestModel> | undefined;
    private getMarshaller;
    private setExternalModelsByNamespace;
    private onModelChange;
    private onRequestExternalModelsAvailableToInclude;
    private onRequestToResolvePathRelativeToTheOpenFile;
    private onRequestExternalModelByPathsRelativeToTheOpenFile;
    private onOpenFileFromPathRelativeToTheOpenFile;
    componentDidUpdate(prevProps: Readonly<DmnEditorRootProps>, prevState: Readonly<DmnEditorRootState>, snapshot?: any): void;
    componentWillUnmount(): void;
    render(): JSX.Element;
}
//# sourceMappingURL=DmnEditorRoot.d.ts.map