export function fetchFile(octokit, org, repo, ref, path, contentType) {
    return octokit.repos
        .getContent({
        repo: repo,
        owner: org,
        ref: ref,
        path: path,
    })
        .then((res) => (contentType === "binary" ? res.data.content : atob(res.data.content)))
        .catch((e) => {
        console.debug(`Error fetching ${path} with Octokit. Fallback is 'raw.githubusercontent.com'.`);
        return fetch(`https://raw.githubusercontent.com/${org}/${repo}/${ref}/${path}`).then((res) => res.ok ? res.text() : Promise.resolve(undefined));
    });
}
//# sourceMappingURL=api.js.map