import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useLayoutEffect, useMemo, useState } from "react";
import * as ReactDOM from "react-dom";
import { FullScreenToolbar } from "./FullScreenToolbar";
import { SingleEditorToolbar } from "./SingleEditorToolbar";
import { useIsolatedEditorTogglingEffect } from "../common/customEffects";
import { IsolatedEditorContext } from "../common/IsolatedEditorContext";
import { iframeFullscreenContainer } from "../../utils";
import { IsolatedEditor } from "../common/IsolatedEditor";
import { useGlobals } from "../common/GlobalContext";
import { useIsolatedEditorRef } from "../common/IsolatedEditorRef";
function useFullScreenEditorTogglingEffect(fullscreen) {
    const globals = useGlobals();
    useLayoutEffect(() => {
        if (!fullscreen) {
            iframeFullscreenContainer(globals.id, globals.dependencies.all.body()).classList.add("hidden");
        }
        else {
            iframeFullscreenContainer(globals.id, globals.dependencies.all.body()).classList.remove("hidden");
        }
    }, [fullscreen, globals.dependencies.all, globals.id]);
}
export function SingleEditorApp(props) {
    const [textMode, setTextMode] = useState(false);
    const [errorOpeningFile, setErrorOpeningFile] = useState(false);
    const [textModeAvailable, setTextModeAvailable] = useState(false);
    const [fullscreen, setFullscreen] = useState(false);
    const globals = useGlobals();
    const { isolatedEditor, isolatedEditorRef } = useIsolatedEditorRef();
    useFullScreenEditorTogglingEffect(fullscreen);
    useIsolatedEditorTogglingEffect(textMode, props.iframeContainer, props.githubTextEditorToReplace);
    const onSetContentError = useCallback(() => {
        setErrorOpeningFile(true);
    }, []);
    const IsolatedEditorComponent = useMemo(() => (_jsx(IsolatedEditor, { ref: isolatedEditorRef, getFileContents: props.getFileContents, contentPath: props.fileInfo.path, openFileExtension: props.openFileExtension, textMode: textMode, readonly: props.readonly, keepRenderedEditorInTextMode: true, onSetContentError: onSetContentError })), [
        isolatedEditorRef,
        props.getFileContents,
        props.fileInfo.path,
        props.openFileExtension,
        props.readonly,
        textMode,
        onSetContentError,
    ]);
    const exitFullScreen = useCallback(() => {
        setFullscreen(false);
        setTextModeAvailable(false);
        globals.dependencies.all.showDocumentBody();
    }, [globals.dependencies.all]);
    const deactivateTextMode = useCallback(() => {
        setTextMode(false);
        setErrorOpeningFile((prev) => (props.readonly ? prev : false));
    }, [props.readonly]);
    const activateTextMode = useCallback(() => {
        setTextMode(true);
    }, []);
    const goFullScreen = useCallback(() => {
        setFullscreen(true);
        globals.dependencies.all.hideDocumentBody();
    }, [globals.dependencies.all]);
    const { getFileContents, getFileName } = props;
    const openExternalEditor = useMemo(() => {
        var _a;
        return ((_a = globals.externalEditorManager) === null || _a === void 0 ? void 0 : _a.open) &&
            (() => {
                getFileContents().then((fileContent) => {
                    var _a, _b;
                    (_b = (_a = globals.externalEditorManager) === null || _a === void 0 ? void 0 : _a.open) === null || _b === void 0 ? void 0 : _b.call(_a, getFileName(), fileContent, props.readonly);
                });
            });
    }, [globals.externalEditorManager, getFileContents, getFileName, props.readonly]);
    const linkToExternalEditor = useMemo(() => {
        var _a, _b;
        return (_b = (_a = globals.externalEditorManager) === null || _a === void 0 ? void 0 : _a.getLink) === null || _b === void 0 ? void 0 : _b.call(_a, `${props.fileInfo.org}/${props.fileInfo.repo}/${props.fileInfo.gitRef}/${props.fileInfo.path}`);
    }, [globals.externalEditorManager, props.fileInfo]);
    const onEditorReady = useCallback(() => {
        setTextModeAvailable(true);
    }, []);
    const repoInfo = useMemo(() => {
        return {
            gitref: props.fileInfo.gitRef,
            owner: props.fileInfo.org,
            repo: props.fileInfo.repo,
        };
    }, [props.fileInfo.gitRef, props.fileInfo.org, props.fileInfo.repo]);
    return (_jsx(_Fragment, { children: _jsxs(IsolatedEditorContext.Provider, { value: {
                onEditorReady: onEditorReady,
                fullscreen: fullscreen,
                textMode: textMode,
                repoInfo: repoInfo,
            }, children: [!fullscreen && (_jsxs(_Fragment, { children: [ReactDOM.createPortal(IsolatedEditorComponent, props.iframeContainer), ReactDOM.createPortal(_jsx(SingleEditorToolbar, { textMode: textMode, textModeAvailable: textModeAvailable, onSeeAsDiagram: deactivateTextMode, onSeeAsSource: activateTextMode, onOpenInExternalEditor: openExternalEditor, linkToExternalEditor: linkToExternalEditor, onFullScreen: goFullScreen, readonly: props.readonly, errorOpeningFile: errorOpeningFile }), props.toolbarContainer)] })), fullscreen && (_jsxs(_Fragment, { children: [ReactDOM.createPortal(_jsx(FullScreenToolbar, { onExitFullScreen: exitFullScreen }), iframeFullscreenContainer(globals.id, globals.dependencies.all.body())), ReactDOM.createPortal(IsolatedEditorComponent, iframeFullscreenContainer(globals.id, globals.dependencies.all.body()))] }))] }) }));
}
//# sourceMappingURL=SingleEditorApp.js.map