import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useMemo } from "react";
import { useGlobals } from "../common/GlobalContext";
import { parsePrInfo } from "../pr/prEditors";
import { GitHubPageType } from "../../github/GitHubPageType";
export function OpenInExternalEditorButton(props) {
    var _a, _b;
    const globals = useGlobals();
    const repoUrl = useMemo(() => {
        if (props.pageType === GitHubPageType.PR_HOME ||
            props.pageType === GitHubPageType.PR_FILES ||
            props.pageType === GitHubPageType.PR_COMMITS) {
            const prInfo = parsePrInfo(globals.dependencies);
            return `${window.location.origin}/${prInfo.org}/${prInfo.repo}/tree/${prInfo.gitRef}`;
        }
        return window.location.href;
    }, [globals.dependencies, props.pageType]);
    return (_jsx(_Fragment, { children: ((_a = globals.externalEditorManager) === null || _a === void 0 ? void 0 : _a.getImportRepoUrl) && (_jsxs("a", { className: props.className, href: (_b = globals.externalEditorManager) === null || _b === void 0 ? void 0 : _b.getImportRepoUrl(repoUrl), target: "_blank", children: [_jsx("img", { alt: "ext-logo", src: globals.extensionIconUrl }), "Open in ", globals.externalEditorManager.name] })) }));
}
//# sourceMappingURL=OpenInExternalEditorButton.js.map