import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useCallback, useEffect, useRef, useState } from "react";
import { getGitHubApiBaseUrl, useGitHubApi } from "./GitHubContext";
import { Octokit } from "@octokit/rest";
import { useGlobals } from "./GlobalContext";
import { useChromeExtensionI18n } from "../../i18n";
import { I18nHtml } from "@kie-tools-core/i18n/dist/react-components";
const GITHUB_OAUTH_TOKEN_SIZE = 40;
export function KogitoMenu() {
    const gitHubApi = useGitHubApi();
    const isAuthenticated = !!gitHubApi.token;
    const { i18n } = useChromeExtensionI18n();
    const inputRef = useRef(null);
    const [isWholeMenuOpen, setWholeMenuOpen] = useState(false);
    const [isInfoPopOverOpen, setInfoPopOverOpen] = useState(false);
    const [potentialToken, setPotentialToken] = useState("");
    const updateToken = useCallback(async (token) => {
        const validToken = await tokenIsValid(token);
        if (validToken) {
            gitHubApi.setToken(token);
            setPotentialToken("");
        }
        else {
            gitHubApi.setToken("");
        }
        return validToken;
    }, [gitHubApi]);
    useEffect(() => {
        updateToken(gitHubApi.token).then(() => {
            console.debug("Checked GitHub token.");
        });
    }, [gitHubApi.token, updateToken]);
    const onPaste = useCallback((e) => {
        const token = e.clipboardData.getData("text/plain").slice(0, GITHUB_OAUTH_TOKEN_SIZE);
        setPotentialToken(token);
        setTimeout(async () => {
            const wasValid = await updateToken(token);
            if (wasValid) {
                setTimeout(() => setWholeMenuOpen(false), 2000);
            }
            inputRef.current.setSelectionRange(0, 0);
        }, 0);
    }, [updateToken, setPotentialToken, setWholeMenuOpen]);
    const onReset = useCallback(() => {
        gitHubApi.setToken("");
        setPotentialToken("");
        setTimeout(() => {
            inputRef.current.focus();
        }, 0);
    }, [gitHubApi]);
    const toggleInfoPopOver = useCallback(() => {
        setInfoPopOverOpen(!isInfoPopOverOpen);
    }, [isInfoPopOverOpen]);
    const toggleMenu = useCallback(() => {
        setWholeMenuOpen(!isWholeMenuOpen);
    }, [isWholeMenuOpen]);
    const tokenToDisplay = obfuscate(gitHubApi.token || potentialToken);
    const globals = useGlobals();
    return (_jsxs(_Fragment, { children: [isWholeMenuOpen && (_jsxs(_Fragment, { children: [!isAuthenticated && (_jsxs(_Fragment, { children: [_jsx("a", { target: "blank", className: "Header-link mr-0 mr-lg-3 py-2 py-lg-0", href: window.location.origin + "/settings/tokens", children: i18n.common.menu.createToken }), _jsxs("div", { style: { position: "relative" }, children: [_jsx("a", { className: "info-icon-container Header-link mr-0 mr-lg-3 py-2 py-lg-0", href: "#", onClick: toggleInfoPopOver, children: "i" }), isInfoPopOverOpen && (_jsxs("div", { className: "info-popover", children: [_jsx("h3", { children: i18n.common.menu.tokenInfo.title }), _jsx("p", { children: i18n.common.menu.tokenInfo.disclaimer }), _jsx("hr", {}), _jsx("p", { children: i18n.common.menu.tokenInfo.explanation }), _jsx("p", { children: i18n.common.menu.tokenInfo.whichPermissionUserGive }), _jsxs("p", { children: [_jsxs("b", { children: [_jsxs("u", { children: [i18n.note.toUpperCase(), ":"] }), "\u00A0"] }), _jsx(I18nHtml, { children: i18n.common.menu.tokenInfo.permission })] })] }))] })] })), _jsxs("label", { style: { position: "relative" }, children: [_jsx("input", { className: "kogito-github-token-input form-control input-sm " + (isAuthenticated ? "authenticated" : ""), placeholder: i18n.common.menu.placeYourToken, maxLength: GITHUB_OAUTH_TOKEN_SIZE, autoFocus: true, ref: inputRef, disabled: isAuthenticated, value: tokenToDisplay, onPaste: onPaste, onChange: () => {
                                } }), isAuthenticated && _jsx("b", { className: "icon tick" }), !!potentialToken && _jsx("b", { className: "icon cross" })] }), _jsx("button", { className: "btn btn-sm", onClick: onReset, children: i18n.reset })] })), _jsx("img", { className: `kogito-menu-icon ${isAuthenticated ? "authenticated" : ""}`, src: globals.extensionIconUrl, onClick: toggleMenu })] }));
}
function obfuscate(token) {
    if (token.length <= 8) {
        return token;
    }
    const stars = new Array(token.length - 8).join("*");
    const pieceToObfuscate = token.substring(4, token.length - 4);
    return token.replace(pieceToObfuscate, stars);
}
async function tokenIsValid(token) {
    if (!token) {
        return false;
    }
    const testOctokit = new Octokit({ auth: token, baseUrl: getGitHubApiBaseUrl(window.location.origin) });
    return await testOctokit.emojis
        .get({})
        .then(() => true)
        .catch(() => false);
}
//# sourceMappingURL=KogitoMenu.js.map