import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { EmbeddedEditor, useEditorRef } from "@kie-tools-core/editor/dist/embedded";
import { ChannelType } from "@kie-tools-core/editor/dist/api";
import * as React from "react";
import { useCallback, useContext, useEffect, useImperativeHandle, useMemo } from "react";
import { runScriptOnPage } from "../../utils";
import { useGitHubApi } from "./GitHubContext";
import { useGlobals } from "./GlobalContext";
import { IsolatedEditorContext } from "./IsolatedEditorContext";
import { useChromeExtensionI18n } from "../../i18n";
import { StateControl } from "@kie-tools-core/editor/dist/channel";
const RefForwardingKogitoEditorIframe = (props, forwardedRef) => {
    const githubApi = useGitHubApi();
    const { editor, editorRef } = useEditorRef();
    const { envelopeLocator, resourceContentServiceFactory, customChannelApiImpl, stateControl: globalStateControl, } = useGlobals();
    const { repoInfo, textMode, fullscreen, onEditorReady } = useContext(IsolatedEditorContext);
    const { locale } = useChromeExtensionI18n();
    const wasOnTextMode = usePrevious(textMode);
    const { openFileExtension, contentPath, getFileContents, readonly, onSetContentError } = props;
    const stateControl = useMemo(() => globalStateControl || new StateControl(), [globalStateControl]);
    const resourceContentService = useMemo(() => {
        return resourceContentServiceFactory.createNew(githubApi.octokit(), repoInfo);
    }, [githubApi, repoInfo, resourceContentServiceFactory]);
    const onResourceContentRequest = useCallback((request) => resourceContentService.get(request.normalizedPosixPathRelativeToTheWorkspaceRoot, request.opts), [resourceContentService]);
    const onResourceContentList = useCallback((request) => resourceContentService.list(request.pattern, request.opts), [resourceContentService]);
    const file = useMemo(() => {
        return {
            fileName: props.contentPath,
            fileExtension: props.openFileExtension,
            getFileContents: props.getFileContents,
            isReadOnly: props.readonly,
            normalizedPosixPathRelativeToTheWorkspaceRoot: props.contentPath,
        };
    }, [props.contentPath, props.openFileExtension, props.getFileContents, props.readonly]);
    useEffect(() => {
        if (!textMode && wasOnTextMode) {
            getFileContents().then((content) => editor === null || editor === void 0 ? void 0 : editor.setContent(contentPath, content !== null && content !== void 0 ? content : ""));
        }
    }, [textMode, wasOnTextMode, editor, getFileContents, contentPath]);
    useEffect(() => {
        if (readonly || textMode || !editor) {
            return;
        }
        const stateControlSubscription = editor.getStateControl().subscribe(() => {
            editor.getContent().then((content) => {
                var _a;
                const pre = ((_a = document.getElementById("kogito-content")) !== null && _a !== void 0 ? _a : document.createElement("pre"));
                pre.textContent = content;
                pre.style.display = "none";
                pre.id = "kogito-content";
                document.body.appendChild(pre);
                runScriptOnPage(chrome.runtime.getURL(`scripts/update_content.js`));
            });
        });
        return () => editor.getStateControl().unsubscribe(stateControlSubscription);
    }, [textMode, editor, readonly]);
    useImperativeHandle(forwardedRef, () => {
        if (!editor) {
            return undefined;
        }
        return {
            setContent: (content) => editor.setContent(contentPath, content),
        };
    }, [editor, contentPath]);
    return (_jsx(_Fragment, { children: _jsx("div", { className: `kogito-iframe ${fullscreen ? "fullscreen" : "not-fullscreen"}`, children: _jsx(EmbeddedEditor, { ref: editorRef, file: file, channelType: ChannelType.GITHUB, kogitoEditor_ready: onEditorReady, kogitoWorkspace_resourceContentRequest: onResourceContentRequest, kogitoWorkspace_resourceListRequest: onResourceContentList, kogitoEditor_setContentError: onSetContentError, editorEnvelopeLocator: envelopeLocator, locale: locale, customChannelApiImpl: customChannelApiImpl, stateControl: stateControl }) }) }));
};
export const KogitoEditorIframe = React.forwardRef(RefForwardingKogitoEditorIframe);
function usePrevious(value) {
    const ref = React.useRef();
    useEffect(() => {
        ref.current = value;
    }, [value]);
    return ref.current;
}
//# sourceMappingURL=KogitoEditorIframe.js.map