/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.kie.kogito.codegen.api.context.impl;

public class JavaKogitoBuildContext extends AbstractKogitoBuildContext {

    public static final String CONTEXT_NAME = "Java";

    protected JavaKogitoBuildContext(JavaKogitoBuildContextBuilder builder) {
        super(builder, null, null, CONTEXT_NAME);
    }

    public static Builder builder() {
        return new JavaKogitoBuildContextBuilder();
    }

    @Override
    public boolean hasRest() {
        return false;
    }

    protected static class JavaKogitoBuildContextBuilder extends AbstractBuilder {

        protected JavaKogitoBuildContextBuilder() {
        }

        @Override
        public JavaKogitoBuildContext build() {
            return new JavaKogitoBuildContext(this);
        }

        @Override
        public String toString() {
            return JavaKogitoBuildContext.CONTEXT_NAME;
        }
    }
}