<!-- DO NOT MODIFY THIS FILE DIRECTLY, IT IS AUTO-GENERATED BY [org.apache.gluten.config.AllVeloxConfiguration] -->

---

layout: page
title: Configuration
nav_order: 16
-------------

## Gluten Velox backend configurations

|                                       Key                                        |      Default      |                                                                                                                                                                                                                      Description                                                                                                                                                                                                                      |
|----------------------------------------------------------------------------------|-------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| spark.gluten.sql.columnar.backend.velox.IOThreads                                | &lt;undefined&gt; | The Size of the IO thread pool in the Connector. This thread pool is used for split preloading and DirectBufferedInput. By default, the value is the same as the maximum task slots per Spark executor.                                                                                                                                                                                                                                               |
| spark.gluten.sql.columnar.backend.velox.SplitPreloadPerDriver                    | 2                 | The split preload per task                                                                                                                                                                                                                                                                                                                                                                                                                            |
| spark.gluten.sql.columnar.backend.velox.abandonPartialAggregationMinPct          | 90                | If partial aggregation aggregationPct greater than this value, partial aggregation may be early abandoned. Note: this option only works when flushable partial aggregation is enabled. Ignored when spark.gluten.sql.columnar.backend.velox.flushablePartialAggregation=false.                                                                                                                                                                        |
| spark.gluten.sql.columnar.backend.velox.abandonPartialAggregationMinRows         | 100000            | If partial aggregation input rows number greater than this value,  partial aggregation may be early abandoned. Note: this option only works when flushable partial aggregation is enabled. Ignored when spark.gluten.sql.columnar.backend.velox.flushablePartialAggregation=false.                                                                                                                                                                    |
| spark.gluten.sql.columnar.backend.velox.asyncTimeoutOnTaskStopping               | 30000ms           | Timeout for asynchronous execution when task is being stopped in Velox backend. It's recommended to set to a number larger than network connection timeout that the possible aysnc tasks are relying on.                                                                                                                                                                                                                                              |
| spark.gluten.sql.columnar.backend.velox.bloomFilter.expectedNumItems             | 1000000           | The default number of expected items for the velox bloomfilter: 'spark.bloom_filter.expected_num_items'                                                                                                                                                                                                                                                                                                                                               |
| spark.gluten.sql.columnar.backend.velox.bloomFilter.maxNumBits                   | 4194304           | The max number of bits to use for the velox bloom filter: 'spark.bloom_filter.max_num_bits'                                                                                                                                                                                                                                                                                                                                                           |
| spark.gluten.sql.columnar.backend.velox.bloomFilter.numBits                      | 8388608           | The default number of bits to use for the velox bloom filter: 'spark.bloom_filter.num_bits'                                                                                                                                                                                                                                                                                                                                                           |
| spark.gluten.sql.columnar.backend.velox.cacheEnabled                             | false             | Enable Velox cache, default off. It's recommended to enablesoft-affinity as well when enable velox cache.                                                                                                                                                                                                                                                                                                                                             |
| spark.gluten.sql.columnar.backend.velox.cachePrefetchMinPct                      | 0                 | Set prefetch cache min pct for velox file scan                                                                                                                                                                                                                                                                                                                                                                                                        |
| spark.gluten.sql.columnar.backend.velox.checkUsageLeak                           | true              | Enable check memory usage leak.                                                                                                                                                                                                                                                                                                                                                                                                                       |
| spark.gluten.sql.columnar.backend.velox.cudf.batchSize                           | 2147483647        | Cudf input batch size after shuffle reader                                                                                                                                                                                                                                                                                                                                                                                                            |
| spark.gluten.sql.columnar.backend.velox.cudf.enableTableScan                     | false             | Enable cudf table scan                                                                                                                                                                                                                                                                                                                                                                                                                                |
| spark.gluten.sql.columnar.backend.velox.cudf.enableValidation                    | true              | Heuristics you can apply to validate a cuDF/GPU plan and only offload when the entire stage can be fully and profitably executed on GPU                                                                                                                                                                                                                                                                                                               |
| spark.gluten.sql.columnar.backend.velox.cudf.memoryPercent                       | 50                | The initial percent of GPU memory to allocate for memory resource for one thread.                                                                                                                                                                                                                                                                                                                                                                     |
| spark.gluten.sql.columnar.backend.velox.cudf.memoryResource                      | async             | GPU RMM memory resource.                                                                                                                                                                                                                                                                                                                                                                                                                              |
| spark.gluten.sql.columnar.backend.velox.directorySizeGuess                       | 32KB              | Deprecated, rename to spark.gluten.sql.columnar.backend.velox.footerEstimatedSize                                                                                                                                                                                                                                                                                                                                                                     |
| spark.gluten.sql.columnar.backend.velox.fileHandleCacheEnabled                   | false             | Disables caching if false. File handle cache should be disabled if files are mutable, i.e. file content may change while file path stays the same.                                                                                                                                                                                                                                                                                                    |
| spark.gluten.sql.columnar.backend.velox.filePreloadThreshold                     | 1MB               | Set the file preload threshold for velox file scan, refer to Velox's file-preload-threshold                                                                                                                                                                                                                                                                                                                                                           |
| spark.gluten.sql.columnar.backend.velox.floatingPointMode                        | loose             | Config used to control the tolerance of floating point operations alignment with Spark. When the mode is set to strict, flushing is disabled for sum(float/double)and avg(float/double). When set to loose, flushing will be enabled.                                                                                                                                                                                                                 |
| spark.gluten.sql.columnar.backend.velox.flushablePartialAggregation              | true              | Enable flushable aggregation. If true, Gluten will try converting regular aggregation into Velox's flushable aggregation when applicable. A flushable aggregation could emit intermediate result at anytime when memory is full / data reduction ratio is low.                                                                                                                                                                                        |
| spark.gluten.sql.columnar.backend.velox.footerEstimatedSize                      | 32KB              | Set the footer estimated size for velox file scan, refer to Velox's footer-estimated-size                                                                                                                                                                                                                                                                                                                                                             |
| spark.gluten.sql.columnar.backend.velox.hashProbe.bloomFilterPushdown.maxSize    | 0b                | The maximum byte size of Bloom filter that can be generated from hash probe. When set to 0, no Bloom filter will be generated. To achieve optimal performance, this should not be too larger than the CPU cache size on the host.                                                                                                                                                                                                                     |
| spark.gluten.sql.columnar.backend.velox.hashProbe.dynamicFilterPushdown.enabled  | true              | Whether hash probe can generate any dynamic filter (including Bloom filter) and push down to upstream operators.                                                                                                                                                                                                                                                                                                                                      |
| spark.gluten.sql.columnar.backend.velox.loadQuantum                              | 256MB             | Set the load quantum for velox file scan, recommend to use the default value (256MB) for performance consideration. If Velox cache is enabled, it can be 8MB at most.                                                                                                                                                                                                                                                                                 |
| spark.gluten.sql.columnar.backend.velox.maxCoalescedBytes                        | 64MB              | Set the max coalesced bytes for velox file scan                                                                                                                                                                                                                                                                                                                                                                                                       |
| spark.gluten.sql.columnar.backend.velox.maxCoalescedDistance                     | 512KB             | Set the max coalesced distance bytes for velox file scan                                                                                                                                                                                                                                                                                                                                                                                              |
| spark.gluten.sql.columnar.backend.velox.maxCompiledRegexes                       | 100               | Controls maximum number of compiled regular expression patterns per function instance per thread of execution.                                                                                                                                                                                                                                                                                                                                        |
| spark.gluten.sql.columnar.backend.velox.maxExtendedPartialAggregationMemory      | &lt;undefined&gt; | Set the max extended memory of partial aggregation in bytes. When this option is set to a value greater than 0, it will override spark.gluten.sql.columnar.backend.velox.maxExtendedPartialAggregationMemoryRatio. Note: this option only works when flushable partial aggregation is enabled. Ignored when spark.gluten.sql.columnar.backend.velox.flushablePartialAggregation=false.                                                                |
| spark.gluten.sql.columnar.backend.velox.maxExtendedPartialAggregationMemoryRatio | 0.15              | Set the max extended memory of partial aggregation as maxExtendedPartialAggregationMemoryRatio of offheap size. Note: this option only works when flushable partial aggregation is enabled. Ignored when spark.gluten.sql.columnar.backend.velox.flushablePartialAggregation=false.                                                                                                                                                                   |
| spark.gluten.sql.columnar.backend.velox.maxPartialAggregationMemory              | &lt;undefined&gt; | Set the max memory of partial aggregation in bytes. When this option is set to a value greater than 0, it will override spark.gluten.sql.columnar.backend.velox.maxPartialAggregationMemoryRatio. Note: this option only works when flushable partial aggregation is enabled. Ignored when spark.gluten.sql.columnar.backend.velox.flushablePartialAggregation=false.                                                                                 |
| spark.gluten.sql.columnar.backend.velox.maxPartialAggregationMemoryRatio         | 0.1               | Set the max memory of partial aggregation as maxPartialAggregationMemoryRatio of offheap size. Note: this option only works when flushable partial aggregation is enabled. Ignored when spark.gluten.sql.columnar.backend.velox.flushablePartialAggregation=false.                                                                                                                                                                                    |
| spark.gluten.sql.columnar.backend.velox.maxPartitionsPerWritersSession           | 10000             | Maximum number of partitions per a single table writer instance.                                                                                                                                                                                                                                                                                                                                                                                      |
| spark.gluten.sql.columnar.backend.velox.maxSpillBytes                            | 100G              | The maximum file size of a query                                                                                                                                                                                                                                                                                                                                                                                                                      |
| spark.gluten.sql.columnar.backend.velox.maxSpillFileSize                         | 1GB               | The maximum size of a single spill file created                                                                                                                                                                                                                                                                                                                                                                                                       |
| spark.gluten.sql.columnar.backend.velox.maxSpillLevel                            | 4                 | The max allowed spilling level with zero being the initial spilling level                                                                                                                                                                                                                                                                                                                                                                             |
| spark.gluten.sql.columnar.backend.velox.maxSpillRunRows                          | 3M                | The maximum row size of a single spill run                                                                                                                                                                                                                                                                                                                                                                                                            |
| spark.gluten.sql.columnar.backend.velox.memCacheSize                             | 1GB               | The memory cache size                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| spark.gluten.sql.columnar.backend.velox.memInitCapacity                          | 8MB               | The initial memory capacity to reserve for a newly created Velox query memory pool.                                                                                                                                                                                                                                                                                                                                                                   |
| spark.gluten.sql.columnar.backend.velox.memoryPoolCapacityTransferAcrossTasks    | true              | Whether to allow memory capacity transfer between memory pools from different tasks.                                                                                                                                                                                                                                                                                                                                                                  |
| spark.gluten.sql.columnar.backend.velox.memoryUseHugePages                       | false             | Use explicit huge pages for Velox memory allocation.                                                                                                                                                                                                                                                                                                                                                                                                  |
| spark.gluten.sql.columnar.backend.velox.orc.scan.enabled                         | true              | Enable velox orc scan. If disabled, vanilla spark orc scan will be used.                                                                                                                                                                                                                                                                                                                                                                              |
| spark.gluten.sql.columnar.backend.velox.orcUseColumnNames                        | true              | Maps table field names to file field names using names, not indices for ORC files.                                                                                                                                                                                                                                                                                                                                                                    |
| spark.gluten.sql.columnar.backend.velox.parquetUseColumnNames                    | true              | Maps table field names to file field names using names, not indices for Parquet files.                                                                                                                                                                                                                                                                                                                                                                |
| spark.gluten.sql.columnar.backend.velox.prefetchRowGroups                        | 1                 | Set the prefetch row groups for velox file scan                                                                                                                                                                                                                                                                                                                                                                                                       |
| spark.gluten.sql.columnar.backend.velox.queryTraceEnabled                        | false             | Enable query tracing flag.                                                                                                                                                                                                                                                                                                                                                                                                                            |
| spark.gluten.sql.columnar.backend.velox.reclaimMaxWaitMs                         | 3600000ms         | The max time in ms to wait for memory reclaim.                                                                                                                                                                                                                                                                                                                                                                                                        |
| spark.gluten.sql.columnar.backend.velox.resizeBatches.shuffleInput               | true              | If true, combine small columnar batches together before sending to shuffle. The default minimum output batch size is equal to 0.25 * spark.gluten.sql.columnar.maxBatchSize                                                                                                                                                                                                                                                                           |
| spark.gluten.sql.columnar.backend.velox.resizeBatches.shuffleInput.minSize       | &lt;undefined&gt; | The minimum batch size for shuffle. If size of an input batch is smaller than the value, it will be combined with other batches before sending to shuffle. Only functions when spark.gluten.sql.columnar.backend.velox.resizeBatches.shuffleInput is set to true. Default value: 0.25 * <max batch size>                                                                                                                                              |
| spark.gluten.sql.columnar.backend.velox.resizeBatches.shuffleInputOuptut.minSize | &lt;undefined&gt; | The minimum batch size for shuffle input and output. If size of an input batch is smaller than the value, it will be combined with other batches before sending to shuffle. The same applies for batches output by shuffle read. Only functions when spark.gluten.sql.columnar.backend.velox.resizeBatches.shuffleInput or spark.gluten.sql.columnar.backend.velox.resizeBatches.shuffleOutput is set to true. Default value: 0.25 * <max batch size> |
| spark.gluten.sql.columnar.backend.velox.resizeBatches.shuffleOutput              | false             | If true, combine small columnar batches together right after shuffle read. The default minimum output batch size is equal to 0.25 * spark.gluten.sql.columnar.maxBatchSize                                                                                                                                                                                                                                                                            |
| spark.gluten.sql.columnar.backend.velox.showTaskMetricsWhenFinished              | false             | Show velox full task metrics when finished.                                                                                                                                                                                                                                                                                                                                                                                                           |
| spark.gluten.sql.columnar.backend.velox.spillFileSystem                          | local             | The filesystem used to store spill data. local: The local file system. heap-over-local: Write file to JVM heap if having extra heap space. Otherwise write to local file system.                                                                                                                                                                                                                                                                      |
| spark.gluten.sql.columnar.backend.velox.spillStrategy                            | auto              | none: Disable spill on Velox backend; auto: Let Spark memory manager manage Velox's spilling                                                                                                                                                                                                                                                                                                                                                          |
| spark.gluten.sql.columnar.backend.velox.ssdCacheIOThreads                        | 1                 | The IO threads for cache promoting                                                                                                                                                                                                                                                                                                                                                                                                                    |
| spark.gluten.sql.columnar.backend.velox.ssdCachePath                             | /tmp              | The folder to store the cache files, better on SSD                                                                                                                                                                                                                                                                                                                                                                                                    |
| spark.gluten.sql.columnar.backend.velox.ssdCacheShards                           | 1                 | The cache shards                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| spark.gluten.sql.columnar.backend.velox.ssdCacheSize                             | 1GB               | The SSD cache size, will do memory caching only if this value = 0                                                                                                                                                                                                                                                                                                                                                                                     |
| spark.gluten.sql.columnar.backend.velox.ssdCheckpointIntervalBytes               | 0                 | Checkpoint after every 'checkpointIntervalBytes' for SSD cache. 0 means no checkpointing.                                                                                                                                                                                                                                                                                                                                                             |
| spark.gluten.sql.columnar.backend.velox.ssdChecksumEnabled                       | false             | If true, checksum write to SSD is enabled.                                                                                                                                                                                                                                                                                                                                                                                                            |
| spark.gluten.sql.columnar.backend.velox.ssdChecksumReadVerificationEnabled       | false             | If true, checksum read verification from SSD is enabled.                                                                                                                                                                                                                                                                                                                                                                                              |
| spark.gluten.sql.columnar.backend.velox.ssdDisableFileCow                        | false             | True if copy on write should be disabled.                                                                                                                                                                                                                                                                                                                                                                                                             |
| spark.gluten.sql.columnar.backend.velox.ssdODirect                               | false             | The O_DIRECT flag for cache writing                                                                                                                                                                                                                                                                                                                                                                                                                   |
| spark.gluten.sql.enable.enhancedFeatures                                         | true              | Enable some features including iceberg native write and other features.                                                                                                                                                                                                                                                                                                                                                                               |
| spark.gluten.sql.rewrite.castArrayToString                                       | true              | When true, rewrite `cast(array as String)` to `concat('[', array_join(array, ', ', null), ']')` to allow offloading to Velox.                                                                                                                                                                                                                                                                                                                         |
| spark.gluten.velox.castFromVarcharAddTrimNode                                    | false             | If true, will add a trim node which has the same sementic as vanilla Spark to CAST-from-varchar.Otherwise, do nothing.                                                                                                                                                                                                                                                                                                                                |
| spark.gluten.velox.fs.s3a.connect.timeout                                        | 200s              | Timeout for AWS s3 connection.                                                                                                                                                                                                                                                                                                                                                                                                                        |

## Gluten Velox backend *experimental* configurations

|                           Key                            | Default |                                                               Description                                                               |
|----------------------------------------------------------|---------|-----------------------------------------------------------------------------------------------------------------------------------------|
| spark.gluten.velox.abandonDedupHashMap.minPct            | 0       | Experimental: abandon hashmap build if duplicated rows are more than this percentile. Value is integer based and range is [0, 100].     |
| spark.gluten.velox.abandonDedupHashMap.minRows           | 100000  | Experimental: abandon hashmap build if duplicated rows more than this number.                                                           |
| spark.gluten.velox.offHeapBroadcastBuildRelation.enabled | false   | Experimental: If enabled, broadcast build relation will use offheap memory. Otherwise, broadcast build relation will use onheap memory. |

