vcpkg_from_github(
  OUT_SOURCE_PATH
  SOURCE_PATH
  REPO
  simdjson/simdjson
  REF
  "v${VERSION}"
  HEAD_REF
  master
  SHA512
  a7e683625fa7e17cfe39cf3915b13fa34c589a8bcace51a9a8a98948f4cbdb1fd4346a273a44d934aced4aad1da7bc695b3b4f9fea078ae4bdf2b48234e99de3
  PATCHES
  add-definition.patch)

vcpkg_check_features(
  OUT_FEATURE_OPTIONS
  FEATURE_OPTIONS
  FEATURES
  exceptions
  SIMDJSON_EXCEPTIONS
  threads
  SIMDJSON_ENABLE_THREADS
  INVERTED_FEATURES
  deprecated
  SIMDJSON_DISABLE_DEPRECATED_API
  utf8-validation
  SIMDJSON_SKIPUTF8VALIDATION)

string(COMPARE EQUAL "${VCPKG_LIBRARY_LINKAGE}" "static" SIMDJSON_BUILD_STATIC)

vcpkg_cmake_configure(
  SOURCE_PATH
  "${SOURCE_PATH}"
  OPTIONS
  -DSIMDJSON_JUST_LIBRARY=ON
  -DSIMDJSON_SANITIZE_UNDEFINED=OFF
  -DSIMDJSON_SANITIZE=OFF
  -DSIMDJSON_SANITIZE_THREADS=OFF
  -DSIMDJSON_BUILD_STATIC=${SIMDJSON_BUILD_STATIC}
  -DSIMDJSON_DEVELOPMENT_CHECKS=OFF
  -DSIMDJSON_VERBOSE_LOGGING=OFF
  ${FEATURE_OPTIONS})

vcpkg_cmake_install()

vcpkg_copy_pdbs()

vcpkg_cmake_config_fixup(CONFIG_PATH "lib/cmake/${PORT}")

vcpkg_fixup_pkgconfig()

file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/debug/include"
     "${CURRENT_PACKAGES_DIR}/debug/share")

vcpkg_install_copyright(FILE_LIST "${SOURCE_PATH}/LICENSE")
