/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.util.ThreadUtils;

public class SparkThreadPoolUtil {
    private static final ExecutorService GC_THREAD_POOL = ThreadUtils.newDaemonSingleThreadExecutor((String)"gc-thread-pool");
    private static final AtomicBoolean PERFORMING_GC = new AtomicBoolean(false);

    public static void triggerGCInThreadPool(final Runnable callback) {
        if (PERFORMING_GC.compareAndSet(false, true)) {
            GC_THREAD_POOL.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        callback.run();
                    }
                    finally {
                        PERFORMING_GC.set(false);
                    }
                }
            });
        }
    }
}

