/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.lang.reflect.Constructor;
import java.util.Properties;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.TaskContextImpl;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.executor.TaskMetrics$;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.memory.UnifiedMemoryManager;
import org.apache.spark.memory.UnifiedMemoryManager$;
import org.apache.spark.metrics.MetricsSystem;
import org.apache.spark.metrics.MetricsSystem$;
import org.apache.spark.storage.BlockManagerUtil$;
import org.apache.spark.util.SparkVersionUtil$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public final class SparkTaskUtil$ {
    public static final SparkTaskUtil$ MODULE$ = new SparkTaskUtil$();

    public void setTaskContext(TaskContext taskContext) {
        TaskContext$.MODULE$.setTaskContext(taskContext);
    }

    public void unsetTaskContext() {
        TaskContext$.MODULE$.unset();
    }

    public TaskMemoryManager getTaskMemoryManager(TaskContext taskContext) {
        return taskContext.taskMemoryManager();
    }

    public TaskContext createTestTaskContext(Properties properties) {
        SparkConf conf = new SparkConf();
        conf.setAll((Iterable)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(properties).asScala());
        UnifiedMemoryManager memoryManager = UnifiedMemoryManager$.MODULE$.apply(conf, 1);
        BlockManagerUtil$.MODULE$.setTestMemoryStore(conf, (MemoryManager)memoryManager, false);
        Integer stageId = BoxesRunTime.boxToInteger((int)-1);
        Integer stageAttemptNumber = BoxesRunTime.boxToInteger((int)-1);
        Integer partitionId = BoxesRunTime.boxToInteger((int)-1);
        Long taskAttemptId = BoxesRunTime.boxToLong((long)-1L);
        Integer attemptNumber = BoxesRunTime.boxToInteger((int)-1);
        Integer numPartitions = BoxesRunTime.boxToInteger((int)-1);
        TaskMemoryManager taskMemoryManager = new TaskMemoryManager((MemoryManager)memoryManager, -1L);
        Properties localProperties = properties;
        MetricsSystem metricsSystem = MetricsSystem$.MODULE$.createMetricsSystem("GLUTEN_UNSAFE", conf);
        TaskMetrics taskMetrics = TaskMetrics$.MODULE$.empty();
        Integer cpus = BoxesRunTime.boxToInteger((int)1);
        Map resources = Predef$.MODULE$.Map().empty();
        Constructor<?>[] ctors = TaskContextImpl.class.getDeclaredConstructors();
        Predef$.MODULE$.assert(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])ctors)) == 1);
        Constructor ctor = (Constructor)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])ctors));
        if (SparkVersionUtil$.MODULE$.lteSpark32()) {
            return (TaskContext)ctor.newInstance(stageId, stageAttemptNumber, partitionId, taskAttemptId, attemptNumber, taskMemoryManager, localProperties, metricsSystem, taskMetrics, resources);
        }
        if (SparkVersionUtil$.MODULE$.eqSpark33()) {
            return (TaskContext)ctor.newInstance(stageId, stageAttemptNumber, partitionId, taskAttemptId, attemptNumber, taskMemoryManager, localProperties, metricsSystem, taskMetrics, cpus, resources);
        }
        return (TaskContext)ctor.newInstance(stageId, stageAttemptNumber, partitionId, taskAttemptId, attemptNumber, numPartitions, taskMemoryManager, localProperties, metricsSystem, taskMetrics, cpus, resources);
    }

    private SparkTaskUtil$() {
    }
}

