/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.ReadOnlySparkConf;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkMasterRegex$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

public final class SparkResourceUtil$
implements Logging {
    public static final SparkResourceUtil$ MODULE$ = new SparkResourceUtil$();
    private static final String MEMORY_OVERHEAD_FACTOR;
    private static final String MIN_MEMORY_OVERHEAD;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        MEMORY_OVERHEAD_FACTOR = "spark.executor.memoryOverheadFactor";
        MIN_MEMORY_OVERHEAD = "spark.executor.minMemoryOverhead";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String MEMORY_OVERHEAD_FACTOR() {
        return MEMORY_OVERHEAD_FACTOR;
    }

    private String MIN_MEMORY_OVERHEAD() {
        return MIN_MEMORY_OVERHEAD;
    }

    public int getTotalCores(SQLConf sqlConf) {
        String string = sqlConf.getConfString("spark.master");
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (string.startsWith("local")) {
            return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(sqlConf.getConfString("spark.default.parallelism", "1")));
        }
        if (string.matches("(yarn|k8s:).*")) {
            int instances = this.getExecutorNum(sqlConf);
            int cores = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(sqlConf.getConfString("spark.executor.cores", "1")));
            return Math.max(instances * cores, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(sqlConf.getConfString("spark.default.parallelism", "1"))));
        }
        if (string.startsWith("spark:")) {
            return Math.max(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(sqlConf.getConfString("spark.cores.max", "1"))), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(sqlConf.getConfString("spark.default.parallelism", "1"))));
        }
        throw new MatchError((Object)string);
    }

    public int getExecutorNum(SQLConf sqlConf) {
        if (StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(sqlConf.getConfString("spark.dynamicAllocation.enabled", "false")))) {
            int maxExecutors = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(sqlConf.getConfString("spark.dynamicAllocation.maxExecutors", sqlConf.getConfString("spark.default.parallelism", "1"))));
            return maxExecutors;
        }
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(sqlConf.getConfString("spark.executor.instances", "1")));
    }

    public int getExecutorCores(SparkConf conf) {
        Option option;
        Option option2;
        int n;
        String master = conf.get("spark.master");
        String string = master;
        if ("local".equals(string)) {
            n = 1;
        } else if (string != null && !(option2 = SparkMasterRegex$.MODULE$.LOCAL_N_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
            String threads = (String)((LinearSeqOps)option2.get()).apply(0);
            n = SparkResourceUtil$.convertToInt$1(threads);
        } else if (string != null && !(option = SparkMasterRegex$.MODULE$.LOCAL_N_FAILURES_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
            String threads = (String)((LinearSeqOps)option.get()).apply(0);
            n = SparkResourceUtil$.convertToInt$1(threads);
        } else {
            n = conf.getInt("spark.executor.cores", 1);
        }
        int cores = n;
        return cores;
    }

    public int getTaskSlots(SparkConf conf) {
        int executorCores = this.getExecutorCores(conf);
        int taskCores = conf.getInt("spark.task.cpus", 1);
        return executorCores / taskCores;
    }

    public boolean isLocalMaster(SparkConf conf) {
        return Utils$.MODULE$.isLocalMaster((ReadOnlySparkConf)conf);
    }

    public boolean isMemoryOverheadSet(SparkConf conf) {
        return new .colon.colon((Object)package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD().key(), (List)new .colon.colon((Object)this.MEMORY_OVERHEAD_FACTOR(), (List)new .colon.colon((Object)this.MIN_MEMORY_OVERHEAD(), (List)Nil$.MODULE$))).exists((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)conf.contains(key)));
    }

    public long getMemoryOverheadSize(SparkConf conf) {
        long overheadMib = BoxesRunTime.unboxToLong((Object)((Option)conf.get((ConfigEntry)package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> {
            long executorMemMib = BoxesRunTime.unboxToLong((Object)conf.get(package$.MODULE$.EXECUTOR_MEMORY()));
            double factor = conf.getDouble(MODULE$.MEMORY_OVERHEAD_FACTOR(), 0.1);
            long minMib = conf.getLong(MODULE$.MIN_MEMORY_OVERHEAD(), 384L);
            return RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper((long)((double)executorMemMib * factor)), minMib);
        }));
        return ByteUnit.MiB.toBytes(overheadMib);
    }

    private static final int convertToInt$1(String threads) {
        String string = threads;
        String string2 = "*";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return Runtime.getRuntime().availableProcessors();
        }
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(threads));
    }

    private SparkResourceUtil$() {
    }
}

