/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.task;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.gluten.config.GlutenCoreConfig$;
import org.apache.gluten.memory.SimpleMemoryUsageRecorder;
import org.apache.gluten.task.TaskListener;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.TaskFailedReason;
import org.apache.spark.TaskKilledException;
import org.apache.spark.UnknownReason$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.task.TaskResource;
import org.apache.spark.task.TaskResourceRegistry;
import org.apache.spark.task.TaskResources;
import org.apache.spark.util.SparkTaskUtil$;
import org.apache.spark.util.TaskCompletionListener;
import org.apache.spark.util.TaskFailureListener;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

public final class TaskResources$
implements TaskListener,
Logging {
    public static final TaskResources$ MODULE$ = new TaskResources$();
    private static final boolean DEBUG;
    private static final AtomicLong ACCUMULATED_LEAK_BYTES;
    private static final IdentityHashMap<TaskContext, TaskResourceRegistry> org$apache$spark$task$TaskResources$$RESOURCE_REGISTRIES;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        DEBUG = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(SQLConf$.MODULE$.get().getConfString("spark.gluten.sql.memory.debug", "true")));
        ACCUMULATED_LEAK_BYTES = new AtomicLong(0L);
        org$apache$spark$task$TaskResources$$RESOURCE_REGISTRIES = new IdentityHashMap();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean DEBUG() {
        return DEBUG;
    }

    public AtomicLong ACCUMULATED_LEAK_BYTES() {
        return ACCUMULATED_LEAK_BYTES;
    }

    private TaskContext newUnsafeTaskContext(Properties properties) {
        return SparkTaskUtil$.MODULE$.createTestTaskContext(properties);
    }

    private TaskResources.PropertiesOps PropertiesOps(Properties properties) {
        return new TaskResources.PropertiesOps(properties);
    }

    private void setUnsafeTaskContext() {
        if (this.inSparkTask()) {
            throw new UnsupportedOperationException("TaskResources#setUnsafeTaskContext should only be called outside Spark task");
        }
        Properties properties = new Properties();
        SQLConf$.MODULE$.get().getAllConfs().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                if (key.startsWith("spark")) {
                    return properties.put(key, value);
                }
            }
            return BoxedUnit.UNIT;
        });
        this.PropertiesOps(properties).setIfMissing(GlutenCoreConfig$.MODULE$.SPARK_OFFHEAP_ENABLED_KEY(), "true");
        this.PropertiesOps(properties).setIfMissing(GlutenCoreConfig$.MODULE$.SPARK_OFFHEAP_SIZE_KEY(), "1TB");
        TaskContext$.MODULE$.setTaskContext(this.newUnsafeTaskContext(properties));
    }

    private void unsetUnsafeTaskContext() {
        if (!this.inSparkTask()) {
            throw new IllegalStateException();
        }
        if (this.getLocalTaskContext().taskAttemptId() != -1L) {
            throw new IllegalStateException();
        }
        TaskContext$.MODULE$.unset();
    }

    /*
     * WARNING - void declaration
     */
    public <T> T runUnsafe(Function0<T> body) {
        void v1;
        if (this.inSparkTask()) {
            return (T)body.apply();
        }
        this.setUnsafeTaskContext();
        this.onTaskStart();
        TaskContext context = this.getLocalTaskContext();
        try {
            void var3_9;
            Object object;
            try {
                try {
                    object = body.apply();
                }
                catch (Throwable t2) {
                    try {
                        context.markTaskFailed(t2);
                    }
                    catch (Throwable t3) {
                        t3.addSuppressed(t3);
                    }
                    context.markTaskCompleted((Option)new Some((Object)t2));
                    throw t2;
                }
            }
            catch (Throwable throwable) {
                try {
                    context.markTaskCompleted((Option)None$.MODULE$);
                }
                finally {
                    this.unsetUnsafeTaskContext();
                }
                throw throwable;
            }
            Object object2 = object;
            try {
                context.markTaskCompleted((Option)None$.MODULE$);
            }
            finally {
                this.unsetUnsafeTaskContext();
            }
            Object out = object2;
            this.onTaskSucceeded();
            v1 = var3_9;
        }
        catch (Throwable t4) {
            this.onTaskFailed((TaskFailedReason)UnknownReason$.MODULE$);
            throw t4;
        }
        return v1;
    }

    public IdentityHashMap<TaskContext, TaskResourceRegistry> org$apache$spark$task$TaskResources$$RESOURCE_REGISTRIES() {
        return org$apache$spark$task$TaskResources$$RESOURCE_REGISTRIES;
    }

    public TaskContext getLocalTaskContext() {
        return TaskContext$.MODULE$.get();
    }

    public boolean inSparkTask() {
        return TaskContext$.MODULE$.get() != null;
    }

    private TaskResourceRegistry getTaskResourceRegistry() {
        if (!this.inSparkTask()) {
            throw new UnsupportedOperationException("Not in a Spark task. If the code is running on driver or for testing purpose, try using TaskResources#runUnsafe");
        }
        TaskContext tc = this.getLocalTaskContext();
        IdentityHashMap<TaskContext, TaskResourceRegistry> identityHashMap = this.org$apache$spark$task$TaskResources$$RESOURCE_REGISTRIES();
        synchronized (identityHashMap) {
            if (!this.org$apache$spark$task$TaskResources$$RESOURCE_REGISTRIES().containsKey(tc)) {
                throw new IllegalStateException("TaskResourceRegistry is not initialized, please ensure TaskResources is added to GlutenExecutorPlugin's task listener list");
            }
            TaskResourceRegistry taskResourceRegistry = this.org$apache$spark$task$TaskResources$$RESOURCE_REGISTRIES().get(tc);
            return taskResourceRegistry;
        }
    }

    public void addRecycler(String name, int prio, Function0<BoxedUnit> f) {
        this.addAnonymousResource(new TaskResource(f, prio, name){
            private final Function0 f$1;
            private final int prio$1;
            private final String name$1;

            public void release() {
                this.f$1.apply$mcV$sp();
            }

            public int priority() {
                return this.prio$1;
            }

            public String resourceName() {
                return this.name$1;
            }
            {
                this.f$1 = f$1;
                this.prio$1 = prio$1;
                this.name$1 = name$1;
                TaskResource.$init$(this);
            }
        });
    }

    public <T extends TaskResource> T addResource(String id, T resource) {
        return this.getTaskResourceRegistry().addResource(id, resource);
    }

    public void releaseResource(String id) {
        this.getTaskResourceRegistry().releaseResource(id);
    }

    public <T extends TaskResource> T addResourceIfNotRegistered(String id, Function0<T> factory) {
        return this.getTaskResourceRegistry().addResourceIfNotRegistered(id, factory);
    }

    public <T extends TaskResource> T addAnonymousResource(T resource) {
        return this.getTaskResourceRegistry().addResource(UUID.randomUUID().toString(), resource);
    }

    public boolean isResourceRegistered(String id) {
        return this.getTaskResourceRegistry().isResourceRegistered(id);
    }

    public <T extends TaskResource> T getResource(String id) {
        return this.getTaskResourceRegistry().getResource(id);
    }

    public SimpleMemoryUsageRecorder getSharedUsage() {
        return this.getTaskResourceRegistry().getSharedUsage();
    }

    @Override
    public void onTaskStart() {
        if (!this.inSparkTask()) {
            throw new IllegalStateException("Not in a Spark task");
        }
        TaskContext tc = this.getLocalTaskContext();
        IdentityHashMap<TaskContext, TaskResourceRegistry> identityHashMap = this.org$apache$spark$task$TaskResources$$RESOURCE_REGISTRIES();
        synchronized (identityHashMap) {
            if (this.org$apache$spark$task$TaskResources$$RESOURCE_REGISTRIES().containsKey(tc)) {
                throw new IllegalStateException("TaskResourceRegistry is already initialized, this should not happen");
            }
            TaskResourceRegistry registry = new TaskResourceRegistry();
            this.org$apache$spark$task$TaskResources$$RESOURCE_REGISTRIES().put(tc, registry);
            tc.addTaskFailureListener(new TaskFailureListener(){

                public void onTaskFailure(TaskContext context, Throwable error) {
                    Throwable throwable = error;
                    if (throwable instanceof TaskKilledException) {
                        TaskKilledException taskKilledException = (TaskKilledException)throwable;
                        String string = taskKilledException.reason();
                        String string2 = "another attempt succeeded";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            return;
                        }
                    }
                    TaskResources$.MODULE$.logError((Function0<String>)(Function0 & Serializable)() -> "Task " + context.taskAttemptId() + " failed by error: ", error);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onTaskFailure$1(org.apache.spark.TaskContext )}, serializedLambda);
                }
            });
            tc.addTaskCompletionListener(new TaskCompletionListener(registry){
                private final TaskResourceRegistry registry$1;

                public void onTaskCompletion(TaskContext context) {
                    IdentityHashMap<TaskContext, TaskResourceRegistry> identityHashMap = TaskResources$.MODULE$.org$apache$spark$task$TaskResources$$RESOURCE_REGISTRIES();
                    synchronized (identityHashMap) {
                        TaskResourceRegistry currentTaskRegistries = TaskResources$.MODULE$.org$apache$spark$task$TaskResources$$RESOURCE_REGISTRIES().get(context);
                        if (currentTaskRegistries == null) {
                            throw new IllegalStateException("TaskResourceRegistry is not initialized, this should not happen");
                        }
                        currentTaskRegistries.releaseAll();
                        context.taskMetrics().incPeakExecutionMemory(this.registry$1.getSharedUsage().peak());
                        TaskResources$.MODULE$.org$apache$spark$task$TaskResources$$RESOURCE_REGISTRIES().remove(context);
                    }
                }
                {
                    this.registry$1 = registry$1;
                }
            });
        }
    }

    private void onTaskExit() {
    }

    @Override
    public void onTaskSucceeded() {
        this.onTaskExit();
    }

    @Override
    public void onTaskFailed(TaskFailedReason failureReason) {
        this.onTaskExit();
    }

    private TaskResources$() {
    }
}

