/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.vectorized;

import java.lang.reflect.Field;
import org.apache.gluten.exception.GlutenException;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.sql.vectorized.ColumnarBatchRow;

public class SparkColumnarBatchUtil {
    private static final Field FIELD_COLUMNS;
    private static final Field FIELD_COLUMNAR_BATCH_ROW;

    private static void setColumnarBatchRow(ColumnarBatch from, ColumnVector[] columns, ColumnarBatch target) {
        ColumnarBatchRow newRow = new ColumnarBatchRow(columns);
        try {
            ColumnarBatchRow row = (ColumnarBatchRow)FIELD_COLUMNAR_BATCH_ROW.get(from);
            newRow.rowId = row.rowId;
            FIELD_COLUMNAR_BATCH_ROW.set(target, newRow);
        }
        catch (IllegalAccessException e) {
            throw new GlutenException(e);
        }
    }

    public static void transferVectors(ColumnarBatch from, ColumnarBatch target) {
        try {
            if (target.numCols() != from.numCols()) {
                throw new IllegalStateException();
            }
            ColumnVector[] newVectors = new ColumnVector[from.numCols()];
            for (int i = 0; i < target.numCols(); ++i) {
                newVectors[i] = from.column(i);
            }
            FIELD_COLUMNS.set(target, newVectors);
            SparkColumnarBatchUtil.setColumnarBatchRow(from, newVectors, target);
        }
        catch (IllegalAccessException e) {
            throw new GlutenException(e);
        }
    }

    static {
        try {
            Field f = ColumnarBatch.class.getDeclaredField("columns");
            f.setAccessible(true);
            FIELD_COLUMNS = f;
            Field row = ColumnarBatch.class.getDeclaredField("row");
            row.setAccessible(true);
            FIELD_COLUMNAR_BATCH_ROW = row;
        }
        catch (NoSuchFieldException e) {
            throw new GlutenException(e);
        }
    }
}

