/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.vectorized;

import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.vectorized.ArrowColumnarArray;
import org.apache.spark.sql.vectorized.ColumnVector;

public class ArrowColumnarMap
extends MapData {
    private final ArrowColumnarArray keys;
    private final ArrowColumnarArray values;
    private final int length;

    public ArrowColumnarMap(ColumnVector keys, ColumnVector values, int offset, int length) {
        this.length = length;
        this.keys = new ArrowColumnarArray(keys, offset, length);
        this.values = new ArrowColumnarArray(values, offset, length);
    }

    public int numElements() {
        return this.length;
    }

    public ArrayData keyArray() {
        return this.keys;
    }

    public ArrayData valueArray() {
        return this.values;
    }

    public MapData copy() {
        return new ArrayBasedMapData(this.keys.copy(), this.values.copy());
    }
}

