/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.vectorized;

import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.SpecializedGettersReader;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.sql.vectorized.ColumnarRow;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

abstract class AbstractColumnarArray
extends ArrayData {
    protected final ColumnVector data;
    protected final int offset;
    protected final int length;

    AbstractColumnarArray(ColumnVector data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public int numElements() {
        return this.length;
    }

    private UnsafeArrayData setNullBits(UnsafeArrayData arrayData) {
        if (this.data.hasNull()) {
            for (int i = 0; i < this.length; ++i) {
                if (!this.data.isNullAt(this.offset + i)) continue;
                arrayData.setNullAt(i);
            }
        }
        return arrayData;
    }

    public ArrayData copy() {
        DataType dt = this.data.dataType();
        if (dt instanceof BooleanType) {
            return this.setNullBits(UnsafeArrayData.fromPrimitiveArray((boolean[])this.toBooleanArray()));
        }
        if (dt instanceof ByteType) {
            return this.setNullBits(UnsafeArrayData.fromPrimitiveArray((byte[])this.toByteArray()));
        }
        if (dt instanceof ShortType) {
            return this.setNullBits(UnsafeArrayData.fromPrimitiveArray((short[])this.toShortArray()));
        }
        if (dt instanceof IntegerType || dt instanceof DateType || dt instanceof YearMonthIntervalType) {
            return this.setNullBits(UnsafeArrayData.fromPrimitiveArray((int[])this.toIntArray()));
        }
        if (dt instanceof LongType || dt instanceof TimestampType || dt instanceof DayTimeIntervalType) {
            return this.setNullBits(UnsafeArrayData.fromPrimitiveArray((long[])this.toLongArray()));
        }
        if (dt instanceof FloatType) {
            return this.setNullBits(UnsafeArrayData.fromPrimitiveArray((float[])this.toFloatArray()));
        }
        if (dt instanceof DoubleType) {
            return this.setNullBits(UnsafeArrayData.fromPrimitiveArray((double[])this.toDoubleArray()));
        }
        return new GenericArrayData(this.toObjectArray(dt)).copy();
    }

    public boolean[] toBooleanArray() {
        return this.data.getBooleans(this.offset, this.length);
    }

    public byte[] toByteArray() {
        return this.data.getBytes(this.offset, this.length);
    }

    public short[] toShortArray() {
        return this.data.getShorts(this.offset, this.length);
    }

    public int[] toIntArray() {
        return this.data.getInts(this.offset, this.length);
    }

    public long[] toLongArray() {
        return this.data.getLongs(this.offset, this.length);
    }

    public float[] toFloatArray() {
        return this.data.getFloats(this.offset, this.length);
    }

    public double[] toDoubleArray() {
        return this.data.getDoubles(this.offset, this.length);
    }

    public Object[] array() {
        DataType dt = this.data.dataType();
        Object[] list = new Object[this.length];
        try {
            for (int i = 0; i < this.length; ++i) {
                if (this.data.isNullAt(this.offset + i)) continue;
                list[i] = this.get(i, dt);
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get the array", e);
        }
    }

    public boolean isNullAt(int ordinal) {
        return this.data.isNullAt(this.offset + ordinal);
    }

    public boolean getBoolean(int ordinal) {
        return this.data.getBoolean(this.offset + ordinal);
    }

    public byte getByte(int ordinal) {
        return this.data.getByte(this.offset + ordinal);
    }

    public short getShort(int ordinal) {
        return this.data.getShort(this.offset + ordinal);
    }

    public int getInt(int ordinal) {
        return this.data.getInt(this.offset + ordinal);
    }

    public long getLong(int ordinal) {
        return this.data.getLong(this.offset + ordinal);
    }

    public float getFloat(int ordinal) {
        return this.data.getFloat(this.offset + ordinal);
    }

    public double getDouble(int ordinal) {
        return this.data.getDouble(this.offset + ordinal);
    }

    public Decimal getDecimal(int ordinal, int precision, int scale) {
        return this.data.getDecimal(this.offset + ordinal, precision, scale);
    }

    public UTF8String getUTF8String(int ordinal) {
        return this.data.getUTF8String(this.offset + ordinal);
    }

    public byte[] getBinary(int ordinal) {
        return this.data.getBinary(this.offset + ordinal);
    }

    public CalendarInterval getInterval(int ordinal) {
        return this.data.getInterval(this.offset + ordinal);
    }

    public ColumnarRow getStruct(int ordinal, int numFields) {
        return this.data.getStruct(this.offset + ordinal);
    }

    public ColumnarArray getArray(int ordinal) {
        return this.data.getArray(this.offset + ordinal);
    }

    public ColumnarMap getMap(int ordinal) {
        return this.data.getMap(this.offset + ordinal);
    }

    public Object get(int ordinal, DataType dataType) {
        return SpecializedGettersReader.read((SpecializedGetters)this, (int)ordinal, (DataType)dataType, (boolean)true, (boolean)false);
    }

    public void update(int ordinal, Object value) {
        throw new UnsupportedOperationException();
    }

    public void setNullAt(int ordinal) {
        throw new UnsupportedOperationException();
    }
}

