/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.gluten.columnarbatch.ColumnarBatches;
import org.apache.gluten.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.gluten.shaded.org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.FieldVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.TypeLayout;
import org.apache.gluten.shaded.org.apache.arrow.vector.ValueVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.gluten.shaded.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.gluten.vectorized.ArrowWritableColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

public final class SparkVectorUtil$ {
    public static final SparkVectorUtil$ MODULE$ = new SparkVectorUtil$();

    public ArrowRecordBatch toArrowRecordBatch(ColumnarBatch batch) {
        ColumnarBatches.checkLoaded(batch);
        int numRowsInBatch = batch.numRows();
        List cols = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), batch.numCols()).toList().map((Function1 & Serializable)i -> SparkVectorUtil$.$anonfun$toArrowRecordBatch$1(batch, BoxesRunTime.unboxToInt((Object)i)));
        return this.toArrowRecordBatch(numRowsInBatch, (List<ValueVector>)cols);
    }

    public ArrowRecordBatch toArrowRecordBatch(int numRows, List<ValueVector> cols) {
        ArrayList<ArrowFieldNode> nodes = new ArrayList<ArrowFieldNode>();
        ArrayList<ArrowBuf> buffers = new ArrayList<ArrowBuf>();
        cols.foreach((Function1 & Serializable)vector -> {
            SparkVectorUtil$.MODULE$.appendNodes((FieldVector)vector, nodes, buffers, SparkVectorUtil$.MODULE$.appendNodes$default$4());
            return BoxedUnit.UNIT;
        });
        return new ArrowRecordBatch(numRows, nodes, buffers);
    }

    public ArrowBuf[] getArrowBuffers(FieldVector vector) {
        ArrowBuf[] arrowBufArray;
        try {
            arrowBufArray = (ArrowBuf[])((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(vector.getFieldBuffers()).asScala()).toArray(ClassTag$.MODULE$.apply(ArrowBuf.class));
        }
        catch (Throwable throwable) {
            FieldVector fieldVector = vector;
            if (fieldVector instanceof BaseFixedWidthVector) {
                BaseFixedWidthVector baseFixedWidthVector = (BaseFixedWidthVector)fieldVector;
                arrowBufArray = (ArrowBuf[])((Object[])new ArrowBuf[]{baseFixedWidthVector.getValidityBuffer(), baseFixedWidthVector.getDataBuffer()});
            }
            if (fieldVector instanceof BaseVariableWidthVector) {
                BaseVariableWidthVector baseVariableWidthVector = (BaseVariableWidthVector)fieldVector;
                arrowBufArray = (ArrowBuf[])((Object[])new ArrowBuf[]{baseVariableWidthVector.getValidityBuffer(), baseVariableWidthVector.getOffsetBuffer(), baseVariableWidthVector.getDataBuffer()});
            }
            throw new UnsupportedOperationException("Could not decompress vector of class " + vector.getClass());
        }
        return arrowBufArray;
    }

    public void appendNodes(FieldVector vector, java.util.List<ArrowFieldNode> nodes, java.util.List<ArrowBuf> buffers, java.util.List<Object> bits) {
        Object object = nodes != null ? BoxesRunTime.boxToBoolean((boolean)nodes.add(new ArrowFieldNode(vector.getValueCount(), vector.getNullCount()))) : BoxedUnit.UNIT;
        ArrowBuf[] fieldBuffers = this.getArrowBuffers(vector);
        int expectedBufferCount = TypeLayout.getTypeBufferCount(vector.getField().getType());
        if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])fieldBuffers)) != expectedBufferCount) {
            throw new IllegalArgumentException("Wrong number of buffers for field " + vector.getField() + " in vector " + vector.getClass().getSimpleName() + ". found: " + fieldBuffers);
        }
        buffers.addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])fieldBuffers))).asJava());
        if (bits != null) {
            boolean[] bits_tmp = (boolean[])Array$.MODULE$.fill(expectedBufferCount, (Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (ClassTag)ClassTag$.MODULE$.Boolean());
            bits_tmp[0] = true;
            bits.addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.booleanArrayOps(bits_tmp))).asJava());
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(vector.getChildrenFromFields()).asScala()).foreach((Function1 & Serializable)child -> {
                SparkVectorUtil$.MODULE$.appendNodes(child, nodes, buffers, bits);
                return BoxedUnit.UNIT;
            });
            return;
        }
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(vector.getChildrenFromFields()).asScala()).foreach((Function1 & Serializable)child -> {
            SparkVectorUtil$.MODULE$.appendNodes(child, nodes, buffers, SparkVectorUtil$.MODULE$.appendNodes$default$4());
            return BoxedUnit.UNIT;
        });
    }

    public java.util.List<Object> appendNodes$default$4() {
        return null;
    }

    public static final /* synthetic */ ValueVector $anonfun$toArrowRecordBatch$1(ColumnarBatch batch$1, int i) {
        return ((ArrowWritableColumnVector)batch$1.column(i)).getValueVector();
    }

    private SparkVectorUtil$() {
    }
}

