/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.utils;

import java.time.Instant;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.utils.SparkArrowUtil$;

public final class SparkSchemaUtil$ {
    public static final SparkSchemaUtil$ MODULE$ = new SparkSchemaUtil$();

    public StructType fromArrowSchema(Schema schema) {
        return SparkArrowUtil$.MODULE$.fromArrowSchema(schema);
    }

    public Schema toArrowSchema(StructType schema) {
        return SparkArrowUtil$.MODULE$.toArrowSchema(schema, this.getLocalTimezoneID());
    }

    public Schema toArrowSchema(StructType schema, String timeZoneId) {
        return SparkArrowUtil$.MODULE$.toArrowSchema(schema, timeZoneId);
    }

    public boolean isTimeZoneIDEquivalentToUTC(String zoneId) {
        return this.getTimeZoneIDOffset(zoneId) == 0;
    }

    public String getLocalTimezoneID() {
        return SQLConf$.MODULE$.get().sessionLocalTimeZone();
    }

    public boolean timeZoneIDEquals(String one, String other) {
        return this.getTimeZoneIDOffset(one) == this.getTimeZoneIDOffset(other);
    }

    public int getTimeZoneIDOffset(String zoneId) {
        Objects.requireNonNull(zoneId);
        return TimeZone.getTimeZone(zoneId).toZoneId().getRules().getOffset(Instant.now()).getTotalSeconds();
    }

    private SparkSchemaUtil$() {
    }
}

