/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.utils;

import java.io.Serializable;
import java.util.Locale;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.DateUnit;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.IntervalUnit;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.TimeUnit;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.Field;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.sql.utils.SparkSchemaUtil$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.reflect.ClassTag$;

public final class SparkArrowUtil$ {
    public static final SparkArrowUtil$ MODULE$ = new SparkArrowUtil$();

    public ArrowType toArrowType(DataType dt, String timeZoneId) {
        DecimalType decimalType;
        Option option;
        DataType dataType = dt;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return ArrowType.Bool.INSTANCE;
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return new ArrowType.Int(8, true);
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return new ArrowType.Int(16, true);
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return new ArrowType.Int(32, true);
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return new ArrowType.Int(64, true);
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return ArrowType.Utf8.INSTANCE;
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return ArrowType.Binary.INSTANCE;
        }
        if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            return new ArrowType.Decimal(precision, scale, 128);
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return new ArrowType.Date(DateUnit.DAY);
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            if (timeZoneId == null) {
                throw new UnsupportedOperationException(TimestampType$.MODULE$.catalogString() + " must supply timeZoneId parameter");
            }
            return new ArrowType.Timestamp(TimeUnit.MICROSECOND, "UTC");
        }
        YearMonthIntervalType yearMonthIntervalType = YearMonthIntervalType$.MODULE$.DEFAULT();
        DataType dataType2 = dataType;
        if (!(yearMonthIntervalType != null ? !yearMonthIntervalType.equals(dataType2) : dataType2 != null)) {
            return new ArrowType.Interval(IntervalUnit.YEAR_MONTH);
        }
        if (dataType instanceof ArrayType) {
            return ArrowType.List.INSTANCE;
        }
        if (NullType$.MODULE$.equals(dataType)) {
            return ArrowType.Null.INSTANCE;
        }
        throw new UnsupportedOperationException("Unsupported data type: " + dt.catalogString());
    }

    public DataType fromArrowType(ArrowType dt) {
        boolean bl = false;
        ArrowType.Int intVal = null;
        boolean bl2 = false;
        ArrowType.FloatingPoint floatingPoint = null;
        ArrowType arrowType = dt;
        ArrowType.Bool bool = ArrowType.Bool.INSTANCE;
        ArrowType arrowType2 = arrowType;
        if (!(bool != null ? !((Object)bool).equals(arrowType2) : arrowType2 != null)) {
            return BooleanType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.Int) {
            bl = true;
            intVal = (ArrowType.Int)arrowType;
            if (intVal.getIsSigned() && intVal.getBitWidth() == 8) {
                return ByteType$.MODULE$;
            }
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 16) {
            return ShortType$.MODULE$;
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 32) {
            return IntegerType$.MODULE$;
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 64) {
            return LongType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.FloatingPoint) {
            bl2 = true;
            floatingPoint = (ArrowType.FloatingPoint)arrowType;
            FloatingPointPrecision floatingPointPrecision = floatingPoint.getPrecision();
            FloatingPointPrecision floatingPointPrecision2 = FloatingPointPrecision.SINGLE;
            if (!(floatingPointPrecision != null ? !((Object)((Object)floatingPointPrecision)).equals((Object)floatingPointPrecision2) : floatingPointPrecision2 != null)) {
                return FloatType$.MODULE$;
            }
        }
        if (bl2) {
            FloatingPointPrecision floatingPointPrecision = floatingPoint.getPrecision();
            FloatingPointPrecision floatingPointPrecision3 = FloatingPointPrecision.DOUBLE;
            if (!(floatingPointPrecision != null ? !((Object)((Object)floatingPointPrecision)).equals((Object)floatingPointPrecision3) : floatingPointPrecision3 != null)) {
                return DoubleType$.MODULE$;
            }
        }
        ArrowType.Utf8 utf8 = ArrowType.Utf8.INSTANCE;
        ArrowType arrowType3 = arrowType;
        if (!(utf8 != null ? !((Object)utf8).equals(arrowType3) : arrowType3 != null)) {
            return StringType$.MODULE$;
        }
        ArrowType.Binary binary = ArrowType.Binary.INSTANCE;
        ArrowType arrowType4 = arrowType;
        if (!(binary != null ? !((Object)binary).equals(arrowType4) : arrowType4 != null)) {
            return BinaryType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.Decimal) {
            ArrowType.Decimal decimal = (ArrowType.Decimal)arrowType;
            return new DecimalType(decimal.getPrecision(), decimal.getScale());
        }
        if (arrowType instanceof ArrowType.Date) {
            ArrowType.Date date = (ArrowType.Date)arrowType;
            DateUnit dateUnit = date.getUnit();
            DateUnit dateUnit2 = DateUnit.DAY;
            if (!(dateUnit != null ? !((Object)((Object)dateUnit)).equals((Object)dateUnit2) : dateUnit2 != null)) {
                return DateType$.MODULE$;
            }
        }
        if (arrowType instanceof ArrowType.Timestamp) {
            return TimestampType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.Interval) {
            ArrowType.Interval interval = (ArrowType.Interval)arrowType;
            IntervalUnit intervalUnit = interval.getUnit();
            IntervalUnit intervalUnit2 = IntervalUnit.YEAR_MONTH;
            if (!(intervalUnit != null ? !((Object)((Object)intervalUnit)).equals((Object)intervalUnit2) : intervalUnit2 != null)) {
                return YearMonthIntervalType$.MODULE$.DEFAULT();
            }
        }
        ArrowType.Null nullVal = ArrowType.Null.INSTANCE;
        ArrowType arrowType5 = arrowType;
        if (!(nullVal != null ? !((Object)nullVal).equals(arrowType5) : arrowType5 != null)) {
            return NullType$.MODULE$;
        }
        throw new UnsupportedOperationException("Unsupported data type: " + dt);
    }

    public Field toArrowField(String name, DataType dt, boolean nullable, String timeZoneId) {
        DataType dataType = dt;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            FieldType fieldType = new FieldType(nullable, ArrowType.List.INSTANCE, null);
            return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.toArrowField("element", elementType, containsNull, timeZoneId), (List)Nil$.MODULE$)).asJava());
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            FieldType fieldType = new FieldType(nullable, ArrowType.Struct.INSTANCE, null);
            return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)field -> MODULE$.toArrowField(MODULE$.normalizeColName(field.name()), field.dataType(), field.nullable(), timeZoneId), ClassTag$.MODULE$.apply(Field.class))))).asJava());
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            FieldType mapType2 = new FieldType(nullable, new ArrowType.Map(false), null);
            return new Field(name, mapType2, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.toArrowField("entries", (DataType)new StructType().add("key", keyType, false).add("value", valueType, valueContainsNull), false, timeZoneId), (List)Nil$.MODULE$)).asJava());
        }
        FieldType fieldType = new FieldType(nullable, this.toArrowType(dataType, timeZoneId), null);
        return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Seq().empty()).asJava());
    }

    public DataType fromArrowField(Field field) {
        ArrowType arrowType = field.getType();
        if (arrowType instanceof ArrowType.Map) {
            Field elementField = field.getChildren().get(0);
            DataType keyType = this.fromArrowField(elementField.getChildren().get(0));
            DataType valueType = this.fromArrowField(elementField.getChildren().get(1));
            return new MapType(keyType, valueType, elementField.getChildren().get(1).isNullable());
        }
        ArrowType.List list = ArrowType.List.INSTANCE;
        ArrowType arrowType2 = arrowType;
        if (!(list != null ? !((Object)list).equals(arrowType2) : arrowType2 != null)) {
            Field elementField = field.getChildren().get(0);
            DataType elementType = this.fromArrowField(elementField);
            return new ArrayType(elementType, elementField.isNullable());
        }
        ArrowType.Struct struct = ArrowType.Struct.INSTANCE;
        ArrowType arrowType3 = arrowType;
        if (!(struct != null ? !((Object)struct).equals(arrowType3) : arrowType3 != null)) {
            Buffer fields = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(field.getChildren()).asScala()).map((Function1 & Serializable)child -> {
                DataType dt = MODULE$.fromArrowField((Field)child);
                return new StructField(child.getName(), dt, child.isNullable(), StructField$.MODULE$.apply$default$4());
            });
            return StructType$.MODULE$.apply(fields.toSeq());
        }
        return this.fromArrowType(arrowType);
    }

    public Schema toArrowSchema(StructType schema, String timeZoneId) {
        return new Schema((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)schema.map((Function1 & Serializable)field -> MODULE$.toArrowField(field.name(), field.dataType(), field.nullable(), timeZoneId))).asJava());
    }

    public boolean checkSchema(StructType schema) {
        boolean bl;
        try {
            SparkSchemaUtil$.MODULE$.toArrowSchema(schema);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public StructType fromArrowSchema(Schema schema) {
        return StructType$.MODULE$.apply((scala.collection.immutable.Seq)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).toSeq().map((Function1 & Serializable)field -> {
            DataType dt = MODULE$.fromArrowField((Field)field);
            return new StructField(field.getName(), dt, field.isNullable(), StructField$.MODULE$.apply$default$4());
        }));
    }

    private String normalizeColName(String name) {
        boolean caseSensitive = SQLConf$.MODULE$.get().caseSensitiveAnalysis();
        if (caseSensitive) {
            return name;
        }
        return name.toLowerCase(Locale.ROOT);
    }

    private SparkArrowUtil$() {
    }
}

