/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.util.Locale;
import org.apache.gluten.exception.GlutenNotSupportException;
import org.apache.gluten.expression.ExpressionConverter$;
import org.apache.gluten.expression.ExpressionTransformer;
import org.apache.gluten.expression.GenericExpressionTransformer;
import org.apache.gluten.expression.UDFMappings$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.hive.HiveGenericUDF;
import org.apache.spark.sql.hive.HiveSimpleUDF;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;

public final class HiveUDFTransformer$ {
    public static final HiveUDFTransformer$ MODULE$ = new HiveUDFTransformer$();

    public boolean isHiveUDF(Expression expr) {
        Expression expression = expr;
        return expression instanceof HiveSimpleUDF ? true : expression instanceof HiveGenericUDF;
    }

    public Tuple2<String, String> getHiveUDFNameAndClassName(Expression expr) {
        Expression expression = expr;
        if (expression instanceof HiveSimpleUDF) {
            HiveSimpleUDF hiveSimpleUDF = (HiveSimpleUDF)expression;
            return new Tuple2((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(hiveSimpleUDF.name()), "default."), (Object)hiveSimpleUDF.funcWrapper().functionClassName());
        }
        if (expression instanceof HiveGenericUDF) {
            HiveGenericUDF hiveGenericUDF = (HiveGenericUDF)expression;
            return new Tuple2((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(hiveGenericUDF.name()), "default."), (Object)hiveGenericUDF.funcWrapper().functionClassName());
        }
        throw new GlutenNotSupportException("Expression " + expr + " is not a HiveSimpleUDF or HiveGenericUDF");
    }

    public ExpressionTransformer replaceWithExpressionTransformer(Expression expr, Seq<Attribute> attributeSeq) {
        Tuple2<String, String> tuple2 = this.getHiveUDFNameAndClassName(expr);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String udfName = (String)tuple2._1();
        String udfName2 = udfName;
        return this.genTransformerFromUDFMappings(udfName2, expr, attributeSeq);
    }

    public GenericExpressionTransformer genTransformerFromUDFMappings(String udfName, Expression expr, Seq<Attribute> attributeSeq) {
        Option option = UDFMappings$.MODULE$.hiveUDFMap().get((Object)udfName.toLowerCase(Locale.ROOT));
        if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            return new GenericExpressionTransformer(name, ExpressionConverter$.MODULE$.replaceWithExpressionTransformer((Seq<Expression>)expr.children(), attributeSeq), expr);
        }
        throw new GlutenNotSupportException("Not supported hive udf:" + expr + " name:" + udfName + " hiveUDFMap:" + UDFMappings$.MODULE$.hiveUDFMap());
    }

    private HiveUDFTransformer$() {
    }
}

