/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.Serializable;
import java.net.URI;
import org.apache.gluten.backendsapi.BackendsApiManager$;
import org.apache.gluten.sql.shims.SparkShimLoader$;
import org.apache.gluten.sql.shims.SparkShims;
import org.apache.gluten.substrait.rel.LocalFilesNode;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.CastSupport;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.execution.datasources.FilePartition;
import org.apache.spark.sql.execution.datasources.FilePartition$;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.execution.datasources.PartitionDirectory$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Mh\u0001B\t\u0013\u0001uA\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\ts\u0001\u0011\t\u0011)A\u0005u!)a\b\u0001C\u0001\u007f!)A\u0007\u0001C!\t\")1\n\u0001C\u0005\u0019\"AQ\r\u0001EC\u0002\u0013\u0005a\r\u0003\u0005p\u0001!\u0015\r\u0011\"\u0001q\u0011\u0015!\b\u0001\"\u0003v\u0011\u0015q\b\u0001\"\u0003\u0000\u0011\u001d\tY\u0001\u0001C\u0005\u0003\u001bAq!a\u0003\u0001\t\u0013\ty\u0005C\u0004\u0002t\u0001!I!!\u001e\t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\"9\u0011q\u0014\u0001\u0005\u0002\u0005\u0005\u0006bBAP\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003?\u0003A\u0011AAw\u0005YA\u0015N^3QCJ$\u0018\u000e^5p]\u000e{gN^3si\u0016\u0014(BA\n\u0015\u0003\u0011A\u0017N^3\u000b\u0005U1\u0012aA:rY*\u0011q\u0003G\u0001\u0006gB\f'o\u001b\u0006\u00033i\ta!\u00199bG\",'\"A\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qB\u0005\f\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0015RS\"\u0001\u0014\u000b\u0005\u001dB\u0013\u0001C1oC2L8/[:\u000b\u0005%\"\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005-2#aC\"bgR\u001cV\u000f\u001d9peR\u0004\"!\f\u0018\u000e\u0003!J!a\f\u0015\u0003\u001bM\u000bFjQ8oM\"+G\u000e]3s\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0003e]j\u0011a\r\u0006\u0003iU\nAaY8oM*\u0011a\u0007G\u0001\u0007Q\u0006$wn\u001c9\n\u0005a\u001a$!D\"p]\u001aLw-\u001e:bi&|g.A\u0004tKN\u001c\u0018n\u001c8\u0011\u0005mbT\"\u0001\u000b\n\u0005u\"\"\u0001D*qCJ\\7+Z:tS>t\u0017A\u0002\u001fj]&$h\bF\u0002A\u0005\u000e\u0003\"!\u0011\u0001\u000e\u0003IAQ\u0001M\u0002A\u0002EBQ!O\u0002A\u0002i*\u0012!\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011R\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0015\u001e\u0013qaU)M\u0007>tg-\u0001\bdCN$hI]8n'R\u0014\u0018N\\4\u0015\u00075\u0003V\f\u0005\u0002 \u001d&\u0011q\n\t\u0002\u0004\u0003:L\b\"B)\u0006\u0001\u0004\u0011\u0016!\u0002<bYV,\u0007CA*[\u001d\t!\u0006\f\u0005\u0002VA5\taK\u0003\u0002X9\u00051AH]8pizJ!!\u0017\u0011\u0002\rA\u0013X\rZ3g\u0013\tYFL\u0001\u0004TiJLgn\u001a\u0006\u00033\u0002BQAX\u0003A\u0002}\u000b\u0001\u0002Z1uCRK\b/\u001a\t\u0003A\u000el\u0011!\u0019\u0006\u0003ER\tQ\u0001^=qKNL!\u0001Z1\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fAbY8eK\u000e4\u0015m\u0019;pef,\u0012a\u001a\t\u0003Q6l\u0011!\u001b\u0006\u0003U.\f\u0001bY8naJ,7o\u001d\u0006\u0003YV\n!![8\n\u00059L'aF\"p[B\u0014Xm]:j_:\u001cu\u000eZ3d\r\u0006\u001cGo\u001c:z\u0003%\u0011XmY;sg&4X-F\u0001r!\ty\"/\u0003\u0002tA\t9!i\\8mK\u0006t\u0017AC2b]\n+7\u000b\u001d7jiR\u0011\u0011O\u001e\u0005\u0006o\"\u0001\r\u0001_\u0001\tM&dW\rU1uQB\u0011\u0011\u0010`\u0007\u0002u*\u001110N\u0001\u0003MNL!! >\u0003\tA\u000bG\u000f[\u0001\u0013SNtuN\\#naRLH)\u0019;b\r&dW\rF\u0002r\u0003\u0003Aq!a\u0001\n\u0001\u0004\t)!A\u0001g!\rI\u0018qA\u0005\u0004\u0003\u0013Q(A\u0003$jY\u0016\u001cF/\u0019;vg\u0006IA.[:u\r&dWm\u001d\u000b\u0007\u0003\u001f\t\t$!\u0013\u0011\r\u0005E\u00111DA\u0011\u001d\u0011\t\u0019\"a\u0006\u000f\u0007U\u000b)\"C\u0001\"\u0013\r\tI\u0002I\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti\"a\b\u0003\u0007M+\u0017OC\u0002\u0002\u001a\u0001\u0002B!a\t\u0002.5\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#A\u0006eCR\f7o\\;sG\u0016\u001c(bAA\u0016)\u0005IQ\r_3dkRLwN\\\u0005\u0005\u0003_\t)C\u0001\nQCJ$\u0018\u000e^5p]\u0012K'/Z2u_JL\bbBA\u001a\u0015\u0001\u0007\u0011QG\u0001\u0011aJ,h.\u001a3QCJ$\u0018\u000e^5p]N\u0004b!!\u0005\u0002\u001c\u0005]\u0002\u0003BA\u001d\u0003\u000bj!!a\u000f\u000b\t\u0005u\u0012qH\u0001\t[\u0016$\u0018\rZ1uC*!\u0011\u0011IA\"\u0003\t\tHN\u0003\u0002\u0014k%!\u0011qIA\u001e\u0005%\u0001\u0016M\u001d;ji&|g\u000eC\u0004\u0002L)\u0001\r!!\u0014\u0002#A\f'\u000f^5uS>t7i\u001c7UsB,7\u000fE\u0003\u0002\u0012\u0005mq\f\u0006\u0003\u0002\u0010\u0005E\u0003bBA*\u0017\u0001\u0007\u0011QK\u0001\fI&\u0014Xm\u0019;pe&,7\u000f\u0005\u0004\u0002\u0012\u0005m\u0011q\u000b\t\b?\u0005e\u0013QLA7\u0013\r\tY\u0006\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005}\u0013\u0011N\u0007\u0003\u0003CRA!a\u0019\u0002f\u0005\u0019a.\u001a;\u000b\u0005\u0005\u001d\u0014\u0001\u00026bm\u0006LA!a\u001b\u0002b\t\u0019QKU%\u0011\u00075\ny'C\u0002\u0002r!\u00121\"\u00138uKJt\u0017\r\u001c*po\u00069\u0012\r\u001a3J]B,H\u000fU1uQJ+7-\u001e:tSZ,G.\u001f\u000b\u0007\u0003o\nI(!!\u0011\r\u0005E\u00111DA\u0003\u0011\u0019YH\u00021\u0001\u0002|A\u0019\u00110! \n\u0007\u0005}$P\u0001\u0006GS2,7+_:uK6Dq!a!\r\u0001\u0004\t)!A\u0003gS2,7/\u0001\u0007hKR\u001c\u0006\u000f\\5u\r&dW\r\u0006\u0004\u0002\n\u0006E\u0015Q\u0013\t\u0007\u0003#\tY\"a#\u0011\t\u0005\r\u0012QR\u0005\u0005\u0003\u001f\u000b)CA\bQCJ$\u0018\u000e^5p]\u0016$g)\u001b7f\u0011\u001d\t\u0019*\u0004a\u0001\u0003C\t!\u0003]1si&$\u0018n\u001c8ESJ,7\r^8ss\"9\u0011qS\u0007A\u0002\u0005e\u0015!D7bqN\u0003H.\u001b;CsR,7\u000fE\u0002 \u00037K1!!(!\u0005\u0011auN\\4\u0002'\r\u0014X-\u0019;f\r&dW\rU1si&$\u0018n\u001c8\u0015\t\u0005\r\u00161\u0016\t\u0007\u0003#\tY\"!*\u0011\t\u0005\r\u0012qU\u0005\u0005\u0003S\u000b)CA\u0007GS2,\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003[s\u0001\u0019AA/\u00035!\u0018M\u00197f\u0019>\u001c\u0017\r^5p]RA\u0011\u0011WAr\u0003K\f9\u000f\u0005\u0004\u0002\u0012\u0005m\u00111\u0017\t\b?\u0005e\u0013QUA[!\u0011\t9,!8\u000f\t\u0005e\u0016q\u001b\b\u0005\u0003w\u000b\tN\u0004\u0003\u0002>\u0006-g\u0002BA`\u0003\u000ftA!!1\u0002F:\u0019Q+a1\n\u0003mI!!\u0007\u000e\n\u0007\u0005%\u0007$\u0001\u0004hYV$XM\\\u0005\u0005\u0003\u001b\fy-A\u0005tk\n\u001cHO]1ji*\u0019\u0011\u0011\u001a\r\n\t\u0005M\u0017Q[\u0001\u0004e\u0016d'\u0002BAg\u0003\u001fLA!!7\u0002\\\u0006qAj\\2bY\u001aKG.Z:O_\u0012,'\u0002BAj\u0003+LA!a8\u0002b\nq!+Z1e\r&dWMR8s[\u0006$(\u0002BAm\u00037Dq!a\r\u0010\u0001\u0004\t)\u0004C\u0004\u0002L=\u0001\r!!\u0014\t\u000f\u0005%x\u00021\u0001\u0002l\u0006y!/Z1e\r&dWMR8s[\u0006$8\u000f\u0005\u0004\u0002\u0012\u0005m\u0011Q\u0017\u000b\u0007\u0003G\u000by/!=\t\u000f\u0005M\u0002\u00031\u0001\u00026!9\u00111\n\tA\u0002\u00055\u0003")
public class HivePartitionConverter
implements CastSupport,
SQLConfHelper {
    private CompressionCodecFactory codecFactory;
    private boolean recursive;
    private final Configuration hadoopConf;
    private final SparkSession session;
    private volatile byte bitmap$0;

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public Cast cast(Expression child, DataType dataType) {
        return CastSupport.cast$((CastSupport)this, (Expression)child, (DataType)dataType);
    }

    public SQLConf conf() {
        return this.session.sessionState().conf();
    }

    private Object castFromString(String value, DataType dataType) {
        return this.cast((Expression)Literal$.MODULE$.apply((Object)value), dataType).eval(null);
    }

    private CompressionCodecFactory codecFactory$lzycompute() {
        HivePartitionConverter hivePartitionConverter = this;
        synchronized (hivePartitionConverter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.codecFactory = new CompressionCodecFactory(this.hadoopConf);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.codecFactory;
    }

    public CompressionCodecFactory codecFactory() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.codecFactory$lzycompute();
        }
        return this.codecFactory;
    }

    private boolean recursive$lzycompute() {
        HivePartitionConverter hivePartitionConverter = this;
        synchronized (hivePartitionConverter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.recursive = this.hadoopConf.getBoolean("mapreduce.input.fileinputformat.input.dir.recursive", false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.recursive;
    }

    public boolean recursive() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.recursive$lzycompute();
        }
        return this.recursive;
    }

    private boolean canBeSplit(Path filePath) {
        CompressionCodec codec = this.codecFactory().getCodec(filePath);
        return codec == null || BackendsApiManager$.MODULE$.getValidatorApiInstance().doCompressionSplittableValidate(codec.getClass().getSimpleName());
    }

    private boolean isNonEmptyDataFile(FileStatus f) {
        if (!f.isFile() || f.getLen() == 0L) {
            return false;
        }
        String name = f.getPath().getName();
        return (!name.startsWith("_") || name.contains("=")) && !name.startsWith(".");
    }

    private Seq<PartitionDirectory> listFiles(Seq<Partition> prunedPartitions, Seq<DataType> partitionColTypes) {
        Seq directories = (Seq)prunedPartitions.map((Function1 & Serializable)p -> {
            URI uri = p.getDataLocation().toUri();
            Seq partValues = ((IterableOnceOps)((IterableOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(p.getValues()).asScala()).zip((IterableOnce)partitionColTypes)).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String value = (String)tuple2._1();
                    DataType dataType = (DataType)tuple2._2();
                    return this.castFromString(value, dataType);
                }
                throw new MatchError((Object)tuple2);
            })).toSeq();
            InternalRow partValuesAsInternalRow = InternalRow$.MODULE$.fromSeq(partValues);
            return new Tuple2((Object)uri, (Object)partValuesAsInternalRow);
        });
        return this.listFiles((Seq<Tuple2<URI, InternalRow>>)directories);
    }

    private Seq<PartitionDirectory> listFiles(Seq<Tuple2<URI, InternalRow>> directories) {
        return (Seq)directories.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                URI directory = (URI)tuple2._1();
                InternalRow partValues = (InternalRow)tuple2._2();
                Path path = new Path(directory);
                FileSystem fs = path.getFileSystem($this.hadoopConf);
                FileStatus[] dirContents = (FileStatus[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path)), (Function1 & Serializable)f -> {
                    if (f.isFile()) {
                        return new .colon.colon(f, (List)Nil$.MODULE$);
                    }
                    if (this.recursive()) {
                        return this.addInputPathRecursively(fs, (FileStatus)f);
                    }
                    return (Seq)Nil$.MODULE$;
                }, ClassTag$.MODULE$.apply(FileStatus.class))), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.isNonEmptyDataFile(f)));
                return PartitionDirectory$.MODULE$.apply(partValues, dirContents);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Seq<FileStatus> addInputPathRecursively(FileSystem fs, FileStatus files) {
        if (files.isFile()) {
            return new .colon.colon((Object)files, (List)Nil$.MODULE$);
        }
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(files.getPath())), (Function1 & Serializable)file -> {
            if (file.isFile()) {
                return new .colon.colon(file, (List)Nil$.MODULE$);
            }
            return this.addInputPathRecursively(fs, (FileStatus)file);
        }, ClassTag$.MODULE$.apply(FileStatus.class)));
    }

    private Seq<PartitionedFile> getSplitFile(PartitionDirectory partitionDirectory, long maxSplitBytes) {
        return (Seq)((SeqOps)SparkShimLoader$.MODULE$.getSparkShims().getFileStatus(partitionDirectory).flatMap((Function1 & Serializable)f -> {
            SparkShims qual$1 = SparkShimLoader$.MODULE$.getSparkShims();
            SparkSession x$1 = $this.session;
            FileStatus x$2 = (FileStatus)f._1();
            Path x$3 = ((FileStatus)f._1()).getPath();
            boolean x$4 = this.canBeSplit(((FileStatus)f._1()).getPath());
            long x$5 = maxSplitBytes;
            InternalRow x$6 = partitionDirectory.values();
            Map<String, Object> x$7 = qual$1.splitFiles$default$7();
            return qual$1.splitFiles(x$1, x$2, x$3, x$4, x$5, x$6, x$7);
        })).sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.length()), ((Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Long$.MODULE$)).reverse());
    }

    public Seq<FilePartition> createFilePartition(URI tableLocation) {
        Seq<PartitionDirectory> selectedPartitions = this.listFiles((Seq<Tuple2<URI, InternalRow>>)new .colon.colon((Object)new Tuple2((Object)tableLocation, (Object)InternalRow$.MODULE$.empty()), (List)Nil$.MODULE$));
        long maxSplitBytes = FilePartition$.MODULE$.maxSplitBytes(this.session, selectedPartitions);
        Seq splitFiles = (Seq)selectedPartitions.flatMap((Function1 & Serializable)x$2 -> this.getSplitFile((PartitionDirectory)x$2, maxSplitBytes));
        return FilePartition$.MODULE$.getFilePartitions(this.session, splitFiles, maxSplitBytes);
    }

    public Seq<Tuple2<FilePartition, LocalFilesNode.ReadFileFormat>> createFilePartition(Seq<Partition> prunedPartitions, Seq<DataType> partitionColTypes, Seq<LocalFilesNode.ReadFileFormat> readFileFormats) {
        Seq<PartitionDirectory> selectedPartitions = this.listFiles(prunedPartitions, partitionColTypes);
        long maxSplitBytes = FilePartition$.MODULE$.maxSplitBytes(this.session, selectedPartitions);
        return (Seq)((IterableOps)selectedPartitions.zip(readFileFormats)).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                PartitionDirectory partitionDirectory = (PartitionDirectory)tuple2._1();
                LocalFilesNode.ReadFileFormat readFileFormat = (LocalFilesNode.ReadFileFormat)((Object)((Object)tuple2._2()));
                Seq<PartitionedFile> splitFiles = this.getSplitFile(partitionDirectory, maxSplitBytes);
                Seq filePartitions = FilePartition$.MODULE$.getFilePartitions($this.session, splitFiles, maxSplitBytes);
                return (IterableOnce)filePartitions.map((Function1 & Serializable)x$3 -> new Tuple2(x$3, (Object)readFileFormat));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Seq<FilePartition> createFilePartition(Seq<Partition> prunedPartitions, Seq<DataType> partitionColTypes) {
        Seq<PartitionDirectory> selectedPartitions = this.listFiles(prunedPartitions, partitionColTypes);
        long maxSplitBytes = FilePartition$.MODULE$.maxSplitBytes(this.session, selectedPartitions);
        Seq splitFiles = (Seq)selectedPartitions.flatMap((Function1 & Serializable)x$4 -> this.getSplitFile((PartitionDirectory)x$4, maxSplitBytes));
        return FilePartition$.MODULE$.getFilePartitions(this.session, splitFiles, maxSplitBytes);
    }

    public HivePartitionConverter(Configuration hadoopConf, SparkSession session) {
        this.hadoopConf = hadoopConf;
        this.session = session;
        CastSupport.$init$((CastSupport)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
    }
}

