/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.expression;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.gluten.backendsapi.velox.VeloxBackendSettings$;
import org.apache.gluten.exception.GlutenException;
import org.apache.gluten.exception.GlutenNotSupportException;
import org.apache.gluten.expression.ConverterUtils$;
import org.apache.gluten.expression.ExpressionType;
import org.apache.gluten.jni.JniWorkspace;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFiles$;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.expression.UDAFSignature;
import org.apache.spark.sql.expression.UDFExpression;
import org.apache.spark.sql.expression.UDFSignature;
import org.apache.spark.sql.expression.UDFSignatureBase;
import org.apache.spark.sql.expression.UserDefinedAggregateFunction;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class UDFResolver$
implements Logging {
    public static final UDFResolver$ MODULE$ = new UDFResolver$();
    private static final HashSet<String> UDFNames;
    private static final HashMap<String, ListBuffer<UDFSignature>> UDFMap;
    private static final HashSet<String> UDAFNames;
    private static final HashMap<String, ListBuffer<UDAFSignature>> UDAFMap;
    private static final String LIB_EXTENSION;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        UDFNames = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        UDFMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        UDAFNames = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        UDAFMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        LIB_EXTENSION = ".so";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public HashSet<String> UDFNames() {
        return UDFNames;
    }

    private HashMap<String, ListBuffer<UDFSignature>> UDFMap() {
        return UDFMap;
    }

    public HashSet<String> UDAFNames() {
        return UDAFNames;
    }

    private HashMap<String, ListBuffer<UDAFSignature>> UDAFMap() {
        return UDAFMap;
    }

    private String LIB_EXTENSION() {
        return LIB_EXTENSION;
    }

    public void registerUDF(String name, byte[] returnType, byte[] argTypes, boolean variableArity, boolean allowTypeConversion) {
        this.registerUDF(name, ConverterUtils$.MODULE$.parseFromBytes(returnType), ConverterUtils$.MODULE$.parseFromBytes(argTypes), variableArity, allowTypeConversion);
    }

    private void registerUDF(String name, ExpressionType returnType, ExpressionType argTypes, boolean variableArity, boolean allowTypeConversion) {
        Predef$.MODULE$.assert(argTypes.dataType() instanceof StructType);
        ListBuffer v = (ListBuffer)this.UDFMap().getOrElseUpdate((Object)name, (Function0 & Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
        v.$plus$eq((Object)new UDFSignature(returnType, (Seq<DataType>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((StructType)argTypes.dataType()).fields()), (Function1 & Serializable)x$2 -> x$2.dataType(), ClassTag$.MODULE$.apply(DataType.class))), variableArity, allowTypeConversion));
        this.UDFNames().$plus$eq((Object)name);
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Registered UDF: " + name + "(" + argTypes + ") -> " + returnType);
    }

    public void registerUDAF(String name, byte[] returnType, byte[] argTypes, byte[] intermediateTypes, boolean variableArity, boolean enableTypeConversion) {
        this.registerUDAF(name, ConverterUtils$.MODULE$.parseFromBytes(returnType), ConverterUtils$.MODULE$.parseFromBytes(argTypes), ConverterUtils$.MODULE$.parseFromBytes(intermediateTypes), variableArity, enableTypeConversion);
    }

    private void registerUDAF(String name, ExpressionType returnType, ExpressionType argTypes, ExpressionType intermediateTypes, boolean variableArity, boolean allowTypeConversion) {
        .colon.colon colon2;
        Predef$.MODULE$.assert(argTypes.dataType() instanceof StructType);
        DataType dataType = intermediateTypes.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            colon2 = Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])fields))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    StructField f = (StructField)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    String x$1 = "agg_inter_" + index;
                    DataType x$2 = f.dataType();
                    boolean x$3 = f.nullable();
                    Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
                    Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                    return new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(AttributeReference.class)));
        } else {
            String x$7 = "agg_inter";
            DataType x$8 = dataType;
            boolean x$9 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$11 = AttributeReference$.MODULE$.apply$default$5("agg_inter", x$8, x$9, x$10);
            Seq x$12 = AttributeReference$.MODULE$.apply$default$6("agg_inter", x$8, x$9, x$10);
            .colon.colon colon3 = new .colon.colon((Object)new AttributeReference("agg_inter", x$8, x$9, x$10, x$11, x$12), (List)Nil$.MODULE$);
            colon2 = colon3;
        }
        .colon.colon aggBufferAttributes = colon2;
        ListBuffer v = (ListBuffer)this.UDAFMap().getOrElseUpdate((Object)name, (Function0 & Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
        v.$plus$eq((Object)new UDAFSignature(returnType, (Seq<DataType>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((StructType)argTypes.dataType()).fields()), (Function1 & Serializable)x$3 -> x$3.dataType(), ClassTag$.MODULE$.apply(DataType.class))), variableArity, allowTypeConversion, (Seq<AttributeReference>)aggBufferAttributes));
        this.UDAFNames().$plus$eq((Object)name);
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Registered UDAF: " + name + "(" + argTypes + ") -> " + returnType);
    }

    public Tuple2<String, String> parseName(String name) {
        int index = name.lastIndexOf("#");
        if (index == -1) {
            return new Tuple2((Object)name, (Object)((Object)Paths.get(name, new String[0]).getFileName()).toString());
        }
        return new Tuple2((Object)name.substring(0, index), (Object)name.substring(index + 1));
    }

    private Seq<String> getFilesWithExtension(Path directory, String extension) {
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(directory, FileVisitOption.FOLLOW_LINKS).iterator()).asScala()).filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)UDFResolver$.$anonfun$getFilesWithExtension$1(extension, p))).map((Function1 & Serializable)p -> ((Object)p).toString()).toSeq();
    }

    public void resolveUdfConf(SparkConf sparkConf, boolean isDriver) {
        Option udfLibPaths = isDriver ? sparkConf.getOption(VeloxBackendSettings$.MODULE$.GLUTEN_VELOX_DRIVER_UDF_LIB_PATHS()).orElse((Function0 & Serializable)() -> sparkConf.getOption(VeloxBackendSettings$.MODULE$.GLUTEN_VELOX_UDF_LIB_PATHS())) : sparkConf.getOption(VeloxBackendSettings$.MODULE$.GLUTEN_VELOX_UDF_LIB_PATHS());
        Option option = udfLibPaths;
        if (option instanceof Some) {
            Some some = (Some)option;
            String paths = (String)some.value();
            sparkConf.set(VeloxBackendSettings$.MODULE$.GLUTEN_VELOX_INTERNAL_UDF_LIB_PATHS(), this.getAllLibraries(sparkConf, isDriver, paths));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    private File unpack(File source, File destDir) {
        String sourceName = source.getName();
        File dest = new File(destDir, sourceName);
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Unpacking an archive " + sourceName + " from " + source.getAbsolutePath() + " to " + dest.getAbsolutePath());
        try {
            Utils$.MODULE$.deleteRecursively(dest);
            Utils$.MODULE$.unpack(source, dest);
        }
        catch (Exception e) {
            throw new GlutenException("Unpack " + source.toString() + " failed. Please check if it is an archive.", e);
        }
        return dest;
    }

    private boolean isRelativePath(String path) {
        boolean bl;
        block4: {
            try {
                URI uri = new URI(path);
                if (!uri.isAbsolute()) {
                    String string = uri.getPath();
                    String string2 = path;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        bl = true;
                        break block4;
                    }
                }
                bl = false;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    private String getAllLibraries(SparkConf sparkConf, boolean isDriver, String files) {
        Configuration hadoopConf = SparkHadoopUtil$.MODULE$.newConfiguration(sparkConf);
        Option master = sparkConf.getOption("spark.master");
        boolean isYarnCluster = master.isDefined() && ((String)master.get()).equals("yarn") && !Utils$.MODULE$.isClientMode(sparkConf);
        boolean isYarnClient = master.isDefined() && ((String)master.get()).equals("yarn") && Utils$.MODULE$.isClientMode(sparkConf);
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])files.split(",")), (Function1 & Serializable)f -> {
            File file = new File((String)f);
            if (MODULE$.isRelativePath((String)f)) {
                MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> "resolve relative path: " + f);
                if (isDriver && isYarnClient) {
                    throw new IllegalArgumentException("On yarn-client mode, driver only accepts absolute paths, but got " + f);
                }
                if (isYarnCluster || isYarnClient) {
                    return file;
                }
                return new File(SparkFiles$.MODULE$.get(f));
            }
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> "resolve absolute URI path: " + f);
            URI uri = Utils$.MODULE$.resolveURI(f);
            String name = file.getName();
            File jniWorkspace = new File(JniWorkspace.getDefault().getWorkDir());
            if (!file.isDirectory() && !f.endsWith(MODULE$.LIB_EXTENSION())) {
                File source = Utils$.MODULE$.doFetchFile(uri.toString(), Utils$.MODULE$.createTempDir(), name, sparkConf, hadoopConf);
                return MODULE$.unpack(source, jniWorkspace);
            }
            return Utils$.MODULE$.doFetchFile(uri.toString(), jniWorkspace, name, sparkConf, hadoopConf);
        }, ClassTag$.MODULE$.apply(File.class))), (Function1 & Serializable)f -> {
            if (f.isDirectory()) {
                return MODULE$.getFilesWithExtension(f.toPath(), MODULE$.LIB_EXTENSION());
            }
            return new .colon.colon((Object)f.toString(), (List)Nil$.MODULE$);
        }, ClassTag$.MODULE$.apply(String.class))).mkString(",");
    }

    private boolean checkAllowTypeConversion() {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(SQLConf$.MODULE$.get().getConfString(VeloxBackendSettings$.MODULE$.GLUTEN_VELOX_UDF_ALLOW_TYPE_CONVERSION(), "false")));
    }

    public UDFExpression getUdfExpression(String name, String alias, Seq<Expression> children) {
        boolean allowTypeConversion = this.checkAllowTypeConversion();
        ListBuffer signatures = (ListBuffer)this.UDFMap().getOrElse((Object)name, (Function0 & Serializable)() -> {
            throw new GlutenNotSupportException(UDFResolver$.errorMessage$1(name, children));
        });
        Option option = signatures.find((Function1 & Serializable)sig -> BoxesRunTime.boxToBoolean((boolean)UDFResolver$.MODULE$.tryBind(sig, (Seq<DataType>)((Seq)children.map((Function1 & Serializable)x$5 -> x$5.dataType())), allowTypeConversion)));
        if (option instanceof Some) {
            Some some = (Some)option;
            UDFSignature sig2 = (UDFSignature)some.value();
            return new UDFExpression(name, alias, sig2.expressionType().dataType(), sig2.expressionType().nullable(), !allowTypeConversion && !sig2.allowTypeConversion() ? children : this.applyCast(children, sig2));
        }
        if (None$.MODULE$.equals(option)) {
            throw new GlutenNotSupportException(UDFResolver$.errorMessage$1(name, children));
        }
        throw new MatchError((Object)option);
    }

    public UserDefinedAggregateFunction getUdafExpression(String name, Seq<Expression> children) {
        boolean allowTypeConversion = this.checkAllowTypeConversion();
        ListBuffer signatures = (ListBuffer)this.UDAFMap().getOrElse((Object)name, (Function0 & Serializable)() -> {
            throw new GlutenNotSupportException(UDFResolver$.errorMessage$2(name, children));
        });
        Option option = signatures.find((Function1 & Serializable)sig -> BoxesRunTime.boxToBoolean((boolean)UDFResolver$.MODULE$.tryBind(sig, (Seq<DataType>)((Seq)children.map((Function1 & Serializable)x$7 -> x$7.dataType())), allowTypeConversion)));
        if (option instanceof Some) {
            Some some = (Some)option;
            UDAFSignature sig2 = (UDAFSignature)some.value();
            return new UserDefinedAggregateFunction(name, sig2.expressionType().dataType(), sig2.expressionType().nullable(), !allowTypeConversion && !sig2.allowTypeConversion() ? children : this.applyCast(children, sig2), sig2.intermediateAttrs());
        }
        if (None$.MODULE$.equals(option)) {
            throw new GlutenNotSupportException(UDFResolver$.errorMessage$2(name, children));
        }
        throw new MatchError((Object)option);
    }

    private boolean tryBind(UDFSignatureBase sig, Seq<DataType> requiredDataTypes, boolean allowTypeConversion) {
        if (!this.tryBindStrict(sig, requiredDataTypes) && (allowTypeConversion || sig.allowTypeConversion())) {
            return this.tryBindWithTypeConversion(sig, requiredDataTypes);
        }
        return true;
    }

    private boolean tryBindWithTypeConversion(UDFSignatureBase sig, Seq<DataType> requiredDataTypes) {
        return this.tryBind0(sig, requiredDataTypes, (Function2<DataType, DataType, Object>)(Function2 & Serializable)(from, to) -> BoxesRunTime.boxToBoolean((boolean)Cast$.MODULE$.canCast(from, to)));
    }

    private boolean tryBindStrict(UDFSignatureBase sig, Seq<DataType> requiredDataTypes) {
        return this.tryBind0(sig, requiredDataTypes, (Function2<DataType, DataType, Object>)(Function2 & Serializable)(left, right) -> BoxesRunTime.boxToBoolean((boolean)DataTypeUtils$.MODULE$.sameType(left, right)));
    }

    private boolean tryBind0(UDFSignatureBase sig, Seq<DataType> requiredDataTypes, Function2<DataType, DataType, Object> checkType) {
        if (!sig.variableArity()) {
            return sig.children().size() == requiredDataTypes.size() && ((IterableOnceOps)requiredDataTypes.zip(sig.children())).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)UDFResolver$.$anonfun$tryBind0$1(checkType, x0$1)));
        }
        if (requiredDataTypes.size() < sig.children().size() - 1) {
            return false;
        }
        if (requiredDataTypes.size() == sig.children().size() - 1) {
            return ((IterableOnceOps)requiredDataTypes.zip((IterableOnce)sig.children().dropRight(1))).forall((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)UDFResolver$.$anonfun$tryBind0$2(checkType, x0$2)));
        }
        int varArgStartIndex = sig.children().size() - 1;
        if (!((IterableOnceOps)requiredDataTypes.drop(varArgStartIndex)).forall((Function1 & Serializable)argType -> BoxesRunTime.boxToBoolean((boolean)UDFResolver$.$anonfun$tryBind0$3(checkType, sig, argType)))) {
            return false;
        }
        if (varArgStartIndex == 0) {
            return true;
        }
        return ((IterableOnceOps)((IterableOps)requiredDataTypes.dropRight(1 + requiredDataTypes.size() - sig.children().size())).zip((IterableOnce)sig.children().dropRight(1))).forall((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)UDFResolver$.$anonfun$tryBind0$4(checkType, x0$3)));
    }

    private Seq<Expression> applyCast(Seq<Expression> children, UDFSignatureBase sig) {
        if (!sig.variableArity()) {
            return (Seq)((IterableOps)children.zip(sig.children())).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Expression expr = (Expression)tuple2._1();
                    DataType toType = (DataType)tuple2._2();
                    return UDFResolver$.maybeCast$1(expr, toType);
                }
                throw new MatchError((Object)tuple2);
            });
        }
        int fixedArgs = Math.min(children.size(), sig.children().size());
        Seq newChildren = (Seq)((IterableOps)((IterableOps)children.take(fixedArgs)).zip((IterableOnce)sig.children().take(fixedArgs))).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Expression expr = (Expression)tuple2._1();
                DataType toType = (DataType)tuple2._2();
                return UDFResolver$.maybeCast$1(expr, toType);
            }
            throw new MatchError((Object)tuple2);
        });
        if (children.size() > sig.children().size()) {
            DataType varArgType = (DataType)sig.children().last();
            return (Seq)newChildren.$plus$plus((IterableOnce)((IterableOps)children.takeRight(children.size() - sig.children().size())).map((Function1 & Serializable)expr -> UDFResolver$.maybeCast$1(expr, varArgType)));
        }
        return newChildren;
    }

    public static final /* synthetic */ boolean $anonfun$getFilesWithExtension$1(String extension$1, Path p) {
        return Files.isRegularFile(p, new LinkOption[0]) && ((Object)p).toString().endsWith(extension$1);
    }

    private static final String errorMessage$1(String name$3, Seq children$1) {
        return "UDF " + name$3 + " -> " + ((IterableOnceOps)children$1.map((Function1 & Serializable)x$4 -> x$4.dataType().simpleString())).mkString(", ") + " is not registered.";
    }

    private static final String errorMessage$2(String name$4, Seq children$2) {
        return "UDAF " + name$4 + " -> " + ((IterableOnceOps)children$2.map((Function1 & Serializable)x$6 -> x$6.dataType().simpleString())).mkString(", ") + " is not registered.";
    }

    public static final /* synthetic */ boolean $anonfun$tryBind0$1(Function2 checkType$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            DataType required = (DataType)tuple2._1();
            DataType candidate = (DataType)tuple2._2();
            return BoxesRunTime.unboxToBoolean((Object)checkType$1.apply((Object)required, (Object)candidate));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$tryBind0$2(Function2 checkType$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            DataType required = (DataType)tuple2._1();
            DataType candidate = (DataType)tuple2._2();
            return BoxesRunTime.unboxToBoolean((Object)checkType$1.apply((Object)required, (Object)candidate));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$tryBind0$3(Function2 checkType$1, UDFSignatureBase sig$1, DataType argType) {
        return BoxesRunTime.unboxToBoolean((Object)checkType$1.apply((Object)argType, sig$1.children().last()));
    }

    public static final /* synthetic */ boolean $anonfun$tryBind0$4(Function2 checkType$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            DataType required = (DataType)tuple2._1();
            DataType candidate = (DataType)tuple2._2();
            return BoxesRunTime.unboxToBoolean((Object)checkType$1.apply((Object)required, (Object)candidate));
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Expression maybeCast$1(Expression expr, DataType toType) {
        if (!expr.dataType().sameType(toType)) {
            return new Cast(expr, toType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
        }
        return expr;
    }

    private UDFResolver$() {
    }
}

