/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.unsafe;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.gluten.memory.arrow.alloc.ArrowBufferAllocators;
import org.apache.gluten.shaded.org.apache.arrow.memory.ArrowBuf;

public class UnsafeByteArray
implements Externalizable,
KryoSerializable {
    private ArrowBuf buffer;
    private long size;

    UnsafeByteArray(ArrowBuf buffer, long size) {
        this.buffer = buffer;
        this.buffer.getReferenceManager().retain();
        this.size = size;
    }

    public UnsafeByteArray() {
    }

    public long address() {
        return this.buffer.memoryAddress();
    }

    public long size() {
        return this.size;
    }

    public void release() {
        if (this.buffer != null) {
            this.buffer.close();
            this.buffer = null;
            this.size = 0L;
        }
    }

    public void write(Kryo kryo, Output output) {
        int chunk;
        output.writeLong(this.size);
        int chunkSize = 8192;
        byte[] tmp = new byte[8192];
        int index = 0;
        for (long remaining = this.size; remaining > 0L; remaining -= (long)chunk) {
            chunk = (int)Math.min(8192L, remaining);
            this.buffer.getBytes((long)index, tmp, 0, chunk);
            output.write(tmp, 0, chunk);
            index += chunk;
        }
    }

    public void read(Kryo kryo, Input input) {
        int chunk;
        this.size = input.readLong();
        if (this.size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("UnsafeByteArray size too large: " + this.size);
        }
        this.buffer = ArrowBufferAllocators.globalInstance().buffer((int)this.size);
        int chunkSize = 8192;
        byte[] tmp = new byte[8192];
        int index = 0;
        for (long remaining = this.size; remaining > 0L; remaining -= (long)chunk) {
            chunk = (int)Math.min(8192L, remaining);
            input.readBytes(tmp, 0, chunk);
            this.buffer.setBytes((long)index, tmp, 0, (long)chunk);
            index += chunk;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int chunk;
        out.writeLong(this.size);
        int chunkSize = 8192;
        byte[] tmp = new byte[8192];
        int index = 0;
        for (long remaining = this.size; remaining > 0L; remaining -= (long)chunk) {
            chunk = (int)Math.min(8192L, remaining);
            this.buffer.getBytes((long)index, tmp, 0, chunk);
            out.write(tmp, 0, chunk);
            index += chunk;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int chunk;
        this.size = in.readLong();
        if (this.size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("UnsafeByteArray size too large: " + this.size);
        }
        this.buffer = ArrowBufferAllocators.globalInstance().buffer((int)this.size);
        int chunkSize = 8192;
        byte[] tmp = new byte[8192];
        int index = 0;
        for (long remaining = this.size; remaining > 0L; remaining -= (long)chunk) {
            chunk = (int)Math.min(8192L, remaining);
            in.readFully(tmp, 0, chunk);
            this.buffer.setBytes((long)index, tmp, 0, (long)chunk);
            index += chunk;
        }
    }

    public void finalize() throws Throwable {
        this.release();
        super.finalize();
    }
}

