/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.unsafe;

import org.apache.gluten.memory.arrow.alloc.ArrowBufferAllocators;
import org.apache.gluten.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.spark.sql.execution.unsafe.UnsafeByteArray;
import org.apache.spark.unsafe.Platform;

public class JniUnsafeByteBuffer {
    private ArrowBuf buffer;
    private long size;
    private boolean released = false;

    private JniUnsafeByteBuffer(ArrowBuf buffer, long size) {
        this.buffer = buffer;
        this.size = size;
    }

    public static JniUnsafeByteBuffer allocate(long size) {
        ArrowBuf arrowBuf = ArrowBufferAllocators.globalInstance().buffer(size);
        return new JniUnsafeByteBuffer(arrowBuf, size);
    }

    public long address() {
        this.ensureOpen();
        return this.buffer.memoryAddress();
    }

    public long size() {
        this.ensureOpen();
        return this.size;
    }

    private synchronized void ensureOpen() {
        if (this.released) {
            throw new IllegalStateException("Already released");
        }
    }

    private synchronized void release() {
        this.ensureOpen();
        this.buffer.close();
        this.released = true;
        this.buffer = null;
        this.size = 0L;
    }

    public synchronized byte[] toByteArray() {
        this.ensureOpen();
        byte[] values = new byte[Math.toIntExact(this.size)];
        Platform.copyMemory(null, (long)this.buffer.memoryAddress(), (Object)values, (long)Platform.BYTE_ARRAY_OFFSET, (long)values.length);
        this.release();
        return values;
    }

    public synchronized UnsafeByteArray toUnsafeByteArray() {
        this.ensureOpen();
        UnsafeByteArray out = new UnsafeByteArray(this.buffer, this.size);
        this.release();
        return out;
    }
}

