/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.velox;

import java.util.Iterator;
import org.apache.gluten.columnarbatch.ColumnarBatches;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.datasources.BlockStripe;
import org.apache.spark.sql.execution.datasources.BlockStripes;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class VeloxBlockStripes
extends BlockStripes {
    public VeloxBlockStripes(BlockStripes bs) {
        super(bs.originBlockAddress, bs.blockAddresses, bs.headingRowIndice, bs.originBlockNumColumns, bs.headingRowBytes);
    }

    @Override
    public Iterator<BlockStripe> iterator() {
        return new Iterator<BlockStripe>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < VeloxBlockStripes.this.blockAddresses.length;
            }

            @Override
            public BlockStripe next() {
                BlockStripe nextStripe = new BlockStripe(){
                    private final long blockAddress;
                    private final byte[] headingRowByteArray;
                    {
                        this.blockAddress = VeloxBlockStripes.this.blockAddresses[index];
                        this.headingRowByteArray = VeloxBlockStripes.this.headingRowBytes[index];
                    }

                    @Override
                    public ColumnarBatch getColumnarBatch() {
                        return ColumnarBatches.create(this.blockAddress);
                    }

                    @Override
                    public InternalRow getHeadingRow() {
                        UnsafeRow row = new UnsafeRow(VeloxBlockStripes.this.originBlockNumColumns);
                        row.pointTo(this.headingRowByteArray, this.headingRowByteArray.length);
                        return row;
                    }
                };
                ++this.index;
                return nextStripe;
            }
        };
    }

    @Override
    public void release() {
    }
}

