/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.gluten.backendsapi.BackendsApiManager$;
import org.apache.gluten.execution.ColumnarToRowExecBase;
import org.apache.gluten.execution.datasource.GlutenFormatFactory$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanExec;
import org.apache.spark.sql.execution.command.CreateDataSourceTableAsSelectCommand;
import org.apache.spark.sql.execution.command.DataWritingCommand;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.InsertIntoHadoopFsRelationCommand;
import org.apache.spark.sql.hive.execution.CreateHiveTableAsSelectCommand;
import org.apache.spark.sql.hive.execution.InsertIntoHiveDirCommand;
import org.apache.spark.sql.hive.execution.InsertIntoHiveTable;
import org.apache.spark.sql.sources.DataSourceRegister;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class GlutenWriterColumnarRules$ {
    public static final GlutenWriterColumnarRules$ MODULE$ = new GlutenWriterColumnarRules$();
    private static final Map<String, String> formatMapping = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat"), (Object)"orc"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat"), (Object)"parquet")}));

    private Map<String, String> formatMapping() {
        return formatMapping;
    }

    public Option<String> org$apache$spark$sql$execution$datasources$GlutenWriterColumnarRules$$getNativeFormat(DataWritingCommand cmd) {
        DataWritingCommand dataWritingCommand = cmd;
        if (dataWritingCommand instanceof CreateDataSourceTableAsSelectCommand) {
            CreateDataSourceTableAsSelectCommand createDataSourceTableAsSelectCommand = (CreateDataSourceTableAsSelectCommand)dataWritingCommand;
            if (!BackendsApiManager$.MODULE$.getSettings().skipNativeCtas(createDataSourceTableAsSelectCommand)) {
                return createDataSourceTableAsSelectCommand.table().provider().filter((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)GlutenFormatFactory$.MODULE$.isRegistered(name)));
            }
        }
        if (dataWritingCommand instanceof InsertIntoHadoopFsRelationCommand) {
            InsertIntoHadoopFsRelationCommand insertIntoHadoopFsRelationCommand = (InsertIntoHadoopFsRelationCommand)dataWritingCommand;
            if (!BackendsApiManager$.MODULE$.getSettings().skipNativeInsertInto(insertIntoHadoopFsRelationCommand)) {
                FileFormat fileFormat;
                FileFormat fileFormat2 = insertIntoHadoopFsRelationCommand.fileFormat();
                if (fileFormat2 instanceof DataSourceRegister && GlutenFormatFactory$.MODULE$.isRegistered(((DataSourceRegister)(fileFormat = fileFormat2)).shortName())) {
                    return new Some((Object)((DataSourceRegister)fileFormat).shortName());
                }
                return None$.MODULE$;
            }
        }
        if (dataWritingCommand instanceof InsertIntoHiveDirCommand) {
            InsertIntoHiveDirCommand insertIntoHiveDirCommand = (InsertIntoHiveDirCommand)dataWritingCommand;
            return insertIntoHiveDirCommand.storage().outputFormat().flatMap((Function1 & Serializable)key -> MODULE$.formatMapping().get(key)).filter((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)GlutenFormatFactory$.MODULE$.isRegistered(name)));
        }
        if (dataWritingCommand instanceof InsertIntoHiveTable) {
            InsertIntoHiveTable insertIntoHiveTable = (InsertIntoHiveTable)dataWritingCommand;
            return insertIntoHiveTable.table().storage().outputFormat().flatMap((Function1 & Serializable)key -> MODULE$.formatMapping().get(key)).filter((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)GlutenFormatFactory$.MODULE$.isRegistered(name)));
        }
        if (dataWritingCommand instanceof CreateHiveTableAsSelectCommand) {
            CreateHiveTableAsSelectCommand createHiveTableAsSelectCommand = (CreateHiveTableAsSelectCommand)dataWritingCommand;
            return createHiveTableAsSelectCommand.tableDesc().storage().outputFormat().flatMap((Function1 & Serializable)key -> MODULE$.formatMapping().get(key)).filter((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)GlutenFormatFactory$.MODULE$.isRegistered(name)));
        }
        return None$.MODULE$;
    }

    public SparkPlan injectFakeRowAdaptor(SparkPlan command, SparkPlan child) {
        SparkPlan sparkPlan = child;
        if (sparkPlan instanceof ColumnarToRowExecBase) {
            ColumnarToRowExecBase columnarToRowExecBase = (ColumnarToRowExecBase)sparkPlan;
            return (SparkPlan)command.withNewChildren((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)new SparkPlan[]{BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genColumnarToCarrierRow((SparkPlan)columnarToRowExecBase.child())}));
        }
        if (sparkPlan instanceof AdaptiveSparkPlanExec) {
            AdaptiveSparkPlanExec adaptiveSparkPlanExec = (AdaptiveSparkPlanExec)sparkPlan;
            return (SparkPlan)command.withNewChildren((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)new SparkPlan[]{BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genColumnarToCarrierRow((SparkPlan)new AdaptiveSparkPlanExec(adaptiveSparkPlanExec.inputPlan(), adaptiveSparkPlanExec.context(), adaptiveSparkPlanExec.preprocessingRules(), adaptiveSparkPlanExec.isSubquery(), true))}));
        }
        return (SparkPlan)command.withNewChildren((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)new SparkPlan[]{BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genColumnarToCarrierRow(sparkPlan)}));
    }

    public void injectSparkLocalProperty(SparkSession spark, Option<String> format, Option<Object> numStaticPartitions) {
        if (format.isDefined()) {
            spark.sparkContext().setLocalProperty("isNativeApplicable", Boolean.toString(true));
            spark.sparkContext().setLocalProperty("nativeFormat", (String)format.get());
            spark.sparkContext().setLocalProperty("staticPartitionWriteOnly", Boolean.toString(BackendsApiManager$.MODULE$.getSettings().staticPartitionWriteOnly()));
            spark.sparkContext().setLocalProperty("numStaticPartitionCols", numStaticPartitions.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0).toString());
            return;
        }
        spark.sparkContext().setLocalProperty("isNativeApplicable", null);
        spark.sparkContext().setLocalProperty("nativeFormat", null);
        spark.sparkContext().setLocalProperty("staticPartitionWriteOnly", null);
        spark.sparkContext().setLocalProperty("numStaticPartitionCols", null);
    }

    private GlutenWriterColumnarRules$() {
    }
}

