/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.Serializable;
import org.apache.gluten.backendsapi.BackendsApiManager$;
import org.apache.gluten.columnarbatch.ColumnarBatches;
import org.apache.gluten.memory.arrow.alloc.ArrowBufferAllocators;
import org.apache.gluten.sql.shims.SparkShimLoader$;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.Partition;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.TaskOutputFileAlreadyExistException;
import org.apache.spark.executor.OutputMetrics;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.FileNameSpec;
import org.apache.spark.rdd.RDD;
import org.apache.spark.shuffle.FetchFailedException;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.execution.SparkWriteFilesCommitProtocol;
import org.apache.spark.sql.execution.VeloxWriteFilesInfo;
import org.apache.spark.sql.execution.VeloxWriteFilesMetrics;
import org.apache.spark.sql.execution.datasources.BasicWriteTaskStats;
import org.apache.spark.sql.execution.datasources.DynamicPartitionDataSingleWriter;
import org.apache.spark.sql.execution.datasources.DynamicPartitionDataSingleWriter$;
import org.apache.spark.sql.execution.datasources.EmptyDirectoryDataWriter;
import org.apache.spark.sql.execution.datasources.EmptyDirectoryDataWriter$;
import org.apache.spark.sql.execution.datasources.ExecutedWriteSummary;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.execution.datasources.SingleDirectoryDataWriter;
import org.apache.spark.sql.execution.datasources.SingleDirectoryDataWriter$;
import org.apache.spark.sql.execution.datasources.WriteJobDescription;
import org.apache.spark.sql.execution.datasources.WriteTaskResult;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001\u0002\b\u0010\u0001iA\u0001\"\u000b\u0001\u0003\u0002\u0004%\tA\u000b\u0005\te\u0001\u0011\t\u0019!C\u0001g!AA\b\u0001B\u0001B\u0003&1\u0006\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011!!\u0005A!A!\u0002\u0013)\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u000be\u0003A\u0011\u0001.\t\u000b\u0005\u0004A\u0011\u00022\t\u000b-\u0004A\u0011\u00027\t\u000b=\u0004A\u0011\u00029\t\u000bY\u0004A\u0011I<\t\u000f\u0005e\u0001\u0001\"\u0015\u0002\u001c!9\u00111\u0005\u0001\u0005B\u0005\u0015\"A\u0007,fY>D8i\u001c7v[:\f'o\u0016:ji\u00164\u0015\u000e\\3t%\u0012#%B\u0001\t\u0012\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0013'\u0005\u00191/\u001d7\u000b\u0005Q)\u0012!B:qCJ\\'B\u0001\f\u0018\u0003\u0019\t\u0007/Y2iK*\t\u0001$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00017A\u0019AdH\u0011\u000e\u0003uQ!AH\n\u0002\u0007I$G-\u0003\u0002!;\t\u0019!\u000b\u0012#\u0011\u0005\t:S\"A\u0012\u000b\u0005\u0011*\u0013!B<sSR,'B\u0001\u0014\u0012\u0003%\u0019wN\u001c8fGR|'/\u0003\u0002)G\t\u0019rK]5uKJ\u001cu.\\7ji6+7o]1hK\u0006!\u0001O]3w+\u0005Y\u0003c\u0001\u000f YA\u0011Q\u0006M\u0007\u0002])\u0011q&E\u0001\u000bm\u0016\u001cGo\u001c:ju\u0016$\u0017BA\u0019/\u00055\u0019u\u000e\\;n]\u0006\u0014()\u0019;dQ\u0006A\u0001O]3w?\u0012*\u0017\u000f\u0006\u00025uA\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t!QK\\5u\u0011\u001dY$!!AA\u0002-\n1\u0001\u001f\u00132\u0003\u0015\u0001(/\u001a<!\u0003-!Wm]2sSB$\u0018n\u001c8\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005{\u0011a\u00033bi\u0006\u001cx.\u001e:dKNL!a\u0011!\u0003']\u0013\u0018\u000e^3K_\n$Um]2sSB$\u0018n\u001c8\u0002\u0013\r|W.\\5ui\u0016\u0014\bC\u0001$L\u001b\u00059%B\u0001%J\u0003\tIwN\u0003\u0002K'\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002M\u000f\n\u0011b)\u001b7f\u0007>lW.\u001b;Qe>$xnY8m\u00031QwN\u0019+sC\u000e\\WM]%E!\tyeK\u0004\u0002Q)B\u0011\u0011KN\u0007\u0002%*\u00111+G\u0001\u0007yI|w\u000e\u001e \n\u0005U3\u0014A\u0002)sK\u0012,g-\u0003\u0002X1\n11\u000b\u001e:j]\u001eT!!\u0016\u001c\u0002\rqJg.\u001b;?)\u0015YVLX0a!\ta\u0006!D\u0001\u0010\u0011\u0015Is\u00011\u0001,\u0011\u0015it\u00011\u0001?\u0011\u0015!u\u00011\u0001F\u0011\u0015iu\u00011\u0001O\u0003y\u0019w\u000e\u001c7fGRt\u0015\r^5wK^\u0013\u0018\u000e^3GS2,7/T3ue&\u001c7\u000f\u0006\u0002dSB\u0019Q\u0007\u001a4\n\u0005\u00154$AB(qi&|g\u000e\u0005\u0002@O&\u0011\u0001\u000e\u0011\u0002\u0010/JLG/\u001a+bg.\u0014Vm];mi\")!\u000e\u0003a\u0001Y\u0005\u00111MY\u0001\u0012e\u0016\u0004xN\u001d;UCN\\W*\u001a;sS\u000e\u001cHC\u0001\u001bn\u0011\u0015q\u0017\u00021\u0001g\u0003=9(/\u001b;f)\u0006\u001c8NU3tk2$\u0018AG<sSR,g)\u001b7fg\u001a{'/R7qifLE/\u001a:bi>\u0014HC\u00014r\u0011\u0015\u0011(\u00021\u0001t\u00039\u0019w.\\7jiB\u0013x\u000e^8d_2\u0004\"\u0001\u0018;\n\u0005U|!!H*qCJ\\wK]5uK\u001aKG.Z:D_6l\u0017\u000e\u001e)s_R|7m\u001c7\u0002\u000f\r|W\u000e];uKR)\u00010a\u0001\u0002\u0010A\u0019\u0011P`\u0011\u000f\u0005idhBA)|\u0013\u00059\u0014BA?7\u0003\u001d\u0001\u0018mY6bO\u0016L1a`A\u0001\u0005!IE/\u001a:bi>\u0014(BA?7\u0011\u001d\t)a\u0003a\u0001\u0003\u000f\tQa\u001d9mSR\u0004B!!\u0003\u0002\f5\t1#C\u0002\u0002\u000eM\u0011\u0011\u0002U1si&$\u0018n\u001c8\t\u000f\u0005E1\u00021\u0001\u0002\u0014\u000591m\u001c8uKb$\b\u0003BA\u0005\u0003+I1!a\u0006\u0014\u0005-!\u0016m]6D_:$X\r\u001f;\u0002\u001b\u001d,G\u000fU1si&$\u0018n\u001c8t+\t\ti\u0002E\u00036\u0003?\t9!C\u0002\u0002\"Y\u0012Q!\u0011:sCf\f\u0011c\u00197fCJ$U\r]3oI\u0016t7-[3t)\u0005!\u0004")
public class VeloxColumnarWriteFilesRDD
extends RDD<WriterCommitMessage> {
    private RDD<ColumnarBatch> prev;
    private final WriteJobDescription description;
    private final FileCommitProtocol committer;
    private final String jobTrackerID;

    public RDD<ColumnarBatch> prev() {
        return this.prev;
    }

    public void prev_$eq(RDD<ColumnarBatch> x$1) {
        this.prev = x$1;
    }

    private Option<WriteTaskResult> collectNativeWriteFilesMetrics(ColumnarBatch cb) {
        Object object;
        try (ColumnarBatch loadedCb = ColumnarBatches.load(ArrowBufferAllocators.contextInstance(), cb);){
            Predef$.MODULE$.assert(loadedCb.numCols() == 3);
            long numWrittenRows = loadedCb.column(0).getLong(0);
            ObjectRef updatedPartitions = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            Map addedAbsPathFiles = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            LongRef numBytes = LongRef.create((long)0L);
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.registerModule((Module)DefaultScalaModule$.MODULE$);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), loadedCb.numRows() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                String partitionFragment;
                UTF8String fragments = loadedCb.column(1).getUTF8String(i + 1);
                VeloxWriteFilesMetrics metrics = (VeloxWriteFilesMetrics)objectMapper.readValue(fragments.toString().getBytes("UTF-8"), VeloxWriteFilesMetrics.class);
                this.logDebug((Function0 & Serializable)() -> "Velox write files metrics: " + metrics);
                Seq<VeloxWriteFilesInfo> fileWriteInfos = metrics.fileWriteInfos();
                Predef$.MODULE$.assert(fileWriteInfos.length() == 1);
                VeloxWriteFilesInfo fileWriteInfo = (VeloxWriteFilesInfo)fileWriteInfos.head();
                numBytes$1.elem += fileWriteInfo.fileSize();
                String targetFileName = fileWriteInfo.targetFileName();
                String outputPath = $this.description.path();
                String string = partitionFragment = metrics.name();
                String string2 = "";
                if (string == null ? string2 != null : !string.equals(string2)) {
                    updatedPartitions$1.elem = (Set)((Set)updatedPartitions$1.elem).$plus((Object)partitionFragment);
                    String tmpOutputPath = outputPath + "/" + partitionFragment + "/" + targetFileName;
                    Option customOutputPath = $this.description.customPartitionLocations().get((Object)PartitioningUtils$.MODULE$.parsePathFragment(partitionFragment));
                    if (customOutputPath.isDefined()) {
                        addedAbsPathFiles.update((Object)tmpOutputPath, (Object)((String)customOutputPath.get() + "/" + targetFileName));
                        return;
                    }
                    return;
                }
            });
            int numFiles = loadedCb.numRows() - 1;
            Seq partitionsInternalRows = ((IterableOnceOps)((Set)updatedPartitions.elem).map((Function1 & Serializable)part -> {
                Object[] parts = new Object[]{part};
                return new GenericInternalRow(parts);
            })).toSeq();
            BasicWriteTaskStats stats = new BasicWriteTaskStats(partitionsInternalRows, numFiles, numBytes.elem, numWrittenRows);
            ExecutedWriteSummary summary = new ExecutedWriteSummary((Set)updatedPartitions.elem, (Seq)new .colon.colon((Object)stats, (List)Nil$.MODULE$));
            object = numFiles == 0 ? None$.MODULE$ : new Some((Object)new WriteTaskResult(new FileCommitProtocol.TaskCommitMessage((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)addedAbsPathFiles.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())), (Object)((Set)updatedPartitions.elem))), summary));
        }
        return object;
    }

    private void reportTaskMetrics(WriteTaskResult writeTaskResult) {
        BasicWriteTaskStats stats = (BasicWriteTaskStats)writeTaskResult.summary().stats().head();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(stats.numBytes(), stats.numRows());
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        long numBytes = sp2._1$mcJ$sp();
        long numWrittenRows = sp2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(numBytes, numWrittenRows);
        long numBytes2 = sp3._1$mcJ$sp();
        long numWrittenRows2 = sp3._2$mcJ$sp();
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable)x$2 -> x$2.taskMetrics().outputMetrics()).foreach((Function1 & Serializable)outputMetrics -> {
            VeloxColumnarWriteFilesRDD.$anonfun$reportTaskMetrics$2(numBytes2, numWrittenRows2, outputMetrics);
            return BoxedUnit.UNIT;
        });
    }

    private WriteTaskResult writeFilesForEmptyIterator(SparkWriteFilesCommitProtocol commitProtocol) {
        TaskAttemptContext taskAttemptContext = commitProtocol.taskAttemptContext();
        EmptyDirectoryDataWriter dataWriter = commitProtocol.sparkPartitionId() != 0 ? new EmptyDirectoryDataWriter(this.description, taskAttemptContext, this.committer, EmptyDirectoryDataWriter$.MODULE$.$lessinit$greater$default$4()) : (this.description.partitionColumns().isEmpty() ? new SingleDirectoryDataWriter(this.description, taskAttemptContext, this.committer, SingleDirectoryDataWriter$.MODULE$.$lessinit$greater$default$4()) : new DynamicPartitionDataSingleWriter(this.description, taskAttemptContext, this.committer, DynamicPartitionDataSingleWriter$.MODULE$.$lessinit$greater$default$4()));
        dataWriter.writeWithIterator(package$.MODULE$.Iterator().empty());
        return dataWriter.commit();
    }

    public Iterator<WriterCommitMessage> compute(Partition split, TaskContext context) {
        Object object;
        SparkWriteFilesCommitProtocol commitProtocol = new SparkWriteFilesCommitProtocol(this.jobTrackerID, this.description, this.committer);
        commitProtocol.setupTask();
        String writePath = commitProtocol.newTaskAttemptTempPath();
        String suffix = this.description.outputWriterFactory().getFileExtension(commitProtocol.taskAttemptContext());
        FileNameSpec fileNameSpec = new FileNameSpec("", suffix);
        String fileName = commitProtocol.getFilename(fileNameSpec);
        this.logDebug((Function0 & Serializable)() -> "Velox staging write path: " + writePath);
        ObjectRef writeTaskResult = ObjectRef.create(null);
        try {
            JFunction0.mcV.sp & Serializable x$1 = (JFunction0.mcV.sp & Serializable)() -> {
                BackendsApiManager$.MODULE$.getIteratorApiInstance().injectWriteFilesTempPath(writePath, fileName);
                Iterator iter = this.firstParent(ClassTag$.MODULE$.apply(ColumnarBatch.class)).iterator(split, context);
                Predef$.MODULE$.assert(iter.hasNext());
                ColumnarBatch resultColumnarBatch = (ColumnarBatch)iter.next();
                Predef$.MODULE$.assert(resultColumnarBatch != null);
                Option<WriteTaskResult> nativeWriteTaskResult = this.collectNativeWriteFilesMetrics(resultColumnarBatch);
                if (nativeWriteTaskResult.isEmpty()) {
                    writeTaskResult$1.elem = this.writeFilesForEmptyIterator(commitProtocol);
                    return;
                }
                writeTaskResult$1.elem = (WriteTaskResult)nativeWriteTaskResult.get();
                commitProtocol.commitTask();
            };
            JFunction0.mcV.sp & Serializable x$2 = (JFunction0.mcV.sp & Serializable)() -> {
                commitProtocol.abortTask(writePath);
                this.logError((Function0 & Serializable)() -> "Job " + commitProtocol.getJobId() + " aborted.");
            };
            JFunction0.mcV.sp & Serializable x$3 = () -> VeloxColumnarWriteFilesRDD.$anonfun$compute$5((Function0)x$1);
            object = Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0)x$1, (Function0)x$2, (Function0)x$3);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FetchFailedException) {
                FetchFailedException fetchFailedException = (FetchFailedException)throwable2;
                throw fetchFailedException;
            }
            if (throwable2 instanceof FileAlreadyExistsException) {
                FileAlreadyExistsException fileAlreadyExistsException = (FileAlreadyExistsException)throwable2;
                if (SQLConf$.MODULE$.get().fastFailFileFormatOutput()) {
                    throw new TaskOutputFileAlreadyExistException((Throwable)fileAlreadyExistsException);
                }
            }
            if (throwable2 == null) {
                throw throwable;
            }
            Throwable throwable3 = throwable2;
            SparkShimLoader$.MODULE$.getSparkShims().throwExceptionInWrite(throwable3, writePath, this.description.path());
            object = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.assert((WriteTaskResult)writeTaskResult.elem != null);
        this.reportTaskMetrics((WriteTaskResult)writeTaskResult.elem);
        return package$.MODULE$.Iterator().single((Object)((WriteTaskResult)writeTaskResult.elem));
    }

    public Partition[] getPartitions() {
        return this.firstParent(ClassTag$.MODULE$.apply(ColumnarBatch.class)).partitions();
    }

    public void clearDependencies() {
        super.clearDependencies();
        this.prev_$eq(null);
    }

    public static final /* synthetic */ void $anonfun$reportTaskMetrics$2(long numBytes$2, long numWrittenRows$1, OutputMetrics outputMetrics) {
        outputMetrics.setBytesWritten(numBytes$2);
        outputMetrics.setRecordsWritten(numWrittenRows$1);
    }

    public static final /* synthetic */ void $anonfun$compute$5(Function0 x$1$1) {
        Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks$default$3(x$1$1);
    }

    public VeloxColumnarWriteFilesRDD(RDD<ColumnarBatch> prev, WriteJobDescription description, FileCommitProtocol committer, String jobTrackerID) {
        this.prev = prev;
        this.description = description;
        this.committer = committer;
        this.jobTrackerID = jobTrackerID;
        super(prev, ClassTag$.MODULE$.apply(WriterCommitMessage.class));
    }
}

