/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.UUID;
import org.apache.gluten.sql.shims.SparkShimLoader$;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.FileNameSpec;
import org.apache.spark.internal.io.HadoopMapReduceCommitProtocol;
import org.apache.spark.sql.execution.datasources.WriteJobDescription;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005-e\u0001B\u0010!\u0001-B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"A1\n\u0001B\u0001B\u0003%A\nC\u0003S\u0001\u0011\u00051\u000bC\u0004Z\u0001\t\u0007I\u0011\u0001.\t\ry\u0003\u0001\u0015!\u0003\\\u0011\u001dy\u0006A1A\u0005\u0002iCa\u0001\u0019\u0001!\u0002\u0013Y\u0006bB1\u0001\u0005\u0004%\tA\u0017\u0005\u0007E\u0002\u0001\u000b\u0011B.\t\u000f\r\u0004!\u0019!C\u0005I\"1Q\u000e\u0001Q\u0001\n\u0015DqA\u001c\u0001C\u0002\u0013%q\u000e\u0003\u0004t\u0001\u0001\u0006I\u0001\u001d\u0005\bi\u0002\u0011\r\u0011\"\u0003v\u0011\u0019I\b\u0001)A\u0005m\"I!\u0010\u0001a\u0001\u0002\u0004%Ia\u001f\u0005\f\u0003\u0013\u0001\u0001\u0019!a\u0001\n\u0013\tY\u0001\u0003\u0006\u0002\u0018\u0001\u0001\r\u0011!Q!\nqD\u0011\"!\u0007\u0001\u0005\u0004%\t!a\u0007\t\u0011\u0005\r\u0002\u0001)A\u0005\u0003;A!\"!\n\u0001\u0011\u000b\u0007I\u0011BA\u0014\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!a\r\u0001\t\u0003\t)\u0004C\u0004\u00028\u0001!\t!!\u000f\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H!9\u0011\u0011\n\u0001\u0005\n\u0005-\u0003bBA<\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003s\u0002A\u0011AA>\u0011\u001d\t\t\t\u0001C\u0005\u0003\u0007\u0013Qd\u00159be.<&/\u001b;f\r&dWm]\"p[6LG\u000f\u0015:pi>\u001cw\u000e\u001c\u0006\u0003C\t\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\r\"\u0013aA:rY*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001a#\u0007\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0004B]f\u0014VM\u001a\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0011\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003oQ\u0012q\u0001T8hO&tw-\u0001\u0007k_\n$&/Y2lKJLE\t\u0005\u0002;\u0003:\u00111h\u0010\t\u0003y9j\u0011!\u0010\u0006\u0003})\na\u0001\u0010:p_Rt\u0014B\u0001!/\u0003\u0019\u0001&/\u001a3fM&\u0011!i\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001s\u0013a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\"AR%\u000e\u0003\u001dS!\u0001\u0013\u0011\u0002\u0017\u0011\fG/Y:pkJ\u001cWm]\u0005\u0003\u0015\u001e\u00131c\u0016:ji\u0016TuN\u0019#fg\u000e\u0014\u0018\u000e\u001d;j_:\f\u0011bY8n[&$H/\u001a:\u0011\u00055\u0003V\"\u0001(\u000b\u0005=#\u0014AA5p\u0013\t\tfJ\u0001\nGS2,7i\\7nSR\u0004&o\u001c;pG>d\u0017A\u0002\u001fj]&$h\b\u0006\u0003U-^C\u0006CA+\u0001\u001b\u0005\u0001\u0003\"\u0002\u001d\u0005\u0001\u0004I\u0004\"\u0002#\u0005\u0001\u0004)\u0005\"B&\u0005\u0001\u0004a\u0015\u0001D:qCJ\\7\u000b^1hK&#W#A.\u0011\u00055b\u0016BA//\u0005\rIe\u000e^\u0001\u000egB\f'o[*uC\u001e,\u0017\n\u001a\u0011\u0002!M\u0004\u0018M]6QCJ$\u0018\u000e^5p]&#\u0017!E:qCJ\\\u0007+\u0019:uSRLwN\\%eA\u0005\u00112\u000f]1sW\u0006#H/Z7qi:+XNY3s\u0003M\u0019\b/\u0019:l\u0003R$X-\u001c9u\u001dVl'-\u001a:!\u0003\u0015QwNY%e+\u0005)\u0007C\u00014l\u001b\u00059'B\u00015j\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0002kM\u00051\u0001.\u00193p_BL!\u0001\\4\u0003\u000b){'-\u0013#\u0002\r)|'-\u00133!\u0003\u0019!\u0018m]6JIV\t\u0001\u000f\u0005\u0002gc&\u0011!o\u001a\u0002\u0007)\u0006\u001c8.\u0013#\u0002\u000fQ\f7o[%eA\u0005iA/Y:l\u0003R$X-\u001c9u\u0013\u0012,\u0012A\u001e\t\u0003M^L!\u0001_4\u0003\u001bQ\u000b7o[!ui\u0016l\u0007\u000f^%E\u00039!\u0018m]6BiR,W\u000e\u001d;JI\u0002\n\u0011BZ5mK:\u000bW.Z:\u0016\u0003q\u0004B!`A\u0003s5\taPC\u0002\u0000\u0003\u0003\tq!\\;uC\ndWMC\u0002\u0002\u00049\n!bY8mY\u0016\u001cG/[8o\u0013\r\t9A \u0002\u0004'\u0016$\u0018!\u00044jY\u0016t\u0015-\\3t?\u0012*\u0017\u000f\u0006\u0003\u0002\u000e\u0005M\u0001cA\u0017\u0002\u0010%\u0019\u0011\u0011\u0003\u0018\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003+\u0011\u0012\u0011!a\u0001y\u0006\u0019\u0001\u0010J\u0019\u0002\u0015\u0019LG.\u001a(b[\u0016\u001c\b%\u0001\nuCN\\\u0017\t\u001e;f[B$8i\u001c8uKb$XCAA\u000f!\r1\u0017qD\u0005\u0004\u0003C9'A\u0005+bg.\fE\u000f^3naR\u001cuN\u001c;fqR\f1\u0003^1tW\u0006#H/Z7qi\u000e{g\u000e^3yi\u0002\n\u0011#\u001b8uKJt\u0017\r\\\"p[6LG\u000f^3s+\t\tI\u0003E\u0002g\u0003WI1!!\fh\u0005=yU\u000f\u001e9vi\u000e{W.\\5ui\u0016\u0014\u0018!C:fiV\u0004H+Y:l)\t\ti!\u0001\u0005hKRTuNY%e+\u0005I\u0014aC4fi\u001aKG.\u001a8b[\u0016$2!OA\u001e\u0011\u001d\ti$\u0007a\u0001\u0003\u007f\tAa\u001d9fGB\u0019Q*!\u0011\n\u0007\u0005\rcJ\u0001\u0007GS2,g*Y7f'B,7-\u0001\foK^$\u0016m]6BiR,W\u000e\u001d;UK6\u0004\b+\u0019;i)\u0005I\u0014\u0001E3oe&\u001c\u0007n\u0016:ji\u0016,%O]8s+\u0011\ti%!\u0016\u0015\t\u0005=\u0013\u0011\u000f\u000b\u0005\u0003#\n9\u0007\u0005\u0003\u0002T\u0005UC\u0002\u0001\u0003\b\u0003/Z\"\u0019AA-\u0005\u0005!\u0016\u0003BA.\u0003C\u00022!LA/\u0013\r\tyF\f\u0002\b\u001d>$\b.\u001b8h!\ri\u00131M\u0005\u0004\u0003Kr#aA!os\"A\u0011\u0011N\u000e\u0005\u0002\u0004\tY'A\u0001g!\u0015i\u0013QNA)\u0013\r\tyG\f\u0002\ty\tLh.Y7f}!A\u00111O\u000e\u0005\u0002\u0004\t)(\u0001\u0003qCRD\u0007\u0003B\u0017\u0002ne\n!bY8n[&$H+Y:l\u0003%\t'm\u001c:u)\u0006\u001c8\u000e\u0006\u0003\u0002\u000e\u0005u\u0004BBA@;\u0001\u0007\u0011(A\u0005xe&$X\rU1uQ\u0006Y1M]3bi\u0016TuNY%E)\u0015)\u0017QQAD\u0011\u0015Ad\u00041\u0001:\u0011\u0019\tII\ba\u00017\u0006\u0011\u0011\u000e\u001a")
public class SparkWriteFilesCommitProtocol
implements Logging {
    private OutputCommitter internalCommitter;
    private final WriteJobDescription description;
    private final FileCommitProtocol committer;
    private final int sparkStageId;
    private final int sparkPartitionId;
    private final int sparkAttemptNumber;
    private final JobID jobId;
    private final TaskID taskId;
    private final TaskAttemptID taskAttemptId;
    private Set<String> fileNames;
    private final TaskAttemptContext taskAttemptContext;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int sparkStageId() {
        return this.sparkStageId;
    }

    public int sparkPartitionId() {
        return this.sparkPartitionId;
    }

    public int sparkAttemptNumber() {
        return this.sparkAttemptNumber;
    }

    private JobID jobId() {
        return this.jobId;
    }

    private TaskID taskId() {
        return this.taskId;
    }

    private TaskAttemptID taskAttemptId() {
        return this.taskAttemptId;
    }

    private Set<String> fileNames() {
        return this.fileNames;
    }

    private void fileNames_$eq(Set<String> x$1) {
        this.fileNames = x$1;
    }

    public TaskAttemptContext taskAttemptContext() {
        return this.taskAttemptContext;
    }

    private OutputCommitter internalCommitter$lzycompute() {
        SparkWriteFilesCommitProtocol sparkWriteFilesCommitProtocol = this;
        synchronized (sparkWriteFilesCommitProtocol) {
            if (!this.bitmap$0) {
                Field field = HadoopMapReduceCommitProtocol.class.getDeclaredField("committer");
                field.setAccessible(true);
                this.internalCommitter = (OutputCommitter)field.get(this.committer);
                this.bitmap$0 = true;
            }
        }
        return this.internalCommitter;
    }

    private OutputCommitter internalCommitter() {
        if (!this.bitmap$0) {
            return this.internalCommitter$lzycompute();
        }
        return this.internalCommitter;
    }

    public void setupTask() {
        this.committer.setupTask(this.taskAttemptContext());
        this.fileNames_$eq((Set<String>)((Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    public String getJobId() {
        return this.jobId().toString();
    }

    public String getFilename(FileNameSpec spec) {
        int split = this.taskAttemptContext().getTaskAttemptID().getTaskID().getId();
        String basename = this.taskAttemptContext().getConfiguration().get("mapreduce.output.basename", "part");
        String fileName = StringOps$.MODULE$.format$extension("%s%s-%05d-%s%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{spec.prefix(), basename, BoxesRunTime.boxToInteger((int)split), UUID.randomUUID().toString(), spec.suffix()}));
        this.fileNames().$plus$eq((Object)fileName);
        return fileName;
    }

    public String newTaskAttemptTempPath() {
        Path path;
        Predef$.MODULE$.assert(this.internalCommitter() != null);
        OutputCommitter outputCommitter = this.internalCommitter();
        if (outputCommitter instanceof FileOutputCommitter) {
            FileOutputCommitter fileOutputCommitter = (FileOutputCommitter)outputCommitter;
            path = new Path((String)Option$.MODULE$.apply((Object)fileOutputCommitter.getWorkPath()).map((Function1 & Serializable)x$2 -> x$2.toString()).getOrElse((Function0 & Serializable)() -> $this.description.path()));
        } else {
            path = new Path(this.description.path());
        }
        Path stagingDir = path;
        return stagingDir.toString();
    }

    private <T> T enrichWriteError(Function0<String> path, Function0<T> f) {
        Object object;
        try {
            object = f.apply();
        }
        catch (Throwable t2) {
            throw SparkShimLoader$.MODULE$.getSparkShims().enrichWriteException(t2, this.description.path());
        }
        return (T)object;
    }

    public void commitTask() {
        this.enrichWriteError((Function0<String>)(Function0 & Serializable)() -> $this.description.path(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0 & Serializable)() -> $this.committer.commitTask(this.taskAttemptContext()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long taskCommitTime = tuple2._2$mcJ$sp();
            long taskCommitTime2 = taskCommitTime;
            $this.description.statsTrackers().foreach((Function1 & Serializable)stats -> stats.newTaskInstance().getFinalStats(taskCommitTime2));
        });
    }

    public void abortTask(String writePath) {
        this.enrichWriteError((Function0<String>)(Function0 & Serializable)() -> $this.description.path(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            $this.committer.abortTask(this.taskAttemptContext());
            this.fileNames().foreach((Function1 & Serializable)fileName -> BoxesRunTime.boxToBoolean((boolean)SparkWriteFilesCommitProtocol.$anonfun$abortTask$3(this, writePath, fileName)));
        });
    }

    private JobID createJobID(String jobTrackerID, int id) {
        if (id < 0) {
            throw new IllegalArgumentException("Job number is negative");
        }
        return new JobID(jobTrackerID, id);
    }

    public static final /* synthetic */ boolean $anonfun$abortTask$3(SparkWriteFilesCommitProtocol $this, String writePath$1, String fileName) {
        Path filePath = new Path(writePath$1, fileName);
        return filePath.getFileSystem($this.taskAttemptContext().getConfiguration()).delete(filePath, false);
    }

    public SparkWriteFilesCommitProtocol(String jobTrackerID, WriteJobDescription description, FileCommitProtocol committer) {
        this.description = description;
        this.committer = committer;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.assert(committer instanceof HadoopMapReduceCommitProtocol);
        this.sparkStageId = TaskContext$.MODULE$.get().stageId();
        this.sparkPartitionId = TaskContext$.MODULE$.get().partitionId();
        this.sparkAttemptNumber = (int)TaskContext$.MODULE$.get().taskAttemptId() & Integer.MAX_VALUE;
        this.jobId = this.createJobID(jobTrackerID, this.sparkStageId());
        this.taskId = new TaskID(this.jobId(), TaskType.MAP, this.sparkPartitionId());
        this.taskAttemptId = new TaskAttemptID(this.taskId(), this.sparkAttemptNumber());
        Configuration hadoopConf = description.serializableHadoopConf().value();
        hadoopConf.set("mapreduce.job.id", this.jobId().toString());
        hadoopConf.set("mapreduce.task.id", this.taskAttemptId().getTaskID().toString());
        hadoopConf.set("mapreduce.task.attempt.id", this.taskAttemptId().toString());
        hadoopConf.setBoolean("mapreduce.task.ismap", true);
        hadoopConf.setInt("mapreduce.task.partition", 0);
        this.taskAttemptContext = new TaskAttemptContextImpl(hadoopConf, this.taskAttemptId());
    }
}

