/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import org.apache.gluten.config.GlutenConfig;
import org.apache.gluten.events.GlutenPlanFallbackEvent;
import org.apache.gluten.execution.GlutenPlan;
import org.apache.gluten.extension.columnar.FallbackTag;
import org.apache.gluten.extension.columnar.FallbackTag$Converter$;
import org.apache.gluten.extension.columnar.FallbackTags$;
import org.apache.gluten.logging.LogLevelUtil;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.StringUtils;
import org.apache.spark.sql.execution.GlutenExplainUtils$;
import org.apache.spark.sql.execution.GlutenFallbackReporter$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.ui.GlutenUIUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001\u0002\u000f\u001e\u0001\"B\u0001b\u0014\u0001\u0003\u0016\u0004%\t\u0001\u0015\u0005\t/\u0002\u0011\t\u0012)A\u0005#\"A!\u0005\u0001BK\u0002\u0013\u0005\u0001\f\u0003\u0005^\u0001\tE\t\u0015!\u0003Z\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u00159\u0007\u0001\"\u0003i\u0011\u0015Q\b\u0001\"\u0003|\u0011\u0015i\b\u0001\"\u0003\u007f\u0011%\t\t\u0001AA\u0001\n\u0003\t\u0019\u0001C\u0005\u0002\n\u0001\t\n\u0011\"\u0001\u0002\f!I\u0011\u0011\u0005\u0001\u0012\u0002\u0013\u0005\u00111\u0005\u0005\n\u0003O\u0001\u0011\u0011!C!\u0003SA\u0011\"!\u000f\u0001\u0003\u0003%\t!a\u000f\t\u0013\u0005\r\u0003!!A\u0005\u0002\u0005\u0015\u0003\"CA)\u0001\u0005\u0005I\u0011IA*\u0011%\t\t\u0007AA\u0001\n\u0003\t\u0019\u0007C\u0005\u0002n\u0001\t\t\u0011\"\u0011\u0002p!I\u00111\u000f\u0001\u0002\u0002\u0013\u0005\u0013Q\u000f\u0005\n\u0003o\u0002\u0011\u0011!C!\u0003sB\u0011\"a\u001f\u0001\u0003\u0003%\t%! \b\u000f\u0005\u0005U\u0004#\u0001\u0002\u0004\u001a1A$\bE\u0001\u0003\u000bCaAX\f\u0005\u0002\u0005]\u0005\u0002C2\u0018\u0003\u0003%\t)!'\t\u0013\u0005}u#!A\u0005\u0002\u0006\u0005\u0006\"CAZ/\u0005\u0005I\u0011BA[\u0005Y9E.\u001e;f]\u001a\u000bG\u000e\u001c2bG.\u0014V\r]8si\u0016\u0014(B\u0001\u0010 \u0003%)\u00070Z2vi&|gN\u0003\u0002!C\u0005\u00191/\u001d7\u000b\u0005\t\u001a\u0013!B:qCJ\\'B\u0001\u0013&\u0003\u0019\t\u0007/Y2iK*\ta%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001SUj4\tE\u0002+_Ej\u0011a\u000b\u0006\u0003Y5\nQA];mKNT!AL\u0010\u0002\u0011\r\fG/\u00197zgRL!\u0001M\u0016\u0003\tI+H.\u001a\t\u0003eMj\u0011!H\u0005\u0003iu\u0011\u0011b\u00159be.\u0004F.\u00198\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014a\u00027pO\u001eLgn\u001a\u0006\u0003u\r\naa\u001a7vi\u0016t\u0017B\u0001\u001f8\u00051aun\u001a'fm\u0016dW\u000b^5m!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0012'\u000f\u0005\u0015SeB\u0001$J\u001b\u00059%B\u0001%(\u0003\u0019a$o\\8u}%\t\u0001)\u0003\u0002L\u007f\u00059\u0001/Y2lC\u001e,\u0017BA'O\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tYu(\u0001\u0006hYV$XM\\\"p]\u001a,\u0012!\u0015\t\u0003%Vk\u0011a\u0015\u0006\u0003)f\naaY8oM&<\u0017B\u0001,T\u000519E.\u001e;f]\u000e{gNZ5h\u0003-9G.\u001e;f]\u000e{gN\u001a\u0011\u0016\u0003e\u0003\"AW.\u000e\u0003}I!\u0001X\u0010\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\rM\u0004\u0018M]6!\u0003\u0019a\u0014N\\5u}Q\u0019\u0001-\u00192\u0011\u0005I\u0002\u0001\"B(\u0006\u0001\u0004\t\u0006\"\u0002\u0012\u0006\u0001\u0004I\u0016!B1qa2LHCA\u0019f\u0011\u00151g\u00011\u00012\u0003\u0011\u0001H.\u00198\u0002#1|wMR1mY\n\f7m\u001b*fCN|g\u000e\u0006\u0003jYZD\bC\u0001 k\u0013\tYwH\u0001\u0003V]&$\b\"B7\b\u0001\u0004q\u0017\u0001\u00037pO2+g/\u001a7\u0011\u0005=\u001chB\u00019r!\t1u(\u0003\u0002s\u007f\u00051\u0001K]3eK\u001aL!\u0001^;\u0003\rM#(/\u001b8h\u0015\t\u0011x\bC\u0003x\u000f\u0001\u0007a.\u0001\u0005o_\u0012,g*Y7f\u0011\u0015Ix\u00011\u0001o\u0003\u0019\u0011X-Y:p]\u0006\u0019\u0002O]5oi\u001a\u000bG\u000e\u001c2bG.\u0014V-Y:p]R\u0011\u0011\u000e \u0005\u0006M\"\u0001\r!M\u0001\u0013a>\u001cHOR1mY\n\f7m\u001b*fCN|g\u000e\u0006\u0002j\u007f\")a-\u0003a\u0001c\u0005!1m\u001c9z)\u0015\u0001\u0017QAA\u0004\u0011\u001dy%\u0002%AA\u0002ECqA\t\u0006\u0011\u0002\u0003\u0007\u0011,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u00055!fA)\u0002\u0010-\u0012\u0011\u0011\u0003\t\u0005\u0003'\ti\"\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001c}\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty\"!\u0006\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0015\"fA-\u0002\u0010\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u000b\u0011\t\u00055\u0012qG\u0007\u0003\u0003_QA!!\r\u00024\u0005!A.\u00198h\u0015\t\t)$\u0001\u0003kCZ\f\u0017b\u0001;\u00020\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\b\t\u0004}\u0005}\u0012bAA!\u007f\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qIA'!\rq\u0014\u0011J\u0005\u0004\u0003\u0017z$aA!os\"I\u0011qJ\b\u0002\u0002\u0003\u0007\u0011QH\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005U\u0003CBA,\u0003;\n9%\u0004\u0002\u0002Z)\u0019\u00111L \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002`\u0005e#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u001a\u0002lA\u0019a(a\u001a\n\u0007\u0005%tHA\u0004C_>dW-\u00198\t\u0013\u0005=\u0013#!AA\u0002\u0005\u001d\u0013A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u000b\u0002r!I\u0011q\n\n\u0002\u0002\u0003\u0007\u0011QH\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011QH\u0001\ti>\u001cFO]5oOR\u0011\u00111F\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0015\u0014q\u0010\u0005\n\u0003\u001f*\u0012\u0011!a\u0001\u0003\u000f\nac\u00127vi\u0016tg)\u00197mE\u0006\u001c7NU3q_J$XM\u001d\t\u0003e]\u0019RaFAD\u0003\u001b\u00032APAE\u0013\r\tYi\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005=\u0015QS\u0007\u0003\u0003#SA!a%\u00024\u0005\u0011\u0011n\\\u0005\u0004\u001b\u0006EECAAB)\u0015\u0001\u00171TAO\u0011\u0015y\u0015\u00041\u0001R\u0011\u0015\u0011\u0013\u00041\u0001Z\u0003\u001d)h.\u00199qYf$B!a)\u00020B)a(!*\u0002*&\u0019\u0011qU \u0003\r=\u0003H/[8o!\u0015q\u00141V)Z\u0013\r\tik\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005E&$!AA\u0002\u0001\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t9\f\u0005\u0003\u0002.\u0005e\u0016\u0002BA^\u0003_\u0011aa\u00142kK\u000e$\b")
public class GlutenFallbackReporter
extends Rule<SparkPlan>
implements LogLevelUtil,
Product,
Serializable {
    private final GlutenConfig glutenConf;
    private final SparkSession spark;

    public static Option<Tuple2<GlutenConfig, SparkSession>> unapply(GlutenFallbackReporter x$0) {
        return GlutenFallbackReporter$.MODULE$.unapply(x$0);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public void logOnLevel(String level, Function0<String> msg) {
        LogLevelUtil.logOnLevel$(this, level, msg);
    }

    @Override
    public void logOnLevel(String level, Function0<String> msg, Throwable e) {
        LogLevelUtil.logOnLevel$(this, level, msg, e);
    }

    public GlutenConfig glutenConf() {
        return this.glutenConf;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public SparkPlan apply(SparkPlan plan) {
        block1: {
            if (!this.glutenConf().enableFallbackReport()) {
                return plan;
            }
            this.printFallbackReason(plan);
            if (!GlutenUIUtils$.MODULE$.uiEnabled(this.spark().sparkContext())) break block1;
            this.postFallbackReason(plan);
        }
        return plan;
    }

    private void logFallbackReason(String logLevel, String nodeName, String reason) {
        String executionIdInfo = (String)Option$.MODULE$.apply((Object)this.spark().sparkContext().getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY())).map((Function1 & Serializable)id -> "[QueryId=" + id + "]").getOrElse((Function0 & Serializable)() -> "");
        this.logOnLevel(logLevel, (Function0<String>)(Function0 & Serializable)() -> "Validation failed for plan: " + nodeName + executionIdInfo + ", due to: " + reason);
    }

    private void printFallbackReason(SparkPlan plan) {
        String validationLogLevel = this.glutenConf().validationLogLevel();
        plan.foreachUp((Function1 & Serializable)x0$1 -> {
            GlutenFallbackReporter.$anonfun$printFallbackReason$1(this, validationLogLevel, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void postFallbackReason(SparkPlan plan) {
        SparkContext sc = this.spark().sparkContext();
        String executionId = sc.getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
        if (executionId == null) {
            this.logDebug((Function0 & Serializable)() -> "Unknown execution id for plan: " + plan);
            return;
        }
        StringUtils.PlanStringConcat concat = new StringUtils.PlanStringConcat();
        concat.append("== Physical Plan ==\n");
        Tuple2<Object, Map<String, String>> tuple2 = GlutenExplainUtils$.MODULE$.processPlan(plan, (Function1<String, BoxedUnit>)(Function1 & Serializable)s2 -> {
            concat.append(s2);
            return BoxedUnit.UNIT;
        }, GlutenExplainUtils$.MODULE$.processPlan$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int numGlutenNodes = tuple2._1$mcI$sp();
        Map fallbackNodeToReason = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)numGlutenNodes), (Object)fallbackNodeToReason);
        int numGlutenNodes2 = tuple22._1$mcI$sp();
        Map fallbackNodeToReason2 = (Map)tuple22._2();
        GlutenPlanFallbackEvent event = new GlutenPlanFallbackEvent(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(executionId)), numGlutenNodes2, fallbackNodeToReason2.size(), concat.toString(), (Map<String, String>)fallbackNodeToReason2);
        GlutenUIUtils$.MODULE$.postEvent(sc, event);
    }

    public GlutenFallbackReporter copy(GlutenConfig glutenConf, SparkSession spark) {
        return new GlutenFallbackReporter(glutenConf, spark);
    }

    public GlutenConfig copy$default$1() {
        return this.glutenConf();
    }

    public SparkSession copy$default$2() {
        return this.spark();
    }

    public String productPrefix() {
        return "GlutenFallbackReporter";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.glutenConf();
            }
            case 1: {
                return this.spark();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GlutenFallbackReporter;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "glutenConf";
            }
            case 1: {
                return "spark";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, -1789543315, true);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GlutenFallbackReporter)) return false;
        boolean bl = true;
        if (!bl) return false;
        GlutenFallbackReporter glutenFallbackReporter = (GlutenFallbackReporter)x$1;
        GlutenConfig glutenConfig = this.glutenConf();
        GlutenConfig glutenConfig2 = glutenFallbackReporter.glutenConf();
        if (glutenConfig == null) {
            if (glutenConfig2 != null) {
                return false;
            }
        } else if (!glutenConfig.equals(glutenConfig2)) return false;
        SparkSession sparkSession = this.spark();
        SparkSession sparkSession2 = glutenFallbackReporter.spark();
        if (sparkSession == null) {
            if (sparkSession2 != null) {
                return false;
            }
        } else if (!sparkSession.equals(sparkSession2)) return false;
        if (!glutenFallbackReporter.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$printFallbackReason$1(GlutenFallbackReporter $this, String validationLogLevel$1, SparkPlan x0$1) {
        SparkPlan sparkPlan;
        SparkPlan sparkPlan2 = x0$1;
        if (sparkPlan2 instanceof GlutenPlan) {
            return;
        }
        if (sparkPlan2 != null && FallbackTags$.MODULE$.nonEmpty(sparkPlan = sparkPlan2)) {
            FallbackTag tag = FallbackTags$.MODULE$.get((TreeNode<?>)sparkPlan);
            $this.logFallbackReason(validationLogLevel$1, sparkPlan.nodeName(), tag.reason());
            sparkPlan.logicalLink().foreach((Function1 & Serializable)logicalPlan -> {
                FallbackTags$.MODULE$.add((TreeNode<?>)logicalPlan, tag, FallbackTag$Converter$.MODULE$.asIs());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public GlutenFallbackReporter(GlutenConfig glutenConf, SparkSession spark) {
        this.glutenConf = glutenConf;
        this.spark = spark;
        LogLevelUtil.$init$(this);
        Product.$init$((Product)this);
    }
}

