/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.util.Map;
import org.apache.gluten.config.GlutenConfig;
import org.apache.gluten.config.GlutenCoreConfig$;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.resource.ResourceProfileManager;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.ApplyResourceProfileExec;
import org.apache.spark.sql.execution.GlutenAutoAdjustStageResourceProfile;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.QueryStageExec;
import org.apache.spark.sql.execution.command.DataWritingCommandExec;
import org.apache.spark.sql.execution.command.ExecutedCommandExec;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.SparkTestUtil$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class GlutenAutoAdjustStageResourceProfile$
implements Logging,
Serializable {
    public static final GlutenAutoAdjustStageResourceProfile$ MODULE$ = new GlutenAutoAdjustStageResourceProfile$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ArrayBuffer<SparkPlan> collectStagePlan(SparkPlan plan) {
        ArrayBuffer planNodes = new ArrayBuffer();
        GlutenAutoAdjustStageResourceProfile$.collectStagePlan$1(plan, planNodes);
        return planNodes;
    }

    private ResourceProfile getFinalResourceProfile(ResourceProfileManager rpManager, ResourceProfile newRP) {
        if (SparkTestUtil$.MODULE$.isTesting()) {
            return rpManager.defaultResourceProfile();
        }
        Option maybeEqProfile = rpManager.getEquivalentProfile(newRP);
        if (maybeEqProfile.isDefined()) {
            return (ResourceProfile)maybeEqProfile.get();
        }
        rpManager.addResourceProfile(newRP);
        return newRP;
    }

    public void updateResourceSetting(ResourceProfile rp, SparkConf sparkConf) {
        int coresPerExecutor = BoxesRunTime.unboxToInt((Object)rp.getExecutorCores().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES()))));
        int coresPerTask = BoxesRunTime.unboxToInt((Object)rp.getTaskCpus().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.CPUS_PER_TASK()))));
        int taskSlots = coresPerExecutor / coresPerTask;
        SQLConf conf = SQLConf$.MODULE$.get();
        conf.setConfString(GlutenCoreConfig$.MODULE$.NUM_TASK_SLOTS_PER_EXECUTOR().key(), Integer.toString(taskSlots));
        long offHeapSize = BoxesRunTime.unboxToLong((Object)rp.executorResources().get((Object)ResourceProfile$.MODULE$.OFFHEAP_MEM()).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.amount())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.MEMORY_OFFHEAP_SIZE()))));
        conf.setConfString(GlutenCoreConfig$.MODULE$.COLUMNAR_OFFHEAP_SIZE_IN_BYTES().key(), Long.toString(offHeapSize));
        conf.setConfString(GlutenCoreConfig$.MODULE$.COLUMNAR_TASK_OFFHEAP_SIZE_IN_BYTES().key(), Long.toString(offHeapSize / (long)taskSlots));
    }

    public SparkPlan applyNewResourceProfileIfPossible(SparkPlan plan, ResourceProfile rp, ResourceProfileManager rpManager, SparkConf sparkConf) {
        this.updateResourceSetting(rp, sparkConf);
        ResourceProfile finalRP = this.getFinalResourceProfile(rpManager, rp);
        ApplyResourceProfileExec wrapperPlan = new ApplyResourceProfileExec((SparkPlan)plan.children().head(), finalRP);
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Apply resource profile " + finalRP + " for plan " + wrapperPlan.nodeName());
        return (SparkPlan)plan.withNewChildren((Seq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ApplyResourceProfileExec[]{wrapperPlan})));
    }

    public GlutenAutoAdjustStageResourceProfile apply(GlutenConfig glutenConf, SparkSession spark) {
        return new GlutenAutoAdjustStageResourceProfile(glutenConf, spark);
    }

    public Option<Tuple2<GlutenConfig, SparkSession>> unapply(GlutenAutoAdjustStageResourceProfile x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.glutenConf(), (Object)x$0.spark()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GlutenAutoAdjustStageResourceProfile$.class);
    }

    private static final void collectStagePlan$1(SparkPlan plan, ArrayBuffer planNodes) {
        if (plan instanceof DataWritingCommandExec || plan instanceof ExecutedCommandExec) {
            return;
        }
        planNodes.$plus$eq((Object)plan);
        if (plan instanceof QueryStageExec) {
            return;
        }
        plan.children().foreach((Function1 & Serializable)x$4 -> {
            GlutenAutoAdjustStageResourceProfile$.collectStagePlan$1(x$4, planNodes);
            return BoxedUnit.UNIT;
        });
    }

    private GlutenAutoAdjustStageResourceProfile$() {
    }
}

