/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.util.List;
import org.apache.gluten.backendsapi.BackendsApiManager$;
import org.apache.gluten.columnarbatch.ColumnarBatches;
import org.apache.gluten.config.VeloxConfig$;
import org.apache.gluten.runtime.Runtimes$;
import org.apache.gluten.sql.shims.SparkShimLoader$;
import org.apache.gluten.vectorized.ColumnarBatchSerializeResult;
import org.apache.gluten.vectorized.ColumnarBatchSerializerJniWrapper;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastMode;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.IdentityBroadcastMode$;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.execution.ColumnarBuildSideRelation$;
import org.apache.spark.sql.execution.joins.BuildSideRelation;
import org.apache.spark.sql.execution.joins.EmptyHashedRelation$;
import org.apache.spark.sql.execution.joins.HashedRelation;
import org.apache.spark.sql.execution.joins.HashedRelationBroadcastMode;
import org.apache.spark.sql.execution.joins.LongHashedRelation;
import org.apache.spark.sql.execution.unsafe.JniUnsafeByteBuffer;
import org.apache.spark.sql.execution.unsafe.UnsafeByteArray;
import org.apache.spark.sql.execution.unsafe.UnsafeColumnarBuildSideRelation$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.task.TaskResources$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;

public final class BroadcastUtils$ {
    public static final BroadcastUtils$ MODULE$ = new BroadcastUtils$();

    public <F, T> Broadcast<T> veloxToSparkUnsafe(SparkContext context, BroadcastMode mode, Broadcast<F> from, Function1<Iterator<ColumnarBatch>, Iterator<InternalRow>> fn) {
        BroadcastMode broadcastMode = mode;
        if (broadcastMode instanceof HashedRelationBroadcastMode) {
            Broadcast<F> fromBroadcast = from;
            BuildSideRelation fromRelation = ((BuildSideRelation)fromBroadcast.value()).asReadOnlyCopy();
            LongRef rowCount = LongRef.create((long)0L);
            Object toRelation = TaskResources$.MODULE$.runUnsafe((Function0 & Serializable)() -> {
                Iterator rowIterator = (Iterator)fn.apply((Object)fromRelation.deserialized().flatMap((Function1 & Serializable)cb -> {
                    rowCount$1.elem += (long)cb.numRows();
                    return package$.MODULE$.Iterator().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ColumnarBatch[]{cb}));
                }));
                return mode.transform(rowIterator, (Option)new Some((Object)BoxesRunTime.boxToLong((long)rowCount$1.elem)));
            });
            return context.broadcast(toRelation, ClassTag$.MODULE$.Any());
        }
        if (IdentityBroadcastMode$.MODULE$.equals(broadcastMode)) {
            Broadcast<F> fromBroadcast = from;
            BuildSideRelation fromRelation = ((BuildSideRelation)fromBroadcast.value()).asReadOnlyCopy();
            InternalRow[] toRelation = (InternalRow[])TaskResources$.MODULE$.runUnsafe((Function0 & Serializable)() -> {
                Iterator rowIterator = (Iterator)fn.apply(fromRelation.deserialized());
                ArrayBuffer rowArray = new ArrayBuffer();
                while (rowIterator.hasNext()) {
                    UnsafeRow unsafeRow = (UnsafeRow)rowIterator.next();
                    rowArray.append((Object)unsafeRow.copy());
                }
                return (InternalRow[])rowArray.toArray(ClassTag$.MODULE$.apply(InternalRow.class));
            });
            return context.broadcast((Object)toRelation, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(InternalRow.class)));
        }
        throw new IllegalStateException("Unexpected broadcast mode: " + mode);
    }

    public <F, T> Broadcast<T> sparkToVeloxUnsafe(SparkContext context, BroadcastMode mode, StructType schema, Broadcast<F> from, Function1<Iterator<InternalRow>, Iterator<ColumnarBatch>> fn) {
        BroadcastMode broadcastMode = mode;
        if (broadcastMode instanceof HashedRelationBroadcastMode) {
            Broadcast<F> fromBroadcast = from;
            HashedRelation fromRelation = ((HashedRelation)fromBroadcast.value()).asReadOnlyCopy();
            BuildSideRelation toRelation = BroadcastUtils$.batchIterationToRelation$1((Function0 & Serializable)() -> (Iterator)fn.apply(MODULE$.reconstructRows(fromRelation)), schema, mode);
            return context.broadcast((Object)toRelation, ClassTag$.MODULE$.apply(BuildSideRelation.class));
        }
        if (IdentityBroadcastMode$.MODULE$.equals(broadcastMode)) {
            Broadcast<F> fromBroadcast = from;
            InternalRow[] fromRelation = (InternalRow[])fromBroadcast.value();
            BuildSideRelation toRelation = BroadcastUtils$.batchIterationToRelation$1((Function0 & Serializable)() -> (Iterator)fn.apply((Object)ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])fromRelation))), schema, mode);
            return context.broadcast((Object)toRelation, ClassTag$.MODULE$.apply(BuildSideRelation.class));
        }
        throw new IllegalStateException("Unexpected broadcast mode: " + mode);
    }

    public BroadcastMode getBroadcastMode(Partitioning partitioning) {
        Partitioning partitioning2 = partitioning;
        if (partitioning2 instanceof BroadcastPartitioning) {
            BroadcastPartitioning broadcastPartitioning = (BroadcastPartitioning)partitioning2;
            BroadcastMode mode = broadcastPartitioning.mode();
            return mode;
        }
        throw new IllegalArgumentException("Unexpected partitioning: " + partitioning.toString());
    }

    public ColumnarBatchSerializeResult serializeStream(Iterator<ColumnarBatch> batches) {
        LongRef numRows;
        Iterator filtered = batches.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BroadcastUtils$.$anonfun$serializeStream$1(x$1))).map((Function1 & Serializable)b -> {
            ColumnarBatches.retain(b);
            return b;
        });
        JniUnsafeByteBuffer[] values = (JniUnsafeByteBuffer[])filtered.map(arg_0 -> BroadcastUtils$.$anonfun$serializeStream$3(numRows = LongRef.create((long)0L), arg_0)).toArray(ClassTag$.MODULE$.apply(JniUnsafeByteBuffer.class));
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])values))) {
            boolean useOffheapBroadcastBuildRelation = VeloxConfig$.MODULE$.get().enableBroadcastBuildRelationInOffheap();
            return new ColumnarBatchSerializeResult(useOffheapBroadcastBuildRelation, numRows.elem, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])values))).asJava());
        }
        return ColumnarBatchSerializeResult.EMPTY;
    }

    private Iterator<InternalRow> reconstructRows(HashedRelation relation) {
        boolean bl = false;
        LongHashedRelation longHashedRelation = null;
        HashedRelation hashedRelation = relation;
        if (hashedRelation instanceof LongHashedRelation) {
            bl = true;
            longHashedRelation = (LongHashedRelation)hashedRelation;
            if (longHashedRelation.keyIsUnique()) {
                return longHashedRelation.keys().map((Function1 & Serializable)k -> longHashedRelation.getValue(k));
            }
        }
        if (bl && !longHashedRelation.keyIsUnique()) {
            return longHashedRelation.keys().flatMap((Function1 & Serializable)k -> longHashedRelation.get(k));
        }
        if (EmptyHashedRelation$.MODULE$.equals(hashedRelation)) {
            return package$.MODULE$.Iterator().empty();
        }
        return hashedRelation.valuesWithKeyIndex().map((Function1 & Serializable)x$2 -> x$2.getValue());
    }

    private static final BuildSideRelation batchIterationToRelation$1(Function0 batchItr, StructType schema$1, BroadcastMode mode$2) {
        return (BuildSideRelation)TaskResources$.MODULE$.runUnsafe((Function0 & Serializable)() -> {
            ColumnarBatchSerializeResult columnarBatchSerializeResult = MODULE$.serializeStream((Iterator<ColumnarBatch>)((Iterator)batchItr.apply()));
            ColumnarBatchSerializeResult columnarBatchSerializeResult2 = ColumnarBatchSerializeResult.EMPTY;
            ColumnarBatchSerializeResult columnarBatchSerializeResult3 = columnarBatchSerializeResult;
            if (!(columnarBatchSerializeResult2 != null ? !columnarBatchSerializeResult2.equals(columnarBatchSerializeResult3) : columnarBatchSerializeResult3 != null)) {
                return ColumnarBuildSideRelation$.MODULE$.apply(SparkShimLoader$.MODULE$.getSparkShims().attributesFromStruct(schema$1), (byte[][])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), mode$2);
            }
            if (columnarBatchSerializeResult != null) {
                ColumnarBatchSerializeResult columnarBatchSerializeResult4 = columnarBatchSerializeResult;
                if (columnarBatchSerializeResult4.isOffHeap()) {
                    return UnsafeColumnarBuildSideRelation$.MODULE$.apply(SparkShimLoader$.MODULE$.getSparkShims().attributesFromStruct(schema$1), (scala.collection.immutable.Seq<UnsafeByteArray>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(columnarBatchSerializeResult4.offHeapData()).asScala()).toSeq(), mode$2);
                }
                return ColumnarBuildSideRelation$.MODULE$.apply(SparkShimLoader$.MODULE$.getSparkShims().attributesFromStruct(schema$1), (byte[][])((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(columnarBatchSerializeResult4.onHeapData()).asScala()).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), mode$2);
            }
            throw new MatchError((Object)columnarBatchSerializeResult);
        });
    }

    public static final /* synthetic */ boolean $anonfun$serializeStream$1(ColumnarBatch x$1) {
        return x$1.numRows() != 0;
    }

    public static final /* synthetic */ JniUnsafeByteBuffer $anonfun$serializeStream$3(LongRef numRows$1, ColumnarBatch b) {
        JniUnsafeByteBuffer jniUnsafeByteBuffer;
        long handle = ColumnarBatches.getNativeHandle(BackendsApiManager$.MODULE$.getBackendName(), b);
        numRows$1.elem += (long)b.numRows();
        try {
            jniUnsafeByteBuffer = ColumnarBatchSerializerJniWrapper.create(Runtimes$.MODULE$.contextInstance(BackendsApiManager$.MODULE$.getBackendName(), "BroadcastUtils#serializeStream")).serialize(handle);
        }
        finally {
            ColumnarBatches.release(b);
        }
        return jniUnsafeByteBuffer;
    }

    private BroadcastUtils$() {
    }
}

