/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastMode;
import org.apache.spark.sql.catalyst.plans.physical.IdentityBroadcastMode$;
import org.apache.spark.sql.execution.HashExprSafeBroadcastMode;
import org.apache.spark.sql.execution.HashSafeBroadcastMode;
import org.apache.spark.sql.execution.IdentitySafeBroadcastMode$;
import org.apache.spark.sql.execution.SafeBroadcastMode;
import org.apache.spark.sql.execution.joins.HashedRelationBroadcastMode;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BroadcastModeUtils$
implements Logging {
    public static final BroadcastModeUtils$ MODULE$ = new BroadcastModeUtils$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SafeBroadcastMode toSafe(BroadcastMode mode) {
        BroadcastMode broadcastMode = mode;
        if (IdentityBroadcastMode$.MODULE$.equals(broadcastMode)) {
            return IdentitySafeBroadcastMode$.MODULE$;
        }
        if (broadcastMode instanceof HashedRelationBroadcastMode) {
            HashedRelationBroadcastMode hashedRelationBroadcastMode = (HashedRelationBroadcastMode)broadcastMode;
            Seq keys = hashedRelationBroadcastMode.key();
            boolean isNullAware = hashedRelationBroadcastMode.isNullAware();
            Seq ords = (Seq)keys.collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof BoundReference) {
                        BoundReference boundReference = (BoundReference)A1;
                        int ord = boundReference.ordinal();
                        return (B1)BoxesRunTime.boxToInteger((int)ord);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Expression x1) {
                    Expression expression = x1;
                    return expression instanceof BoundReference;
                }
            });
            if (ords.size() == keys.size()) {
                return new HashSafeBroadcastMode((int[])ords.toArray((ClassTag)ClassTag$.MODULE$.Int()), isNullAware);
            }
            return new HashExprSafeBroadcastMode(this.serializeExpressions((Seq<Expression>)keys), isNullAware);
        }
        throw new IllegalArgumentException("Unsupported BroadcastMode: " + broadcastMode);
    }

    public BroadcastMode fromSafe(SafeBroadcastMode safe, Seq<Attribute> output) {
        SafeBroadcastMode safeBroadcastMode = safe;
        if (IdentitySafeBroadcastMode$.MODULE$.equals(safeBroadcastMode)) {
            return IdentityBroadcastMode$.MODULE$;
        }
        if (safeBroadcastMode instanceof HashSafeBroadcastMode) {
            HashSafeBroadcastMode hashSafeBroadcastMode = (HashSafeBroadcastMode)safeBroadcastMode;
            int[] ords = hashSafeBroadcastMode.ordinals();
            boolean isNullAware = hashSafeBroadcastMode.isNullAware();
            Seq bound = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(ords), (Function1 & Serializable)i -> BroadcastModeUtils$.$anonfun$fromSafe$1(output, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(BoundReference.class))));
            return new HashedRelationBroadcastMode(bound, isNullAware);
        }
        if (safeBroadcastMode instanceof HashExprSafeBroadcastMode) {
            HashExprSafeBroadcastMode hashExprSafeBroadcastMode = (HashExprSafeBroadcastMode)safeBroadcastMode;
            byte[] bytes = hashExprSafeBroadcastMode.exprBytes();
            boolean isNullAware = hashExprSafeBroadcastMode.isNullAware();
            return new HashedRelationBroadcastMode(this.deserializeExpressions(bytes), isNullAware);
        }
        throw new MatchError((Object)safeBroadcastMode);
    }

    public byte[] serializeExpressions(Seq<Expression> keys) {
        byte[] byArray;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            try {
                oos = new ObjectOutputStream(bos);
                oos.writeObject(keys);
                oos.flush();
                byArray = bos.toByteArray();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IOException ? true : (throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof ClassCastException)) {
                    this.logError((Function0<String>)(Function0 & Serializable)() -> "Failed to serialize expressions for BroadcastMode. Expression count: " + keys.length(), throwable2);
                    throw new RuntimeException("Failed to serialize expressions for BroadcastMode", throwable2);
                }
                if (throwable2 instanceof Exception) {
                    Exception exception = (Exception)throwable2;
                    this.logError((Function0<String>)(Function0 & Serializable)() -> "Unexpected error during expression serialization. Expression count: " + keys.length(), (Throwable)exception);
                    throw exception;
                }
                throw throwable;
            }
        }
        finally {
            if (oos != null) {
                oos.close();
            }
            bos.close();
        }
        return byArray;
    }

    public Seq<Expression> deserializeExpressions(byte[] bytes) {
        Seq seq;
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = null;
        try {
            try {
                ois = new ObjectInputStream(bis);
                seq = (Seq)ois.readObject();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IOException ? true : (throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof ClassCastException)) {
                    this.logError((Function0<String>)(Function0 & Serializable)() -> "Failed to deserialize expressions for BroadcastMode. Data size: " + bytes.length + " bytes", throwable2);
                    throw new RuntimeException("Failed to deserialize expressions for BroadcastMode", throwable2);
                }
                if (throwable2 instanceof Exception) {
                    Exception exception = (Exception)throwable2;
                    this.logError((Function0<String>)(Function0 & Serializable)() -> "Unexpected error during expression deserialization. Data size: " + bytes.length + " bytes", (Throwable)exception);
                    throw exception;
                }
                throw throwable;
            }
        }
        finally {
            if (ois != null) {
                ois.close();
            }
            bis.close();
        }
        return seq;
    }

    public static final /* synthetic */ BoundReference $anonfun$fromSafe$1(Seq output$1, int i) {
        return new BoundReference(i, ((Expression)output$1.apply(i)).dataType(), ((Expression)output$1.apply(i)).nullable());
    }

    private BroadcastModeUtils$() {
    }
}

