/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.Serializable;
import java.util.Locale;
import org.apache.gluten.backendsapi.BackendsApiManager$;
import org.apache.gluten.config.GlutenConfig;
import org.apache.gluten.config.GlutenConfig$;
import org.apache.gluten.sql.shims.SparkShimLoader$;
import org.apache.gluten.vectorized.NativePartitioning;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.shuffle.BaseShuffleHandle;
import org.apache.spark.shuffle.GenShuffleReaderParameters;
import org.apache.spark.shuffle.GenShuffleWriterParameters;
import org.apache.spark.shuffle.IndexShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.SparkSortShuffleWriterUtil$;
import org.apache.spark.shuffle.api.ShuffleExecutorComponents;
import org.apache.spark.shuffle.sort.ColumnarShuffleHandle;
import org.apache.spark.shuffle.sort.SortShuffleManager$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class GlutenShuffleUtils$ {
    public static final GlutenShuffleUtils$ MODULE$ = new GlutenShuffleUtils$();
    private static final String SinglePartitioningShortName = "single";
    private static final String RoundRobinPartitioningShortName = "rr";
    private static final String HashPartitioningShortName = "hash";
    private static final String RangePartitioningShortName = "range";
    private static final int DEFAULT_COMPRESSION_LEVEL = Integer.MIN_VALUE;

    public String SinglePartitioningShortName() {
        return SinglePartitioningShortName;
    }

    public String RoundRobinPartitioningShortName() {
        return RoundRobinPartitioningShortName;
    }

    public String HashPartitioningShortName() {
        return HashPartitioningShortName;
    }

    public String RangePartitioningShortName() {
        return RangePartitioningShortName;
    }

    public int DEFAULT_COMPRESSION_LEVEL() {
        return DEFAULT_COMPRESSION_LEVEL;
    }

    public int getStartPartitionId(NativePartitioning partition, int partitionId) {
        String string = partition.getShortName();
        String string2 = this.RoundRobinPartitioningShortName();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return new XORShiftRandom((long)partitionId).nextInt(partition.getNumPartitions());
        }
        return 0;
    }

    public String getCompressionCodec(SparkConf conf) {
        GlutenConfig glutenConfig = GlutenConfig$.MODULE$.get();
        Option<String> option = glutenConfig.columnarShuffleCodec();
        if (option instanceof Some) {
            Some some = (Some)option;
            String codec = (String)some.value();
            String glutenCodecKey = GlutenConfig$.MODULE$.COLUMNAR_SHUFFLE_CODEC().key();
            if (glutenConfig.columnarShuffleEnableQat()) {
                GlutenShuffleUtils$.checkCodecValues$1(glutenCodecKey, codec, GlutenConfig$.MODULE$.GLUTEN_QAT_SUPPORTED_CODEC());
            } else {
                GlutenShuffleUtils$.checkCodecValues$1(glutenCodecKey, codec, BackendsApiManager$.MODULE$.getSettings().shuffleSupportedCodec());
            }
            return codec;
        }
        if (None$.MODULE$.equals(option)) {
            String sparkCodecKey = package$.MODULE$.IO_COMPRESSION_CODEC().key();
            String codec = conf.get(sparkCodecKey, package$.MODULE$.IO_COMPRESSION_CODEC().defaultValueString()).toLowerCase(Locale.ROOT);
            GlutenShuffleUtils$.checkCodecValues$1(sparkCodecKey, codec, BackendsApiManager$.MODULE$.getSettings().shuffleSupportedCodec());
            return codec;
        }
        throw new MatchError(option);
    }

    public int getCompressionLevel(SparkConf conf, String codec) {
        if ("zstd".equals(codec)) {
            return conf.getInt(package$.MODULE$.IO_COMPRESSION_ZSTD_LEVEL().key(), BoxesRunTime.unboxToInt((Object)package$.MODULE$.IO_COMPRESSION_ZSTD_LEVEL().defaultValue().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1)));
        }
        return this.DEFAULT_COMPRESSION_LEVEL();
    }

    public int getCompressionBufferSize(SparkConf conf, String codec) {
        if ("lz4".equals(codec)) {
            return GlutenShuffleUtils$.checkAndGetBufferSize$1(package$.MODULE$.IO_COMPRESSION_LZ4_BLOCKSIZE(), conf);
        }
        if ("zstd".equals(codec)) {
            return GlutenShuffleUtils$.checkAndGetBufferSize$1(package$.MODULE$.IO_COMPRESSION_ZSTD_BUFFERSIZE(), conf);
        }
        if ("gzip".equals(codec)) {
            return 32768;
        }
        throw new UnsupportedOperationException("Unsupported compression codec " + codec + ".");
    }

    public <K, C> Tuple2<Iterator<Tuple2<BlockManagerId, scala.collection.immutable.Seq<Tuple3<BlockId, Object, Object>>>>, Object> getReaderParam(ShuffleHandle handle, int startMapIndex, int endMapIndex, int startPartition, int endPartition) {
        return SparkShimLoader$.MODULE$.getSparkShims().getShuffleReaderParam(handle, startMapIndex, endMapIndex, startPartition, endPartition);
    }

    public <K, V> ShuffleWriter<K, V> getSortShuffleWriter(ShuffleHandle handle, long mapId, TaskContext context, ShuffleWriteMetricsReporter metrics, ShuffleExecutorComponents shuffleExecutorComponents) {
        ShuffleHandle shuffleHandle = handle;
        if (shuffleHandle instanceof BaseShuffleHandle) {
            BaseShuffleHandle baseShuffleHandle = (BaseShuffleHandle)shuffleHandle;
            return SparkSortShuffleWriterUtil$.MODULE$.create(baseShuffleHandle, mapId, context, metrics, shuffleExecutorComponents);
        }
        throw new MatchError((Object)shuffleHandle);
    }

    public <K, V> ShuffleWriter<K, V> genColumnarShuffleWriter(IndexShuffleBlockResolver shuffleBlockResolver, ColumnarShuffleHandle<K, V> columnarShuffleHandle, long mapId, ShuffleWriteMetricsReporter metrics) {
        return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genColumnarShuffleWriter(new GenShuffleWriterParameters<K, V>(shuffleBlockResolver, columnarShuffleHandle, mapId, metrics)).shuffleWriter();
    }

    public <K, C> ShuffleReader<K, C> genColumnarShuffleReader(ShuffleHandle handle, int startMapIndex, int endMapIndex, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        Tuple2<Iterator<Tuple2<BlockManagerId, scala.collection.immutable.Seq<Tuple3<BlockId, Object, Object>>>>, Object> tuple2 = this.getReaderParam(handle, startMapIndex, endMapIndex, startPartition, endPartition);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Iterator blocksByAddress = (Iterator)tuple2._1();
        boolean canEnableBatchFetch = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)blocksByAddress, (Object)BoxesRunTime.boxToBoolean((boolean)canEnableBatchFetch));
        Iterator blocksByAddress2 = (Iterator)tuple22._1();
        boolean canEnableBatchFetch2 = tuple22._2$mcZ$sp();
        boolean shouldBatchFetch = canEnableBatchFetch2 && SortShuffleManager$.MODULE$.canUseBatchFetch(startPartition, endPartition, context);
        return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genColumnarShuffleReader(new GenShuffleReaderParameters((BaseShuffleHandle)handle, (Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>>)blocksByAddress2, context, metrics, shouldBatchFetch)).shuffleReader();
    }

    private static final void checkCodecValues$1(String codecConf, String codec, Set validValues) {
        if (!validValues.contains((Object)codec)) {
            throw new IllegalArgumentException("The value of " + codecConf + " should be one of " + validValues.mkString(", ") + ", but was " + codec);
        }
    }

    private static final int checkAndGetBufferSize$1(ConfigEntry entry, SparkConf conf$1) {
        int bufferSize = (int)BoxesRunTime.unboxToLong((Object)conf$1.get(entry));
        if (bufferSize < 4) {
            throw new IllegalArgumentException(entry.key() + " must be >= 4, got " + bufferSize);
        }
        return bufferSize;
    }

    private GlutenShuffleUtils$() {
    }
}

