/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.gluten.memory.memtarget.DynamicOffHeapSizingMemoryTarget;
import org.apache.gluten.memory.memtarget.KnownNameAndStats;
import org.apache.gluten.memory.memtarget.LoggingMemoryTarget;
import org.apache.gluten.memory.memtarget.MemoryTarget;
import org.apache.gluten.memory.memtarget.MemoryTargetVisitor;
import org.apache.gluten.memory.memtarget.NoopMemoryTarget;
import org.apache.gluten.memory.memtarget.OverAcquire;
import org.apache.gluten.memory.memtarget.RetryOnOomMemoryTarget;
import org.apache.gluten.memory.memtarget.ThrowOnOomMemoryTarget;
import org.apache.gluten.memory.memtarget.spark.RegularMemoryConsumer;
import org.apache.gluten.memory.memtarget.spark.TreeMemoryConsumer;
import org.apache.gluten.proto.MemoryUsageStats;
import org.apache.gluten.shaded.com.google.common.base.Preconditions;
import org.apache.spark.SparkEnv$;
import org.apache.spark.memory.ExecutionMemoryPool;
import org.apache.spark.memory.GlobalOffHeapMemoryTarget;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.SparkMemoryUtil;
import org.apache.spark.memory.StorageMemoryPool;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class SparkMemoryUtil$ {
    public static final SparkMemoryUtil$ MODULE$ = new SparkMemoryUtil$();
    private static final Class<MemoryManager> mmClazz = MemoryManager.class;
    private static final Field smpField = MODULE$.mmClazz().getDeclaredField("offHeapStorageMemoryPool");
    private static final Field empField = MODULE$.mmClazz().getDeclaredField("offHeapExecutionMemoryPool");
    private static final Class<TaskMemoryManager> tmmClazz;
    private static final Field consumersField;
    private static final Field org$apache$spark$memory$SparkMemoryUtil$$taskIdField;

    static {
        MODULE$.smpField().setAccessible(true);
        MODULE$.empField().setAccessible(true);
        tmmClazz = TaskMemoryManager.class;
        consumersField = MODULE$.tmmClazz().getDeclaredField("consumers");
        org$apache$spark$memory$SparkMemoryUtil$$taskIdField = MODULE$.tmmClazz().getDeclaredField("taskAttemptId");
        MODULE$.consumersField().setAccessible(true);
        MODULE$.org$apache$spark$memory$SparkMemoryUtil$$taskIdField().setAccessible(true);
    }

    private Class<MemoryManager> mmClazz() {
        return mmClazz;
    }

    private Field smpField() {
        return smpField;
    }

    private Field empField() {
        return empField;
    }

    private Class<TaskMemoryManager> tmmClazz() {
        return tmmClazz;
    }

    private Field consumersField() {
        return consumersField;
    }

    public Field org$apache$spark$memory$SparkMemoryUtil$$taskIdField() {
        return org$apache$spark$memory$SparkMemoryUtil$$taskIdField;
    }

    public String bytesToString(long size) {
        return Utils$.MODULE$.bytesToString(size);
    }

    public long getCurrentAvailableOffHeapMemory() {
        MemoryManager mm4 = SparkEnv$.MODULE$.get().memoryManager();
        StorageMemoryPool smp = (StorageMemoryPool)this.smpField().get(mm4);
        ExecutionMemoryPool emp = (ExecutionMemoryPool)this.empField().get(mm4);
        return smp.memoryFree() + emp.memoryFree();
    }

    public String dumpMemoryManagerStats(TaskMemoryManager tmm) {
        KnownNameAndStats knownNameAndStats;
        TaskMemoryManager taskMemoryManager = tmm;
        synchronized (taskMemoryManager) {
            HashSet consumers = (HashSet)this.consumersField().get(tmm);
            HashMap statsMap = new HashMap();
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter((Set)consumers).asScala()).foreach((Function1 & Serializable)x0$1 -> {
                MemoryConsumer memoryConsumer = x0$1;
                if (memoryConsumer instanceof KnownNameAndStats) {
                    MemoryConsumer memoryConsumer2 = memoryConsumer;
                    return statsMap.put(((KnownNameAndStats)memoryConsumer2).name(), ((KnownNameAndStats)memoryConsumer2).stats());
                }
                return statsMap.put(memoryConsumer.toString(), MemoryUsageStats.newBuilder().setCurrent(memoryConsumer.getUsed()).setPeak(-1L).build());
            });
            Preconditions.checkState(statsMap.size() == consumers.size());
            knownNameAndStats = new KnownNameAndStats(tmm, statsMap){
                private final TaskMemoryManager tmm$1;
                private final HashMap statsMap$1;

                public String name() {
                    return "Task." + SparkMemoryUtil$.MODULE$.org$apache$spark$memory$SparkMemoryUtil$$taskIdField().get(this.tmm$1);
                }

                public MemoryUsageStats stats() {
                    return MemoryUsageStats.newBuilder().setCurrent(this.tmm$1.getMemoryConsumptionForThisTask()).setPeak(-1L).putAllChildren(this.statsMap$1).build();
                }
                {
                    this.tmm$1 = tmm$1;
                    this.statsMap$1 = statsMap$1;
                }
            };
        }
        KnownNameAndStats stats = knownNameAndStats;
        return this.prettyPrintStats("Memory consumer stats: ", stats);
    }

    public String dumpMemoryTargetStats(MemoryTarget target) {
        return target.accept(new MemoryTargetVisitor<String>(){

            public String visit(OverAcquire overAcquire) {
                return overAcquire.getTarget().accept(this);
            }

            public String visit(RegularMemoryConsumer regularMemoryConsumer) {
                return this.collectFromTaskMemoryManager(regularMemoryConsumer.getTaskMemoryManager());
            }

            public String visit(ThrowOnOomMemoryTarget throwOnOomMemoryTarget) {
                return throwOnOomMemoryTarget.target().accept(this);
            }

            public String visit(TreeMemoryConsumer treeMemoryConsumer) {
                return this.collectFromTaskMemoryManager(treeMemoryConsumer.getTaskMemoryManager());
            }

            public String visit(TreeMemoryConsumer.Node node) {
                return node.parent().accept(this);
            }

            private String collectFromTaskMemoryManager(TaskMemoryManager tmm) {
                return SparkMemoryUtil$.MODULE$.dumpMemoryManagerStats(tmm);
            }

            public String visit(LoggingMemoryTarget loggingMemoryTarget) {
                return loggingMemoryTarget.delegated().accept(this);
            }

            public String visit(NoopMemoryTarget noopMemoryTarget) {
                return SparkMemoryUtil$.MODULE$.prettyPrintStats("No-op memory target stats: ", noopMemoryTarget);
            }

            public String visit(DynamicOffHeapSizingMemoryTarget dynamicOffHeapSizingMemoryTarget) {
                SparkMemoryUtil$.MODULE$.prettyPrintStats("Dynamic off-heap sizing memory target stats: ", dynamicOffHeapSizingMemoryTarget);
                return dynamicOffHeapSizingMemoryTarget.target().accept(this);
            }

            public String visit(RetryOnOomMemoryTarget retryOnOomMemoryTarget) {
                return retryOnOomMemoryTarget.target().accept(this);
            }

            public String visit(GlobalOffHeapMemoryTarget globalOffHeapMemoryTarget) {
                return SparkMemoryUtil$.MODULE$.prettyPrintStats("Global off-heap target stats: ", globalOffHeapMemoryTarget);
            }
        });
    }

    public String prettyPrintStats(String title, KnownNameAndStats stats) {
        return this.prettyPrintToString(title, SparkMemoryUtil$.asPrintable$1(stats.name(), stats.stats()));
    }

    private String prettyPrintToString(String title, SparkMemoryUtil.PrintableMemoryUsageStats stats) {
        StringBuilder sb = new StringBuilder();
        sb.append(title);
        IntRef nameWidth = IntRef.create((int)0);
        IntRef usedWidth = IntRef.create((int)0);
        IntRef peakWidth = IntRef.create((int)0);
        SparkMemoryUtil$.addPaddingSingleLevel$1(stats, Predef$.MODULE$.int2Integer(1), nameWidth, usedWidth, peakWidth);
        SparkMemoryUtil$.printSingleLevel$1(stats, "\t", "\t", sb, nameWidth, usedWidth, peakWidth);
        return sb.toString();
    }

    public static final /* synthetic */ long $anonfun$prettyPrintStats$1(SparkMemoryUtil.PrintableMemoryUsageStats x$1) {
        return BoxesRunTime.unboxToLong((Object)x$1.used().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> Long.MIN_VALUE));
    }

    private static final Seq sortStats$1(Seq stats) {
        return (Seq)stats.sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)SparkMemoryUtil$.$anonfun$prettyPrintStats$1(x$1)), Ordering.Long$.MODULE$.reverse());
    }

    private static final SparkMemoryUtil.PrintableMemoryUsageStats asPrintable$1(String name, MemoryUsageStats mus) {
        long l;
        return new SparkMemoryUtil.PrintableMemoryUsageStats(name, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)mus.getCurrent())), (Option<Object>)(-1L == (l = mus.getPeak()) ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)l))), (Iterable<SparkMemoryUtil.PrintableMemoryUsageStats>)SparkMemoryUtil$.sortStats$1((Seq)((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(mus.getChildrenMap().entrySet()).asScala()).toList().map((Function1 & Serializable)entry -> SparkMemoryUtil$.asPrintable$1((String)entry.getKey(), (MemoryUsageStats)entry.getValue()))));
    }

    private static final String getBytes$1(Option bytes) {
        return (String)bytes.map((Function1 & Serializable)size -> Utils$.MODULE$.bytesToString(BoxesRunTime.unboxToLong((Object)size))).getOrElse((Function0 & Serializable)() -> "N/A");
    }

    private static final String getFullName$1(String name, String prefix) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s%s:"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{prefix, name}));
    }

    private static final void addPaddingSingleLevel$1(SparkMemoryUtil.PrintableMemoryUsageStats stats, Integer extraWidth, IntRef nameWidth$1, IntRef usedWidth$1, IntRef peakWidth$1) {
        nameWidth$1.elem = Math.max(nameWidth$1.elem, SparkMemoryUtil$.getFullName$1(stats.name(), "").length() + Predef$.MODULE$.Integer2int(extraWidth));
        usedWidth$1.elem = Math.max(usedWidth$1.elem, SparkMemoryUtil$.getBytes$1(stats.used()).length());
        peakWidth$1.elem = Math.max(peakWidth$1.elem, SparkMemoryUtil$.getBytes$1(stats.peak()).length());
        stats.children().foreach((Function1 & Serializable)x$2 -> {
            SparkMemoryUtil$.addPaddingSingleLevel$1(x$2, Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(extraWidth) + 3), nameWidth$1, usedWidth$1, peakWidth$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$prettyPrintToString$4(SparkMemoryUtil.PrintableMemoryUsageStats stats$1, String treeChildrenPrefix$1, StringBuilder sb$1, IntRef nameWidth$1, IntRef usedWidth$1, IntRef peakWidth$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            SparkMemoryUtil.PrintableMemoryUsageStats child = (SparkMemoryUtil.PrintableMemoryUsageStats)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (i != stats$1.children().size() - 1) {
                SparkMemoryUtil$.printSingleLevel$1(child, treeChildrenPrefix$1 + "+- ", treeChildrenPrefix$1 + "|  ", sb$1, nameWidth$1, usedWidth$1, peakWidth$1);
                return;
            }
            SparkMemoryUtil$.printSingleLevel$1(child, treeChildrenPrefix$1 + "\\- ", treeChildrenPrefix$1 + "   ", sb$1, nameWidth$1, usedWidth$1, peakWidth$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final void printSingleLevel$1(SparkMemoryUtil.PrintableMemoryUsageStats stats, String treePrefix, String treeChildrenPrefix, StringBuilder sb$1, IntRef nameWidth$1, IntRef usedWidth$1, IntRef peakWidth$1) {
        sb$1.append(System.lineSeparator());
        String name = SparkMemoryUtil$.getFullName$1(stats.name(), treePrefix);
        sb$1.append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s Current used bytes: %s, peak bytes: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{StringUtils.rightPad((String)name, (int)nameWidth$1.elem, (char)' '), StringUtils.leftPad((String)String.valueOf(SparkMemoryUtil$.getBytes$1(stats.used())), (int)usedWidth$1.elem, (char)' '), StringUtils.leftPad((String)String.valueOf(SparkMemoryUtil$.getBytes$1(stats.peak())), (int)peakWidth$1.elem, (char)' ')})));
        ((IterableOnceOps)stats.children().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            SparkMemoryUtil$.$anonfun$prettyPrintToString$4(stats, treeChildrenPrefix, sb$1, nameWidth$1, usedWidth$1, peakWidth$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private SparkMemoryUtil$() {
    }
}

