/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.UUID;
import org.apache.gluten.config.GlutenCoreConfig$;
import org.apache.gluten.exception.GlutenException;
import org.apache.gluten.memory.MemoryUsageRecorder;
import org.apache.gluten.memory.SimpleMemoryUsageRecorder;
import org.apache.gluten.memory.memtarget.KnownNameAndStats;
import org.apache.gluten.memory.memtarget.MemoryTarget;
import org.apache.gluten.memory.memtarget.MemoryTargetUtil;
import org.apache.gluten.memory.memtarget.MemoryTargetVisitor;
import org.apache.gluten.proto.MemoryUsageStats;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.storage.BlockId$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001\u0002\n\u0014\u0001qAaa\u000e\u0001\u0005\u0002MA\u0004bB\u001e\u0001\u0005\u0004%I\u0001\u0010\u0005\u0007\u0001\u0002\u0001\u000b\u0011B\u001f\t\u000f\u0005\u0003!\u0019!C\u0005\u0005\"1q\t\u0001Q\u0001\n\rCq\u0001\u0013\u0001C\u0002\u0013%\u0011\n\u0003\u0004N\u0001\u0001\u0006IA\u0013\u0005\b\u001d\u0002\u0011\r\u0011\"\u0003P\u0011\u00191\u0006\u0001)A\u0005!\")q\u000b\u0001C!1\")\u0011\r\u0001C!E\")A\r\u0001C!K\")a\r\u0001C!O\"1\u0011\u0010\u0001C\u0001'iDq!a\u0001\u0001\t\u0013\t)\u0001C\u0004\u0002\u001a\u0001!\t%a\u0007\t\u000f\u0005E\u0002\u0001\"\u0011\u00024\tIr\t\\8cC2|eM\u001a%fCBlU-\\8ssR\u000b'oZ3u\u0015\t!R#\u0001\u0004nK6|'/\u001f\u0006\u0003-]\tQa\u001d9be.T!\u0001G\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0012aA8sO\u000e\u00011#\u0002\u0001\u001eK9\n\u0004C\u0001\u0010$\u001b\u0005y\"B\u0001\u0011\"\u0003\u0011a\u0017M\\4\u000b\u0003\t\nAA[1wC&\u0011Ae\b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u0019bS\"A\u0014\u000b\u0005!J\u0013!C7f[R\f'oZ3u\u0015\t!\"F\u0003\u0002,/\u00051q\r\\;uK:L!!L\u0014\u0003\u00195+Wn\u001c:z)\u0006\u0014x-\u001a;\u0011\u0005\u0019z\u0013B\u0001\u0019(\u0005EYen\\<o\u001d\u0006lW-\u00118e'R\fGo\u001d\t\u0003eUj\u0011a\r\u0006\u0003iU\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003mM\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002sA\u0011!\bA\u0007\u0002'\u0005QA/\u0019:hKRt\u0015-\\3\u0016\u0003u\u0002\"A\b \n\u0005}z\"AB*ue&tw-A\u0006uCJ<W\r\u001e(b[\u0016\u0004\u0013\u0001\u0003:fG>\u0014H-\u001a:\u0016\u0003\r\u0003\"\u0001R#\u000e\u0003%J!AR\u0015\u0003'5+Wn\u001c:z+N\fw-\u001a*fG>\u0014H-\u001a:\u0002\u0013I,7m\u001c:eKJ\u0004\u0013\u0001B7pI\u0016,\u0012A\u0013\t\u0003u-K!\u0001T\n\u0003\u00155+Wn\u001c:z\u001b>$W-A\u0003n_\u0012,\u0007%\u0001\u000bG\u0013\u0016cEiX'F\u001b>\u0013\u0016lX'B\u001d\u0006;UIU\u000b\u0002!B\u0011\u0011\u000bV\u0007\u0002%*\u00111kH\u0001\be\u00164G.Z2u\u0013\t)&KA\u0003GS\u0016dG-A\u000bG\u0013\u0016cEiX'F\u001b>\u0013\u0016lX'B\u001d\u0006;UI\u0015\u0011\u0002\r\t|'O]8x)\tIv\f\u0005\u0002[;6\t1LC\u0001]\u0003\u0015\u00198-\u00197b\u0013\tq6L\u0001\u0003M_:<\u0007\"\u00021\u000b\u0001\u0004I\u0016\u0001B:ju\u0016\fQA]3qCf$\"!W2\t\u000b\u0001\\\u0001\u0019A-\u0002\u0013U\u001cX\r\u001a\"zi\u0016\u001cH#A-\u0002\r\u0005\u001c7-\u001a9u+\tA7\u000e\u0006\u0002jiB\u0011!n\u001b\u0007\u0001\t\u0015aWB1\u0001n\u0005\u0005!\u0016C\u00018r!\tQv.\u0003\u0002q7\n9aj\u001c;iS:<\u0007C\u0001.s\u0013\t\u00198LA\u0002B]fDQ!^\u0007A\u0002Y\fqA^5tSR|'\u000fE\u0002'o&L!\u0001_\u0014\u0003'5+Wn\u001c:z)\u0006\u0014x-\u001a;WSNLGo\u001c:\u0002'5,Wn\u001c:z\u001b\u0006t\u0017mZ3s\u001fB$\u0018n\u001c8\u0015\u0003m\u00042A\u0017?\u007f\u0013\ti8L\u0001\u0004PaRLwN\u001c\t\u0003u}L1!!\u0001\u0014\u00055iU-\\8ss6\u000bg.Y4fe\u0006aRM\\:ve\u0016lU-\\8ssN#xN]3J]&$\u0018.\u00197ju\u0016$G\u0003BA\u0004\u0003\u001b\u00012AWA\u0005\u0013\r\tYa\u0017\u0002\u0005+:LG\u000fC\u0004\u0002\u0010=\u0001\r!!\u0005\u0002\u0007\u0015tg\u000f\u0005\u0003\u0002\u0014\u0005UQ\"A\u000b\n\u0007\u0005]QC\u0001\u0005Ta\u0006\u00148.\u00128w\u0003\u0011q\u0017-\\3\u0015\u0005\u0005u\u0001\u0003BA\u0010\u0003[qA!!\t\u0002*A\u0019\u00111E.\u000e\u0005\u0005\u0015\"bAA\u00147\u00051AH]8pizJ1!a\u000b\\\u0003\u0019\u0001&/\u001a3fM&\u0019q(a\f\u000b\u0007\u0005-2,A\u0003ti\u0006$8\u000f\u0006\u0002\u00026A!\u0011qGA\u001f\u001b\t\tIDC\u0002\u0002<)\nQ\u0001\u001d:pi>LA!a\u0010\u0002:\t\u0001R*Z7pef,6/Y4f'R\fGo\u001d")
public class GlobalOffHeapMemoryTarget
implements MemoryTarget,
KnownNameAndStats,
Logging {
    private final String targetName;
    private final MemoryUsageRecorder recorder;
    private final MemoryMode mode;
    private final Field FIELD_MEMORY_MANAGER;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String targetName() {
        return this.targetName;
    }

    private MemoryUsageRecorder recorder() {
        return this.recorder;
    }

    private MemoryMode mode() {
        return this.mode;
    }

    private Field FIELD_MEMORY_MANAGER() {
        return this.FIELD_MEMORY_MANAGER;
    }

    @Override
    public long borrow(long size) {
        long l;
        Object object = new Object();
        try {
            l = BoxesRunTime.unboxToLong((Object)this.memoryManagerOption().map((Function1 & Serializable)mm4 -> BoxesRunTime.boxToLong((long)GlobalOffHeapMemoryTarget.$anonfun$borrow$1(this, size, object, mm4))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> size));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                l = ex.value$mcJ$sp();
            }
            throw ex;
        }
        return l;
    }

    @Override
    public long repay(long size) {
        return BoxesRunTime.unboxToLong((Object)this.memoryManagerOption().map((Function1 & Serializable)mm4 -> BoxesRunTime.boxToLong((long)GlobalOffHeapMemoryTarget.$anonfun$repay$1(this, size, mm4))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> size));
    }

    @Override
    public long usedBytes() {
        return this.recorder().current();
    }

    @Override
    public <T> T accept(MemoryTargetVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Option<MemoryManager> memoryManagerOption() {
        SparkEnv env = SparkEnv$.MODULE$.get();
        if (env != null) {
            this.ensureMemoryStoreInitialized(env);
            return new Some((Object)env.memoryManager());
        }
        TaskContext tc = TaskContext$.MODULE$.get();
        if (tc != null) {
            return new Some((Object)((MemoryManager)this.FIELD_MEMORY_MANAGER().get(tc.taskMemoryManager())));
        }
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Memory manager not found because the code is unlikely be run in a Spark application");
        return None$.MODULE$;
    }

    private void ensureMemoryStoreInitialized(SparkEnv env) {
        Predef$.MODULE$.assert(env.blockManager().memoryStore() != null);
    }

    @Override
    public String name() {
        return this.targetName();
    }

    @Override
    public MemoryUsageStats stats() {
        return this.recorder().toStats();
    }

    public static final /* synthetic */ boolean $anonfun$mode$1(SparkEnv x$1) {
        return x$1.conf().getBoolean(GlutenCoreConfig$.MODULE$.DYNAMIC_OFFHEAP_SIZING_ENABLED().key(), false);
    }

    private static final /* synthetic */ Field liftedTree1$1() {
        Field field;
        try {
            field = TaskMemoryManager.class.getDeclaredField("memoryManager");
        }
        catch (Exception e) {
            throw new GlutenException("Unable to find field TaskMemoryManager#memoryManager via reflection", e);
        }
        return field;
    }

    public static final /* synthetic */ long $anonfun$borrow$1(GlobalOffHeapMemoryTarget $this, long size$1, Object nonLocalReturnKey1$1, MemoryManager mm4) {
        boolean succeeded = mm4.acquireStorageMemory(BlockId$.MODULE$.apply("test_" + UUID.randomUUID()), size$1, $this.mode());
        if (succeeded) {
            $this.recorder().inc(size$1);
            return size$1;
        }
        MemoryMode memoryMode = $this.mode();
        MemoryMode memoryMode2 = MemoryMode.ON_HEAP;
        if (!(memoryMode != null ? !memoryMode.equals(memoryMode2) : memoryMode2 != null)) {
            long storageUsed = mm4.onHeapStorageMemoryUsed();
            long executionUsed = mm4.onHeapExecutionMemoryUsed();
            long onHeapMemoryTotal = storageUsed + executionUsed;
            $this.logError((Function0<String>)(Function0 & Serializable)() -> "Spark on-heap memory is exhausted. Requested: " + size$1 + ", Storage: " + storageUsed + " / " + onHeapMemoryTotal + ", Execution: " + executionUsed + " / " + onHeapMemoryTotal);
            throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey1$1, 0L);
        }
        long storageUsed = mm4.offHeapStorageMemoryUsed();
        long executionUsed = mm4.offHeapExecutionMemoryUsed();
        long offHeapMemoryTotal = storageUsed + executionUsed;
        $this.logError((Function0<String>)(Function0 & Serializable)() -> "Spark off-heap memory is exhausted. Storage: " + storageUsed + " / " + offHeapMemoryTotal + ", execution: " + executionUsed + " / " + offHeapMemoryTotal);
        throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey1$1, 0L);
    }

    public static final /* synthetic */ long $anonfun$repay$1(GlobalOffHeapMemoryTarget $this, long size$2, MemoryManager mm4) {
        mm4.releaseStorageMemory(size$2, $this.mode());
        $this.recorder().inc(-size$2);
        return size$2;
    }

    /*
     * WARNING - void declaration
     */
    public GlobalOffHeapMemoryTarget() {
        void var2_2;
        Logging.$init$((Logging)this);
        this.targetName = MemoryTargetUtil.toUniqueName("GlobalOffHeap");
        this.recorder = new SimpleMemoryUsageRecorder();
        boolean enabled = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GlobalOffHeapMemoryTarget.$anonfun$mode$1(x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        this.mode = enabled ? MemoryMode.ON_HEAP : MemoryMode.OFF_HEAP;
        Field f = GlobalOffHeapMemoryTarget.liftedTree1$1();
        f.setAccessible(true);
        this.FIELD_MEMORY_MANAGER = var2_2;
    }
}

