/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class HdfsConfGenerator$
implements Logging {
    public static final HdfsConfGenerator$ MODULE$;
    private static final Method addFileMethod;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        MODULE$ = new HdfsConfGenerator$();
        Logging.$init$((Logging)MODULE$);
        Method m4 = SparkContext.class.getDeclaredMethod("addFile", String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
        m4.setAccessible(true);
        addFileMethod = var0;
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Method addFileMethod() {
        return addFileMethod;
    }

    private void addFileOnSubmit(SparkContext sc, String path) {
        this.addFileMethod().invoke((Object)sc, path, BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false));
        Predef$.MODULE$.assert(sc.listFiles().nonEmpty());
        sc.conf().set("spark.app.initial.file.urls", sc.listFiles().mkString(","));
    }

    private boolean ignoreKey(String key) {
        return key.startsWith("yarn.") || key.startsWith("mapreduce.") || key.startsWith("hive.") || key.startsWith("io.") || key.startsWith("ipc.");
    }

    private boolean hasLibHdfsConf(SparkContext sc) {
        return sc.conf().getExecutorEnv().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).contains((Object)"LIBHDFS3_CONF") || sc.listFiles().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("hdfs-client.xml"))) || package$.MODULE$.env().get((Object)"SPARK_CONF_DIR").orElse((Function0 & Serializable)() -> package$.MODULE$.env().get((Object)"SPARK_HOME").map((Function1 & Serializable)t2 -> t2 + File.separator + "conf")).exists((Function1 & Serializable)conf -> BoxesRunTime.boxToBoolean((boolean)HdfsConfGenerator$.$anonfun$hasLibHdfsConf$4(conf)));
    }

    public void addHdfsClientToSparkWorkDirectory(SparkContext sc) {
        if (sc.hadoopConfiguration().get("dfs.nameservices") == null) {
            return;
        }
        if (this.hasLibHdfsConf(sc)) {
            return;
        }
        File tmp = Utils$.MODULE$.createTempDir();
        File hdfsClientConfFile = new File(tmp, "hdfs-client.xml");
        try (FileOutputStream output = new FileOutputStream(hdfsClientConfFile);){
            Configuration config = new Configuration(false);
            ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(sc.hadoopConfiguration().iterator()).asScala()).filterNot((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)HdfsConfGenerator$.MODULE$.ignoreKey((String)x.getKey()))).foreach((Function1 & Serializable)x -> {
                config.set((String)x.getKey(), (String)x.getValue());
                return BoxedUnit.UNIT;
            });
            config.writeXml((OutputStream)output);
            String tmpPath = hdfsClientConfFile.getAbsolutePath();
            this.addFileOnSubmit(sc, tmpPath);
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Added hdfs-client.xml for libhdfs, tmp path: " + tmpPath + ".");
        }
    }

    public static final /* synthetic */ boolean $anonfun$hasLibHdfsConf$4(String conf) {
        return new File(conf + File.separator + "hdfs-client.xml").isFile();
    }

    private HdfsConfGenerator$() {
    }
}

