/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.InodeTree;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;

public final class ViewFileSystemUtils$ {
    public static final ViewFileSystemUtils$ MODULE$ = new ViewFileSystemUtils$();

    public String convertViewfsToHdfs(String f, Configuration hadoopConfig) {
        Path path = new Path(f);
        FileSystem fileSystem = FileSystem.get((URI)path.toUri(), (Configuration)hadoopConfig);
        if (fileSystem instanceof ViewFileSystem) {
            ViewFileSystem viewFileSystem = (ViewFileSystem)fileSystem;
            InodeTree.ResolveResult res = viewFileSystem.fsState.resolve(f, true);
            if (res.isInternalDir()) {
                return f;
            }
            return Path.mergePaths((Path)new Path(((FileSystem)res.targetFileSystem).getUri()), (Path)res.remainingPath).toString();
        }
        return fileSystem.resolvePath(path).toString();
    }

    public Seq<String> convertViewfsToHdfs(Seq<String> paths, Map<String, String> viewfsToHdfsCache, Configuration hadoopConfig) {
        return (Seq)paths.map((Function1 & Serializable)path -> {
            if (path.startsWith("viewfs")) {
                String[] pathSplit = path.split("/");
                int prefixIndex = ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])pathSplit)) - 1;
                String pathPrefix = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])pathSplit), prefixIndex)).mkString("/");
                String hdfsPath = (String)viewfsToHdfsCache.getOrElseUpdate((Object)pathPrefix, (Function0 & Serializable)() -> MODULE$.convertViewfsToHdfs(pathPrefix, hadoopConfig));
                return hdfsPath + "/" + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.refArrayOps((Object[])pathSplit), prefixIndex)).mkString("/");
            }
            return path;
        });
    }

    private ViewFileSystemUtils$() {
    }
}

