/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.vectorized;

import java.io.IOException;
import java.io.InputStream;
import org.apache.gluten.exception.GlutenException;
import org.apache.gluten.vectorized.JniByteInputStream;

public class OnHeapJniByteInputStream
implements JniByteInputStream {
    private final InputStream in;
    private long bytesRead = 0L;

    public OnHeapJniByteInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public long read(long destAddress, long maxSize) {
        int maxSize32 = Math.toIntExact(maxSize);
        byte[] tmp = new byte[maxSize32];
        try {
            int read = this.in.read(tmp);
            if (read == -1 || read == 0) {
                return 0L;
            }
            this.memCopyFromHeap(tmp, destAddress, read);
            this.bytesRead += (long)read;
            return read;
        }
        catch (IOException e) {
            throw new GlutenException(e);
        }
    }

    @Override
    public long tell() {
        return this.bytesRead;
    }

    public native void memCopyFromHeap(byte[] var1, long var2, int var4);

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new GlutenException(e);
        }
    }
}

