/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.vectorized;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.gluten.memory.memtarget.MemoryTarget;
import org.apache.gluten.memory.memtarget.Spiller;
import org.apache.gluten.runtime.Runtime;
import org.apache.gluten.runtime.Runtimes;
import org.apache.gluten.utils.DebugUtil;
import org.apache.gluten.validate.NativePlanValidationInfo;
import org.apache.gluten.vectorized.ColumnarBatchInIterator;
import org.apache.gluten.vectorized.ColumnarBatchOutIterator;
import org.apache.gluten.vectorized.PlanEvaluatorJniWrapper;
import org.apache.spark.TaskContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativePlanEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativePlanEvaluator.class);
    private static final AtomicInteger id = new AtomicInteger(0);
    private final Runtime runtime;
    private final PlanEvaluatorJniWrapper jniWrapper;

    private NativePlanEvaluator(Runtime runtime) {
        this.runtime = runtime;
        this.jniWrapper = PlanEvaluatorJniWrapper.create(runtime);
    }

    public static NativePlanEvaluator create(String backendName, Map<String, String> extraConf) {
        return new NativePlanEvaluator(Runtimes.contextInstance(backendName, String.format("NativePlanEvaluator-%d", id.getAndIncrement()), extraConf));
    }

    public static NativePlanEvaluator create(String backendName) {
        return new NativePlanEvaluator(Runtimes.contextInstance(backendName, String.format("NativePlanEvaluator-%d", id.getAndIncrement())));
    }

    public NativePlanValidationInfo doNativeValidateWithFailureReason(byte[] subPlan) {
        return this.jniWrapper.nativeValidateWithFailureReason(subPlan);
    }

    public boolean doNativeValidateExpression(byte[] expression, byte[] inputType, byte[][] mapping) {
        return this.jniWrapper.nativeValidateExpression(expression, inputType, mapping);
    }

    public static void injectWriteFilesTempPath(String path, String fileName) {
        PlanEvaluatorJniWrapper.injectWriteFilesTempPath(path.getBytes(StandardCharsets.UTF_8), fileName.getBytes(StandardCharsets.UTF_8));
    }

    public ColumnarBatchOutIterator createKernelWithBatchIterator(byte[] wsPlan, byte[][] splitInfo, ColumnarBatchInIterator[] iterList, int partitionIndex, String spillDirPath) throws RuntimeException {
        long itrHandle = this.jniWrapper.nativeCreateKernelWithIterator(wsPlan, splitInfo, iterList, TaskContext.get().stageId(), partitionIndex, TaskContext.get().taskAttemptId(), DebugUtil.isDumpingEnabledForTask(), spillDirPath);
        final ColumnarBatchOutIterator out = this.createOutIterator(this.runtime, itrHandle);
        this.runtime.memoryManager().addSpiller(new Spiller(){

            @Override
            public long spill(MemoryTarget self, Spiller.Phase phase, long size) {
                if (!Spiller.Phase.SPILL.equals((Object)phase)) {
                    return 0L;
                }
                long spilled = out.spill(size);
                LOGGER.info("NativePlanEvaluator-{}: Spilled {} / {} bytes of data.", new Object[]{id.get(), spilled, size});
                return spilled;
            }
        });
        return out;
    }

    private ColumnarBatchOutIterator createOutIterator(Runtime runtime, long itrHandle) {
        return new ColumnarBatchOutIterator(runtime, itrHandle);
    }
}

