/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.vectorized;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import org.apache.gluten.exception.GlutenException;
import org.apache.gluten.vectorized.JniByteInputStream;
import org.apache.gluten.vectorized.JniByteInputStreams;

public class LowCopyNettyJniByteInputStream
implements JniByteInputStream {
    private static final Field FIELD_ByteBufInputStream_buffer;
    private final InputStream in;
    private ByteBuf byteBuf;
    private int readBytesCount = 0;

    public LowCopyNettyJniByteInputStream(InputStream in) {
        this.in = in;
        InputStream unwrapped = JniByteInputStreams.unwrapSparkInputStream(in);
        try {
            this.byteBuf = (ByteBuf)FIELD_ByteBufInputStream_buffer.get(unwrapped);
        }
        catch (IllegalAccessException e) {
            throw new GlutenException(e);
        }
    }

    @Override
    public long read(long destAddress, long maxSize) {
        long bytesToRead = Math.min(maxSize, (long)this.byteBuf.readableBytes());
        int bytesToRead32 = Math.toIntExact(bytesToRead);
        if (bytesToRead32 == 0) {
            return 0L;
        }
        ByteBuffer direct = PlatformDependent.directBuffer((long)destAddress, (int)bytesToRead32);
        this.byteBuf.readBytes(direct);
        this.readBytesCount += direct.position();
        return direct.position();
    }

    public static boolean isSupported(InputStream in) {
        if (!(in instanceof ByteBufInputStream)) {
            return false;
        }
        ByteBufInputStream bbin = (ByteBufInputStream)in;
        try {
            ByteBuf byteBuf = (ByteBuf)FIELD_ByteBufInputStream_buffer.get(bbin);
            return byteBuf.isDirect();
        }
        catch (IllegalAccessException e) {
            throw new GlutenException(e);
        }
    }

    @Override
    public long tell() {
        return this.readBytesCount;
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new GlutenException(e);
        }
    }

    static {
        try {
            FIELD_ByteBufInputStream_buffer = ByteBufInputStream.class.getDeclaredField("buffer");
            FIELD_ByteBufInputStream_buffer.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

