/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.vectorized;

import io.netty.util.internal.PlatformDependent;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.gluten.exception.GlutenException;
import org.apache.gluten.vectorized.JniByteInputStream;
import org.apache.gluten.vectorized.JniByteInputStreams;
import org.apache.spark.network.util.LimitedInputStream;

public class LowCopyFileSegmentJniByteInputStream
implements JniByteInputStream {
    private static final Field FIELD_FilterInputStream_in;
    private static final Field FIELD_LimitedInputStream_left;
    private final InputStream in;
    private final FileChannel channel;
    private long bytesRead = 0L;
    private long left;

    public LowCopyFileSegmentJniByteInputStream(InputStream in) {
        FileInputStream fin;
        this.in = in;
        InputStream unwrapped = JniByteInputStreams.unwrapSparkInputStream(in);
        LimitedInputStream lin = (LimitedInputStream)unwrapped;
        try {
            this.left = (Long)FIELD_LimitedInputStream_left.get(lin);
        }
        catch (IllegalAccessException e) {
            throw new GlutenException(e);
        }
        try {
            fin = (FileInputStream)FIELD_FilterInputStream_in.get(lin);
        }
        catch (IllegalAccessException e) {
            throw new GlutenException(e);
        }
        this.channel = fin.getChannel();
    }

    public static boolean isSupported(InputStream in) {
        InputStream wrapped;
        if (!(in instanceof LimitedInputStream)) {
            return false;
        }
        LimitedInputStream lin = (LimitedInputStream)in;
        try {
            wrapped = (InputStream)FIELD_FilterInputStream_in.get(lin);
        }
        catch (IllegalAccessException e) {
            throw new GlutenException(e);
        }
        return wrapped instanceof FileInputStream;
    }

    @Override
    public long read(long destAddress, long maxSize) {
        long bytesToRead = Math.min(this.left, maxSize);
        int bytesToRead32 = Math.toIntExact(bytesToRead);
        if (bytesToRead32 == 0) {
            return 0L;
        }
        ByteBuffer direct = PlatformDependent.directBuffer((long)destAddress, (int)bytesToRead32);
        try {
            int bytes = this.channel.read(direct);
            if (bytes == -1) {
                return 0L;
            }
            this.bytesRead += (long)bytes;
            this.left -= (long)bytes;
            return bytes;
        }
        catch (IOException e) {
            throw new GlutenException(e);
        }
    }

    @Override
    public long tell() {
        return this.bytesRead;
    }

    @Override
    public void close() {
        try {
            this.channel.close();
            this.in.close();
        }
        catch (IOException e) {
            throw new GlutenException(e);
        }
    }

    static {
        try {
            FIELD_FilterInputStream_in = FilterInputStream.class.getDeclaredField("in");
            FIELD_FilterInputStream_in.setAccessible(true);
            FIELD_LimitedInputStream_left = LimitedInputStream.class.getDeclaredField("left");
            FIELD_LimitedInputStream_left.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new GlutenException(e);
        }
    }
}

